package io.github.vampirestudios.vampirelib.api;

import ConversionItem;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_3414;
import net.minecraft.class_6862;
import record;

/**
 * This class is used to hold the link between two different blocks (See for example {@link OxidizableBlocksRegistry#registerOxidizableBlockPair(class_2248, class_2248)} and
 * {@link OxidizableBlocksRegistry#registerWaxableBlockPair(class_2248, class_2248)})
 **/
public class ConvertibleBlockPair {
	private final class_2248 original;
	private final class_2248 converted;
	private final ConversionItem conversionItem;
	private final ConversionItem reversingItem;
	private class_3414 sound;
	private class_1792 droppedItem;

	/**
	 * @param original        - The original block which will be converted
	 * @param converted       - The block that the original one will be converted to
	 * @param conversionItems - The item that is used to convert the original block into the converted block
	 **/
	public ConvertibleBlockPair(class_2248 original, class_2248 converted, ConversionItem conversionItems) {
		this(original, converted, conversionItems, null, null, null);
	}

	/**
	 * @param original        - The original block which will be converted
	 * @param converted       - The block that the original one will be converted to
	 * @param conversionItems - The item that is used to convert the original block into the converted block
	 * @param sound           - The item that is used to reverse the converted block into the original block
	 **/
	public ConvertibleBlockPair(class_2248 original, class_2248 converted, ConversionItem conversionItems, class_3414 sound) {
		this(original, converted, conversionItems, null, sound);
	}

	/**
	 * @param original        - The original block which will be converted
	 * @param converted       - The block that the original one will be converted to
	 * @param conversionItems - The item that is used to convert the original block into the converted block
	 * @param droppedItem    - The item that is dropped when converting the block
	 **/
	public ConvertibleBlockPair(class_2248 original, class_2248 converted, ConversionItem conversionItems, class_1792 droppedItem) {
		this(original, converted, conversionItems, null, null, droppedItem);
	}

	/**
	 * @param original        - The original block which will be converted
	 * @param converted       - The block that the original one will be converted to
	 * @param conversionItems - The item that is used to convert the original block into the converted block
	 * @param sound           - The item that is used to reverse the converted block into the original block
	 * @param droppedItem    - The item that is dropped when converting the block
	 **/
	public ConvertibleBlockPair(class_2248 original, class_2248 converted, ConversionItem conversionItems, class_3414 sound, class_1792 droppedItem) {
		this(original, converted, conversionItems, null, sound, droppedItem);
	}

	/**
	 * @param original       - The original block which will be converted
	 * @param converted      - The block that the original one will be converted to
	 * @param conversionItem - The item that is used to convert the original block into the converted block
	 * @param reversingItem  - The item that is used to reverse the converted block into the original block
	 **/
	public ConvertibleBlockPair(class_2248 original, class_2248 converted, ConversionItem conversionItem, ConversionItem reversingItem) {
		this(original, converted, conversionItem, reversingItem, null, null);
	}

	/**
	 * @param original       - The original block which will be converted
	 * @param converted      - The block that the original one will be converted to
	 * @param conversionItem - The item that is used to convert the original block into the converted block
	 * @param reversingItem  - The item that is used to reverse the converted block into the original block
	 * @param sound          - The item that is used to reverse the converted block into the original block
	 **/
	public ConvertibleBlockPair(class_2248 original, class_2248 converted, ConversionItem conversionItem, ConversionItem reversingItem, class_3414 sound) {
		this(original, converted, conversionItem, reversingItem, sound, null);
	}

	/**
	 * @param original       - The original block which will be converted
	 * @param converted      - The block that the original one will be converted to
	 * @param conversionItem - The item that is used to convert the original block into the converted block
	 * @param reversingItem  - The item that is used to reverse the converted block into the original block
	 * @param droppedItem    - The item that is dropped when converting the block
	 **/
	public ConvertibleBlockPair(class_2248 original, class_2248 converted, ConversionItem conversionItem, ConversionItem reversingItem, class_1792 droppedItem) {
		this(original, converted, conversionItem, reversingItem, null, droppedItem);
	}

	/**
	 * @param original       - The original block which will be converted
	 * @param converted      - The block that the original one will be converted to
	 * @param conversionItem - The item that is used to convert the original block into the converted block
	 * @param reversingItem  - The item that is used to reverse the converted block into the original block
	 * @param sound          - The item that is used to reverse the converted block into the original block
	 **/
	public ConvertibleBlockPair(class_2248 original, class_2248 converted, ConversionItem conversionItem, ConversionItem reversingItem, class_3414 sound, class_1792 droppedItem) {
		this.original = original;
		this.converted = converted;
		this.conversionItem = conversionItem;
		this.reversingItem = reversingItem;
		this.sound = sound;
		this.droppedItem = droppedItem;
	}

	public void setSound(class_3414 sound) {
		this.sound = sound;
	}

	public class_3414 getSound() {
		return sound;
	}

	public class_2248 getOriginal() {
		return original;
	}

	public class_2248 getConverted() {
		return converted;
	}

	public ConversionItem getConversionItem() {
		return conversionItem;
	}

	public ConversionItem getReversingItem() {
		return reversingItem;
	}

	public void setDroppedItem(class_1792 droppedItem) {
		this.droppedItem = droppedItem;
	}

	public class_1792 getDroppedItem() {
		return droppedItem;
	}

	public record ConversionItem(class_6862<class_1792> tag, class_1792 item) {
		public ConversionItem {
			if ((tag == null) == (item == null)) {
				throw new IllegalArgumentException("Only one of the fields must be non-null");
			}
		}

		public static ConversionItem of(TagKey<Item> tag) {
			return new ConversionItem(tag, null);
		}

		public static ConversionItem of(Item item) {
			return new ConversionItem(null, item);
		}

		// Call this by parsing the stack in hand
		public boolean matches(ItemStack stack) {
			if (this.tag != null) {
				return stack.is(this.tag);
			} else {
				return stack.is(this.item);
			}
		}
	}

}