/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.github.vampirestudios.vampirelib.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7403;

/**
 * <p>Register an instance of the class with {@link FabricDataGenerator#addProvider} in a {@link net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint}
 */
public abstract class FabricLanguageProvider implements class_2405 {
	private static final Logger LOGGER = LoggerFactory.getLogger(FabricLanguageProvider.class);
	private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

	private final Map<String, String> data = new TreeMap<>();
	protected final FabricDataGenerator dataGenerator;
	private final String modId;
	private final String locale;

	protected FabricLanguageProvider(FabricDataGenerator dataGenerator, String locale) {
		this.dataGenerator = dataGenerator;
		this.modId = dataGenerator.getModId();
		this.locale = locale;
	}

	public void addBlock(class_2248 key, String name) {
		add(key, name);
	}

	public void add(class_2248 key, String name) {
		add(key.method_9539(), name);
	}

	public void addItem(class_1792 key, String name) {
		add(key, name);
	}

	public void add(class_1792 key, String name) {
		add(key.method_7876(), name);
	}

	public void addItemStack(class_1799 key, String name) {
		add(key, name);
	}

	public void add(class_1799 key, String name) {
		add(key.method_7922(), name);
	}

	public void addEnchantment(class_1887 key, String name) {
		add(key, name);
	}

	public void add(class_1887 key, String name) {
		add(key.method_8184(), name);
	}

    public void addBiome(class_5321<class_1959> key, String name) {
        add(key.method_29177(), name);
    }
    public void add(class_2960 key, String name) {
        add("biome." + key.method_12836() + "." + key.method_12832(), name);
    }

	public void addEffect(class_1291 key, String name) {
		add(key, name);
	}

	public void add(class_1291 key, String name) {
		add(key.method_5567(), name);
	}

	public void addEntityType(class_1299<?> key, String name) {
		add(key, name);
	}

	public void add(class_1299<?> key, String name) {
		add(key.method_5882(), name);
	}

	public void add(String key, String value) {
		if (data.put(key, value) != null)
			throw new IllegalStateException("Duplicate translation key " + key);
	}

	/**
	 * Registers all translations to be placed inside the lang file.
	 */
	protected abstract void registerTranslations();

	@Override
	public void method_10319(@NotNull class_7403 cache) throws IOException {
		this.registerTranslations();

		Path path = this.dataGenerator.method_10313().resolve("assets/" + this.modId + "/lang/" + this.locale + ".json");
		try {
			JsonElement json = GSON.toJsonTree(this.data);
			class_2405.method_10320(GSON, cache, json, path);
		} catch (IOException e) {
			LOGGER.error("Couldn't save {}", path, e);
		}
	}

	@Override
	public String method_10321() {
		return "Language: " + locale;
	}
}