package io.github.vampirestudios.vampirelib.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_5944;
import org.jetbrains.annotations.ApiStatus;

public class ShaderRegistry {

    private static final Map<class_2960, class_293> REGISTERED_SHADERS = new ConcurrentHashMap<>();
    private static final Map<class_2960, class_5944> SHADERS = new HashMap<>();

    @ApiStatus.Internal
    public static void loadShader(class_2960 shader, class_5944 instance) {
        SHADERS.put(shader, instance);
    }

    public static void register(class_2960 shader, class_293 format) {
        REGISTERED_SHADERS.put(shader, format);
    }

    public static Supplier<class_5944> getShader(class_2960 shader) {
        return () -> SHADERS.get(shader);
    }

    public static Set<Map.Entry<class_2960, class_293>> getRegisteredShaders() {
        return REGISTERED_SHADERS.entrySet();
    }
}