package io.github.vampirestudios.vampirelib.api;

import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2350;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4590;

public interface TransformationExtensions {
	/**
	 * Apply this transformation to a different origin.
	 * Can be used for switching between coordinate systems.
	 * Parameter is relative to the current origin.
	 */
	default class_4590 applyOrigin(class_1160 origin) {
		throw new RuntimeException("this should be overridden via mixin. what?");
	}

	default class_4581 getNormalMatrix() {
		throw new RuntimeException("this should be overridden via mixin. what?");
	}

	default void push(class_4587 stack) {
		throw new RuntimeException("this should be overridden via mixin. what?");
	}

	default void transformPosition(class_1162 position) {
		throw new RuntimeException("this should be overridden via mixin. what?");
	}

	default class_2350 rotateTransform(class_2350 facing) {
		throw new RuntimeException("this should be overridden via mixin. what?");
	}

	default boolean isIdentity() {
		return this.equals(class_4590.method_22931());
	}

	default void transformNormal(class_1160 normal) {
		normal.method_23215(getNormalMatrix());
		normal.method_4952();
	}

	/**
	 * convert transformation from assuming center-block system to opposing-corner-block system
	 */
	default class_4590 blockCenterToCorner() {
		return applyOrigin(new class_1160(.5f, .5f, .5f));
	}

	/**
	 * convert transformation from assuming opposing-corner-block system to center-block system
	 */
	default class_4590 blockCornerToCenter() {
		return applyOrigin(new class_1160(-.5f, -.5f, -.5f));
	}
}