package io.github.vampirestudios.vampirelib.api;

import java.util.Map;
import java.util.Set;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.vampirestudios.vampirelib.utils.ItemStackUtils;

/**
 * Implementation class of {@link ItemGroupFiller} for filling {@link class_1792}s after a target {@link class_1792}.
 *
 * @see ItemGroupFiller
 */
public final class VanillaTargetedItemGroupFiller implements ItemGroupFiller {
	private final class_1792 targetItem;
	private final Map<class_1761, OffsetValue> offsetMap = Maps.newHashMap();

	public VanillaTargetedItemGroupFiller(class_1935 targetItem) {
		this.targetItem = targetItem.method_8389();
	}

	@Override
	public void fillItem(class_1792 item, class_1761 group, class_2371<class_1799> items) {
		if (ItemStackUtils.isAllowedInTab(item, group)) {
			OffsetValue offset = offsetMap.computeIfAbsent(group, key -> new OffsetValue());
			Set<class_1792> itemsProcessed = offset.itemsProcessed;
			if (itemsProcessed.contains(item)) {
				offset.reset();
			}
			int index = ItemStackUtils.findIndexOfItem(this.targetItem, items);
			if (index != -1) {
				items.add(index + offset.offset, new class_1799(item));
				itemsProcessed.add(item);
				offset.offset++;
			} else {
				items.add(new class_1799(item));
			}
		}
	}

	static class OffsetValue {
		private final Set<class_1792> itemsProcessed = Sets.newHashSet();
		private int offset = 1;

		/**
		 * Vanilla doesn't cache its item group items, so we must make sure the offsets are reset when the process is run again.
		 */
		private void reset() {
			this.offset = 1;
			this.itemsProcessed.clear();
		}
	}
}