/*
 * MIT License
 *
 * Copyright (c) 2020 Vampire Studios
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package io.github.vampirestudios.vampirelib.blocks;

import io.github.vampirestudios.vampirelib.api.ModdedTargetedItemGroupFiller;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_5955;

public class CompatOxidizableBlock extends class_2248 implements class_5955 {
    private final ModdedTargetedItemGroupFiller FILLER;
    private final class_5811 oxidizationLevel;

    public CompatOxidizableBlock(String modId, class_2248 modBlock, class_5811 oxidizationLevel, class_2251 settings) {
        super(settings);
        this.oxidizationLevel = oxidizationLevel;
        this.FILLER = new ModdedTargetedItemGroupFiller(modId, modBlock.method_8389());
    }

    @Override
    public void method_9578(class_1761 group, class_2371<class_1799> list) {
        FILLER.fillItem(this.method_8389(), group, list);
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.method_33621(state, world, pos, random);
    }

    @Override
    public boolean method_9542(class_2680 state) {
        return class_5955.method_34737(state.method_26204()).isPresent();
    }

    @Override
    public class_5811 method_33622() {
        return oxidizationLevel;
    }

}