package io.github.vampirestudios.vampirelib.callbacks.client;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1059;
import net.minecraft.class_2960;

public interface TextureStitchCallback {
    Event<Pre> PRE = EventFactory.createArrayBacked(Pre.class, callbacks -> (atlas, spriteAdder) -> {
        for (Pre e : callbacks)
            e.stitch(atlas, spriteAdder);
    });

    Event<Post> POST = EventFactory.createArrayBacked(Post.class, callbacks -> atlas -> {
        for (Post e : callbacks)
            e.stitch(atlas);
    });

    @Environment(EnvType.CLIENT)
    interface Pre {
        void stitch(class_1059 atlas, Consumer<class_2960> spriteAdder);
    }

    @Environment(EnvType.CLIENT)
    interface Post {
        void stitch(class_1059 atlas);
    }
}