package io.github.vampirestudios.vampirelib.client;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.class_1160;
import net.minecraft.class_7179;
import net.minecraft.class_7184;
import net.minecraft.class_7186;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class AnimationCodecs {
    public static final Codec<class_7179.class_7182> TARGET_CODEC = Codec.unit(() -> (modelPart, vec3f) ->{});
    public static final Codec<class_7179.class_7180> INTERPOLATION_CODEC = Codec.unit(() -> (vector3f, f, keyframes, i, j, g) -> null);
    public static final Codec<class_7186> KEYFRAME_CODEC = RecordCodecBuilder.create(
        instance -> instance.group(
            Codec.FLOAT.fieldOf("timestamp").forGetter(class_7186::comp_600),
            class_1160.field_28477.fieldOf("target").forGetter(class_7186::comp_601),
            INTERPOLATION_CODEC.fieldOf("interpolation").forGetter(class_7186::comp_602)
        ).apply(instance, class_7186::new)
    );
    public static final Codec<class_7179> ANIMATION_CHANNEL_CODEC = RecordCodecBuilder.create(
        instance -> instance.group(
            TARGET_CODEC.fieldOf("target").forGetter(class_7179::comp_595),
            KEYFRAME_CODEC.listOf().fieldOf("target").forGetter(o -> {
                class_7186[] keyframes = o.comp_596();
                return Arrays.stream(keyframes).collect(Collectors.toList());
            })
        ).apply(instance, (target, keyframes) -> new class_7179(target, (class_7186[]) keyframes.toArray()))
    );
    public static final Codec<class_7184> ANIMATION_DEFINITION_CODEC = RecordCodecBuilder.create(
        instance -> instance.group(
            Codec.FLOAT.fieldOf("lengthInSeconds").forGetter(class_7184::comp_597),
            Codec.BOOL.fieldOf("looping").forGetter(class_7184::comp_598),
            Codec.unboundedMap(Codec.STRING, ANIMATION_CHANNEL_CODEC.listOf()).fieldOf("boneAnimations")
                .forGetter(class_7184::comp_599)
        ).apply(instance, class_7184::new)
    );
}
