package io.github.vampirestudios.vampirelib.client;

import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_7184;
import var;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;

import com.mojang.serialization.JsonOps;
import io.github.vampirestudios.vampirelib.VampireLib;

/**
 * Handles the data-driven internals for {@link class_7184} instances.
 */
public final class AnimationLoader implements class_3302 {
	private static final JsonParser PARSER = new JsonParser();
	private final BiMap<class_2960, class_7184> registry = HashBiMap.create();

	/**
	 * Gets the {@link class_7184} mapped to a given {@link class_2960} key.
	 *
	 * @param key A {@link class_2960} key to use to look up its {@link class_7184}.
	 * @return The {@link class_7184} mapped to a given {@link class_2960} key, or null if no such mapping exists.
	 */
	@Nullable
	public class_7184 getAnimationDefinition(class_2960 key) {
		return this.registry.get(key);
	}

	/**
	 * Gets {@link class_2960} key for a given {@link class_7184}.
	 *
	 * @param animationDefinition An {@link class_7184} to use to look up its {@link class_2960} key.
	 * @return The {@link class_2960} key for a given {@link class_7184}, or null if no such key exists.
	 */
	@Nullable
	public class_2960 getKey(class_7184 animationDefinition) {
		return this.registry.inverse().get(animationDefinition);
	}

	@Override
	public CompletableFuture<Void> method_25931(class_4045 barrier, class_3300 manager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
		return CompletableFuture.supplyAsync(() -> {
			Map<class_2960, class_7184> animationDefinitions = new HashMap<>();
			for (class_2960 resourcelocation : manager.method_14488("models/entity/animations", (file) -> file.method_12832().endsWith(".json")).keySet()) {
				try (InputStreamReader inputStreamReader = new InputStreamReader(manager.method_14486(resourcelocation).orElseThrow().method_14482())) {
					var dataResult = AnimationCodecs.ANIMATION_DEFINITION_CODEC.decode(JsonOps.INSTANCE, PARSER.parse(inputStreamReader));
					var error = dataResult.error();
					if (error.isPresent()) {
						throw new JsonParseException(error.get().message());
					} else {
						String path = resourcelocation.method_12832();
						class_2960 adjustedLocation = new class_2960(resourcelocation.method_12836(), path.substring(12, path.length() - 5));
						if (animationDefinitions.put(adjustedLocation, dataResult.result().get().getFirst()) != null) {
							VampireLib.INSTANCE.getLogger().warn("Loaded Duplicate animation definition: {}", adjustedLocation);
						}
					}
				} catch (Exception exception) {
					VampireLib.INSTANCE.getLogger().error("Error while loading animation definition: {}", resourcelocation, exception);
				}
			}
			return animationDefinitions;
		}, executor).thenCompose(barrier::method_18352).thenAcceptAsync(animationDefinitions -> {
			BiMap<class_2960, class_7184> registry = this.registry;
			registry.clear();
			registry.putAll(animationDefinitions);
			VampireLib.INSTANCE.getLogger().info("Animation Loader has loaded {} animation definitions", registry.size());
		}, executor2);
	}
}