package io.github.vampirestudios.vampirelib.client;

import java.util.Calendar;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2618;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_4739;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_827;
import io.github.vampirestudios.vampirelib.ChestManager;
import io.github.vampirestudios.vampirelib.api.IChestBlock;

/**
 * The {@link class_827} responsible for the rendering of Blueprint's chests.
 *
 * @param <T> The type of {@link class_2618} the renderer is for.
 */
public class BlueprintChestBlockEntityRenderer<T extends class_2586 & class_2618> implements class_827<T> {
	public static class_2248 itemBlock = null;

	private final class_630 lid;
	private final class_630 bottom;
	private final class_630 lock;
	private final class_630 doubleLeftLid;
	private final class_630 doubleLeftBottom;
	private final class_630 doubleLeftLock;
	private final class_630 doubleRightLid;
	private final class_630 doubleRightBottom;
	private final class_630 doubleRightLock;
	public boolean isChristmas;

	public BlueprintChestBlockEntityRenderer(class_5614.class_5615 context) {
		Calendar calendar = Calendar.getInstance();
		if (calendar.get(Calendar.MONTH) + 1 == 12 && calendar.get(Calendar.DATE) >= 24 && calendar.get(Calendar.DATE) <= 26) {
			this.isChristmas = true;
		}
		class_630 modelpart = context.method_32140(class_5602.field_27689);
		this.bottom = modelpart.method_32086("bottom");
		this.lid = modelpart.method_32086("lid");
		this.lock = modelpart.method_32086("lock");
		class_630 modelpart1 = context.method_32140(class_5602.field_27551);
		this.doubleLeftBottom = modelpart1.method_32086("bottom");
		this.doubleLeftLid = modelpart1.method_32086("lid");
		this.doubleLeftLock = modelpart1.method_32086("lock");
		class_630 modelpart2 = context.method_32140(class_5602.field_27552);
		this.doubleRightBottom = modelpart2.method_32086("bottom");
		this.doubleRightLid = modelpart2.method_32086("lid");
		this.doubleRightLock = modelpart2.method_32086("lock");
	}

	@SuppressWarnings("rawtypes")
	public void method_3569(T tileEntityIn, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
		class_1937 world = tileEntityIn.method_10997();
		boolean flag = world != null;
		class_2680 blockstate = flag ? tileEntityIn.method_11010() : class_2246.field_10034.method_9564().method_11657(class_2281.field_10768, class_2350.field_11035);
		class_2745 chesttype = blockstate.method_28498(class_2281.field_10770) ? blockstate.method_11654(class_2281.field_10770) : class_2745.field_12569;
		class_2248 block = blockstate.method_26204();
		if (block instanceof class_4739) {
			class_4739<?> abstractchestblock = (class_4739) block;
			boolean flag1 = chesttype != class_2745.field_12569;
			matrixStackIn.method_22903();
			float f = blockstate.method_11654(class_2281.field_10768).method_10144();
			matrixStackIn.method_22904(0.5D, 0.5D, 0.5D);
			matrixStackIn.method_22907(class_1160.field_20705.method_23214(-f));
			matrixStackIn.method_22904(-0.5D, -0.5D, -0.5D);
			class_4732.class_4734<? extends class_2595> icallbackwrapper;
			if (flag) {
				icallbackwrapper = abstractchestblock.method_24167(blockstate, world, tileEntityIn.method_11016(), true);
			} else {
				icallbackwrapper = class_4732.class_3923::method_24174;
			}

			float f1 = icallbackwrapper.apply(class_2281.method_24166(tileEntityIn)).get(partialTicks);
			f1 = 1.0F - f1;
			f1 = 1.0F - f1 * f1 * f1;
			int i = icallbackwrapper.apply(new class_4737<>()).applyAsInt(combinedLightIn);
			class_4588 ivertexbuilder = this.getChestMaterial(tileEntityIn, chesttype).method_24145(bufferIn, class_1921::method_23576);
			if (flag1) {
				if (chesttype == class_2745.field_12574) {
					this.render(matrixStackIn, ivertexbuilder, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, combinedOverlayIn);
				} else {
					this.render(matrixStackIn, ivertexbuilder, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, combinedOverlayIn);
				}
			} else {
				this.render(matrixStackIn, ivertexbuilder, this.lid, this.lock, this.bottom, f1, i, combinedOverlayIn);
			}

			matrixStackIn.method_22909();
		}
	}

	public class_4730 getChestMaterial(T t, class_2745 type) {
		if (this.isChristmas) {
			return switch (type) {
				case SINGLE -> Sheets.CHEST_XMAS_LOCATION;
				case LEFT -> Sheets.CHEST_XMAS_LOCATION_LEFT;
				case RIGHT -> Sheets.CHEST_XMAS_LOCATION_RIGHT;
			};
		} else {
			class_2248 inventoryBlock = itemBlock;
			if (inventoryBlock == null) inventoryBlock = t.method_11010().method_26204();
			ChestManager.ChestInfo chestInfo = ChestManager.getInfoForChest(((IChestBlock) inventoryBlock).getChestType());
			return switch (type) {
				case SINGLE -> chestInfo != null ? chestInfo.getSingleMaterial() : Sheets.CHEST_LOCATION;
				case LEFT -> chestInfo != null ? chestInfo.getLeftMaterial() : Sheets.CHEST_LOCATION_LEFT;
				case RIGHT -> chestInfo != null ? chestInfo.getRightMaterial() : Sheets.CHEST_LOCATION_RIGHT;
			};
		}
	}

	public void render(class_4587 matrixStack, class_4588 builder, class_630 chestLid, class_630 chestLatch, class_630 chestBottom, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
		chestLid.field_3654 = -(lidAngle * ((float) Math.PI / 2F));
		chestLatch.field_3654 = chestLid.field_3654;
		chestLid.method_22698(matrixStack, builder, combinedLightIn, combinedOverlayIn);
		chestLatch.method_22698(matrixStack, builder, combinedLightIn, combinedOverlayIn);
		chestBottom.method_22698(matrixStack, builder, combinedLightIn, combinedOverlayIn);
	}
}