package io.github.vampirestudios.vampirelib.client;

import java.lang.reflect.Type;
import java.util.Map;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_3532;
import net.minecraft.class_4590;
import net.minecraft.class_804;
import io.github.vampirestudios.vampirelib.api.Matrix4fExtensions;
import io.github.vampirestudios.vampirelib.api.TransformationExtensions;

public final class TransformationHelper {
    private static final double THRESHOLD = 0.9995;

    @Deprecated
    @Environment(EnvType.CLIENT)
    // TODO: this is used in 3 places, not a trivial refactor. Needs investigating. -C
    public static class_4590 toTransformation(class_804 transform) {
        if (transform.equals(class_804.field_4284))
            return class_4590.method_22931();

        return new class_4590(transform.field_4286, quatFromXYZ(transform.field_4287, true), transform.field_4285, null);
    }

    public static class_1158 quatFromXYZ(class_1160 xyz, boolean degrees) {
        return new class_1158(xyz.method_4943(), xyz.method_4945(), xyz.method_4947(), degrees);
    }

    public static class_1158 quatFromXYZ(float[] xyz, boolean degrees) {
        return new class_1158(xyz[0], xyz[1], xyz[2], degrees);
    }

    public static class_1158 makeQuaternion(float[] values) {
        return new class_1158(values[0], values[1], values[2], values[3]);
    }

    public static class_1160 lerp(class_1160 from, class_1160 to, float progress) {
        class_1160 res = from.method_23850();
        res.method_23847(to, progress);
        return res;
    }

    public static class_1158 slerp(class_1158 v0, class_1158 v1, float t) {
        // From https://en.wikipedia.org/w/index.php?title=Slerp&oldid=928959428
        // License: CC BY-SA 3.0 https://creativecommons.org/licenses/by-sa/3.0/

        // Compute the cosine of the angle between the two vectors.
        // If the dot product is negative, slerp won't take
        // the shorter path. Note that v1 and -v1 are equivalent when
        // the negation is applied to all four components. Fix by
        // reversing one quaternion.
        float dot = v0.method_4921() * v1.method_4921() + v0.method_4922() * v1.method_4922() + v0.method_4923() * v1.method_4923() + v0.method_4924() * v1.method_4924();
        if (dot < 0.0f) {
            v1 = new class_1158(-v1.method_4921(), -v1.method_4922(), -v1.method_4923(), -v1.method_4924());
            dot = -dot;
        }

        // If the inputs are too close for comfort, linearly interpolate
        // and normalize the result.
        if (dot > THRESHOLD) {
            float x = class_3532.method_16439(t, v0.method_4921(), v1.method_4921());
            float y = class_3532.method_16439(t, v0.method_4922(), v1.method_4922());
            float z = class_3532.method_16439(t, v0.method_4923(), v1.method_4923());
            float w = class_3532.method_16439(t, v0.method_4924(), v1.method_4924());
            return new class_1158(x, y, z, w);
        }

        // Since dot is in range [0, DOT_THRESHOLD], acos is safe
        float angle01 = (float) Math.acos(dot);
        float angle0t = angle01 * t;
        float sin0t = class_3532.method_15374(angle0t);
        float sin01 = class_3532.method_15374(angle01);
        float sin1t = class_3532.method_15374(angle01 - angle0t);

        float s1 = sin0t / sin01;
        float s0 = sin1t / sin01;

        return new class_1158(
            s0 * v0.method_4921() + s1 * v1.method_4921(),
            s0 * v0.method_4922() + s1 * v1.method_4922(),
            s0 * v0.method_4923() + s1 * v1.method_4923(),
            s0 * v0.method_4924() + s1 * v1.method_4924()
        );
    }

    public static class_4590 slerp(class_4590 one, class_4590 that, float progress) {
        return new class_4590(
            lerp(one.method_35865(), that.method_35865(), progress),
            slerp(one.method_22937(), that.method_22937(), progress),
            lerp(one.method_35866(), that.method_35866(), progress),
            slerp(one.method_35867(), that.method_35867(), progress)
        );
    }

    public static boolean epsilonEquals(class_1162 v1, class_1162 v2, float epsilon) {
        return class_3532.method_15379(v1.method_4953() - v2.method_4953()) < epsilon &&
            class_3532.method_15379(v1.method_4956() - v2.method_4956()) < epsilon &&
            class_3532.method_15379(v1.method_4957() - v2.method_4957()) < epsilon &&
            class_3532.method_15379(v1.method_23853() - v2.method_23853()) < epsilon;
    }

    public static class Deserializer implements JsonDeserializer<class_4590> {
        private static final class_1160 ORIGIN_CORNER = new class_1160();
        private static final class_1160 ORIGIN_OPPOSING_CORNER = new class_1160(1f, 1f, 1f);
        private static final class_1160 ORIGIN_CENTER = new class_1160(.5f, .5f, .5f);

        private static class_1160 parseOrigin(JsonObject obj) {
            class_1160 origin = null;

            // Two types supported: string ("center", "corner") and array ([x, y, z])
            JsonElement originElement = obj.get("origin");
            if (originElement.isJsonArray()) {
                float[] vec = parseFloatArray(originElement, 3, "Origin");
                origin = new class_1160(vec[0], vec[1], vec[2]);
            } else if (originElement.isJsonPrimitive()) {
                String originString = originElement.getAsString();
                if ("center".equals(originString)) {
                    origin = ORIGIN_CENTER;
                } else if ("corner".equals(originString)) {
                    origin = ORIGIN_CORNER;
                } else if ("opposing-corner".equals(originString)) {
                    // This option can be used to not break models that were written with this origin once the default is changed
                    origin = ORIGIN_OPPOSING_CORNER;
                } else {
                    throw new JsonParseException("Origin: expected one of 'center', 'corner', 'opposing-corner'");
                }
            } else {
                throw new JsonParseException("Origin: expected an array or one of 'center', 'corner', 'opposing-corner'");
            }
            return origin;
        }

        public static class_1159 parseMatrix(JsonElement e) {
            if (!e.isJsonArray())
                throw new JsonParseException("Matrix: expected an array, got: " + e);
            JsonArray m = e.getAsJsonArray();
            if (m.size() != 3)
                throw new JsonParseException("Matrix: expected an array of length 3, got: " + m.size());
            float[] values = new float[16];
            for (int i = 0; i < 3; i++) {
                if (!m.get(i).isJsonArray())
                    throw new JsonParseException("Matrix row: expected an array, got: " + m.get(i));
                JsonArray r = m.get(i).getAsJsonArray();
                if (r.size() != 4)
                    throw new JsonParseException("Matrix row: expected an array of length 4, got: " + r.size());
                for (int j = 0; j < 4; j++) {
                    try {
                        values[j * 4 + i] = r.get(j).getAsNumber().floatValue();
                    } catch (ClassCastException ex) {
                        throw new JsonParseException("Matrix element: expected number, got: " + r.get(j));
                    }
                }
            }
            class_1159 matrix4f = new class_1159();
            ((Matrix4fExtensions) (Object) matrix4f).fromFloatArray(values);
            return matrix4f;
        }

        public static float[] parseFloatArray(JsonElement e, int length, String prefix) {
            if (!e.isJsonArray())
                throw new JsonParseException(prefix + ": expected an array, got: " + e);
            JsonArray t = e.getAsJsonArray();
            if (t.size() != length)
                throw new JsonParseException(prefix + ": expected an array of length " + length + ", got: " + t.size());
            float[] ret = new float[length];
            for (int i = 0; i < length; i++) {
                try {
                    ret[i] = t.get(i).getAsNumber().floatValue();
                } catch (ClassCastException ex) {
                    throw new JsonParseException(prefix + " element: expected number, got: " + t.get(i));
                }
            }
            return ret;
        }

        public static class_1158 parseAxisRotation(JsonElement e) {
            if (!e.isJsonObject())
                throw new JsonParseException("Axis rotation: object expected, got: " + e);
            JsonObject obj = e.getAsJsonObject();
            if (obj.entrySet().size() != 1)
                throw new JsonParseException("Axis rotation: expected single axis object, got: " + e);
            Map.Entry<String, JsonElement> entry = obj.entrySet().iterator().next();
            class_1158 ret;
            try {
                ret = switch (entry.getKey()) {
                    case "x" -> Vector3f.XP.rotationDegrees(entry.getValue().getAsNumber().floatValue());
                    case "y" -> Vector3f.YP.rotationDegrees(entry.getValue().getAsNumber().floatValue());
                    case "z" -> Vector3f.ZP.rotationDegrees(entry.getValue().getAsNumber().floatValue());
                    default -> throw new JsonParseException("Axis rotation: expected single axis key, got: " + entry.getKey());
                };
            } catch (ClassCastException ex) {
                throw new JsonParseException("Axis rotation value: expected number, got: " + entry.getValue());
            }
            return ret;
        }

        public static class_1158 parseRotation(JsonElement e) {
            if (e.isJsonArray()) {
                if (e.getAsJsonArray().get(0).isJsonObject()) {
                    class_1158 ret = class_1158.field_21493.method_23695();
                    for (JsonElement a : e.getAsJsonArray()) {
                        ret.method_4925(parseAxisRotation(a));
                    }
                    return ret;
                } else if (e.isJsonArray()) {
                    JsonArray array = e.getAsJsonArray();
                    if (array.size() == 3) //Vanilla rotation
                        return quatFromXYZ(parseFloatArray(e, 3, "Rotation"), true);
                    else // quaternion
                        return makeQuaternion(parseFloatArray(e, 4, "Rotation"));
                } else
                    throw new JsonParseException("Rotation: expected array or object, got: " + e);
            } else if (e.isJsonObject()) {
                return parseAxisRotation(e);
            } else
                throw new JsonParseException("Rotation: expected array or object, got: " + e);
        }

        @Override
        public class_4590 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
            throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                String transform = json.getAsString();
                if (transform.equals("identity")) {
                    return class_4590.method_22931();
                } else {
                    throw new JsonParseException("TRSR: unknown default string: " + transform);
                }
            }
            if (json.isJsonArray()) {
                // direct matrix array
                return new class_4590(parseMatrix(json));
            }
            if (!json.isJsonObject())
                throw new JsonParseException("TRSR: expected array or object, got: " + json);
            JsonObject obj = json.getAsJsonObject();
            class_4590 ret;
            if (obj.has("matrix")) {
                // matrix as a sole key
                ret = new class_4590(parseMatrix(obj.get("matrix")));
                obj.remove("matrix");
                if (obj.entrySet().size() != 0) {
                    throw new JsonParseException("TRSR: can't combine matrix and other keys");
                }
                return ret;
            }
            class_1160 translation = null;
            class_1158 leftRot = null;
            class_1160 scale = null;
            class_1158 rightRot = null;
            // TODO: Default origin is opposing corner, due to a mistake.
            // This should probably be replaced with center in future versions.
            class_1160 origin = ORIGIN_OPPOSING_CORNER; // TODO: Changing this to ORIGIN_CENTER breaks models, function content needs changing too -C
            if (obj.has("translation")) {
                float[] vec = parseFloatArray(obj.get("translation"), 3, "Translation");
                translation = new class_1160(vec[0], vec[1], vec[2]);
                obj.remove("translation");
            }
            if (obj.has("rotation")) {
                leftRot = parseRotation(obj.get("rotation"));
                obj.remove("rotation");
            }
            if (obj.has("scale")) {
                if (!obj.get("scale").isJsonArray()) {
                    try {
                        float s = obj.get("scale").getAsNumber().floatValue();
                        scale = new class_1160(s, s, s);
                    } catch (ClassCastException ex) {
                        throw new JsonParseException("TRSR scale: expected number or array, got: " + obj.get("scale"));
                    }
                } else {
                    float[] vec = parseFloatArray(obj.get("scale"), 3, "Scale");
                    scale = new class_1160(vec[0], vec[1], vec[2]);
                }
                obj.remove("scale");
            }
            if (obj.has("post-rotation")) {
                rightRot = parseRotation(obj.get("post-rotation"));
                obj.remove("post-rotation");
            }
            if (obj.has("origin")) {
                origin = parseOrigin(obj);
                obj.remove("origin");
            }
            if (!obj.entrySet().isEmpty())
                throw new JsonParseException("TRSR: can either have single 'matrix' key, or a combination of 'translation', 'rotation', 'scale', 'post-rotation', 'origin'");
            class_4590 matrix = new class_4590(translation, leftRot, scale, rightRot);

            // Use a different origin if needed.
            if (!ORIGIN_CENTER.equals(origin)) {
                class_1160 originFromCenter = origin.method_23850();
                originFromCenter.method_4944(ORIGIN_CENTER);
                matrix = ((TransformationExtensions) (Object) matrix).applyOrigin(originFromCenter);
            }
            return matrix;
        }
    }
}