package io.github.vampirestudios.vampirelib.client.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import com.mojang.datafixers.util.Pair;
import io.github.vampirestudios.vampirelib.api.BlockModelExtensions;

public class BlockModelConfiguration implements IModelConfiguration {
	public final class_793 owner;
	public final VisibilityData visibilityData = new VisibilityData();
	@Nullable
	private IModelGeometry<?> customGeometry;
	@Nullable
	private class_3665 customModelState;

	public BlockModelConfiguration(class_793 owner) {
		this.owner = owner;
	}

	@Nullable
	@Override
	public class_1100 getOwnerModel() {
		return owner;
	}

	@Override
	public String getModelName() {
		return owner.field_4252;
	}

	public boolean hasCustomGeometry() {
		return getCustomGeometry() != null;
	}

	@Nullable
	public IModelGeometry<?> getCustomGeometry() {
		return owner.field_4253 != null && customGeometry == null ? ((BlockModelExtensions) owner.field_4253).getGeometry().getCustomGeometry() : customGeometry;
	}

	public void setCustomGeometry(IModelGeometry<?> geometry) {
		this.customGeometry = geometry;
	}

	@Nullable
	public class_3665 getCustomModelState() {
		return owner.field_4253 != null && customModelState == null ? ((BlockModelExtensions) owner.field_4253).getGeometry().getCustomModelState() : customModelState;
	}

	public void setCustomModelState(class_3665 modelState) {
		this.customModelState = modelState;
	}

	@Override
	public boolean getPartVisibility(IModelGeometryPart part, boolean fallback) {
		return owner.field_4253 != null && !visibilityData.hasCustomVisibility(part) ?
				((BlockModelExtensions) owner.field_4253).getGeometry().getPartVisibility(part, fallback) :
				visibilityData.isVisible(part, fallback);
	}

	@Override
	public boolean isTexturePresent(String name) {
		return owner.method_3432(name);
	}

	@Override
	public class_4730 resolveTexture(String name) {
		return owner.method_24077(name);
	}

	@Override
	public boolean isShadedInGui() {
		return true;
	}

	@Override
	public boolean isSideLit() {
		return owner.method_24298().method_24299();
	}

	@Override
	public boolean useSmoothLighting() {
		return owner.method_3444();
	}

	@Override
	public class_809 getCameraTransforms() {
		return owner.method_3443();
	}

	@Override
	public class_3665 getCombinedTransform() {
		class_3665 state = getCustomModelState();

		return state != null
				? new SimpleModelState(PerspectiveMapWrapper.getTransformsWithFallback(state, getCameraTransforms()), state.method_3509())
				: new SimpleModelState(PerspectiveMapWrapper.getTransforms(getCameraTransforms()));
	}

	public void copyFrom(BlockModelConfiguration other) {
		this.customGeometry = other.customGeometry;
		this.customModelState = other.customModelState;
		this.visibilityData.copyFrom(other.visibilityData);
	}

	public Collection<class_4730> getTextureDependencies(Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
		IModelGeometry<?> geometry = getCustomGeometry();
		return geometry == null ? Collections.emptySet() :
				geometry.getTextures(this, modelGetter, missingTextureErrors);
	}

	public class_1087 bake(class_1088 bakery, Function<class_4730, class_1058> bakedTextureGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation) {
		IModelGeometry<?> geometry = getCustomGeometry();
		if (geometry == null)
			throw new IllegalStateException("Can not use custom baking without custom geometry");
		return geometry.bake(this, bakery, bakedTextureGetter, modelTransform, overrides, modelLocation);
	}

	public static class VisibilityData {
		private final Map<String, Boolean> data = new HashMap<>();

		public boolean hasCustomVisibility(IModelGeometryPart part) {
			return data.containsKey(part.name());
		}

		public boolean isVisible(IModelGeometryPart part, boolean fallback) {
			return data.getOrDefault(part.name(), fallback);
		}

		public void setVisibilityState(String partName, boolean type) {
			data.put(partName, type);
		}

		public void copyFrom(VisibilityData visibilityData) {
			data.clear();
			data.putAll(visibilityData.data);
		}
	}
}