package io.github.vampirestudios.vampirelib.client.model;

import com.google.common.base.Objects;
import io.github.vampirestudios.vampirelib.api.ModelStateExtensions;
import net.minecraft.class_3665;
import net.minecraft.class_4590;

/**
 * An {@link class_3665} that combines the transforms from two child {@link class_3665}.
 */
public class CompositeModelState implements class_3665, ModelStateExtensions {
	private final class_3665 first;
	private final class_3665 second;
	private final boolean uvLock;

	public CompositeModelState(class_3665 first, class_3665 second) {
		this(first, second, false);
	}

	public CompositeModelState(class_3665 first, class_3665 second, boolean uvLock) {
		this.first = first;
		this.second = second;
		this.uvLock = uvLock;
	}

	@Override
	public boolean method_3512() {
		return uvLock;
	}

	@Override
	public class_4590 method_3509() {
		return first.method_3509().method_22933(second.method_3509());
	}

	@Override
	public class_4590 getPartTransformation(Object part) {
		return ((ModelStateExtensions) first).getPartTransformation(part).method_22933(((ModelStateExtensions) second).getPartTransformation(part));
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		CompositeModelState that = (CompositeModelState) o;
		return Objects.equal(first, that.first) && Objects.equal(second, that.second);
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(first, second);
	}
}