package io.github.vampirestudios.vampirelib.client.model;

import io.github.vampirestudios.vampirelib.mixins.client.SimpleBakedModelBuilderAccessor;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import net.minecraft.class_806;

public interface IModelBuilder<T extends IModelBuilder<T>> {
	static IModelBuilder<?> of(IModelConfiguration owner, class_806 overrides, class_1058 particle) {
		return new Simple(SimpleBakedModelBuilderAccessor.vl$create(owner.useSmoothLighting(), owner.isSideLit(), owner.isShadedInGui(), owner.getCameraTransforms(), overrides).method_4747(particle));
	}

	T addFaceQuad(class_2350 facing, class_777 quad);

	T addGeneralQuad(class_777 quad);

	class_1087 build();

	class Simple implements IModelBuilder<Simple> {
		final class_1093.class_1094 builder;

		Simple(class_1093.class_1094 builder) {
			this.builder = builder;
		}

		@Override
		public Simple addFaceQuad(class_2350 facing, class_777 quad) {
			builder.method_4745(facing, quad);
			return this;
		}

		@Override
		public Simple addGeneralQuad(class_777 quad) {
			builder.method_4748(quad);
			return this;
		}

		@Override
		public class_1087 build() {
			return builder.method_4746();
		}
	}
}