package io.github.vampirestudios.vampirelib.client.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_806;
import com.mojang.datafixers.util.Pair;

/**
 * General interface for any model that can be baked, superset of vanilla {@link class_1100}.
 * Models can be baked to different vertex formats and with different state.
 */
public interface IModelGeometry<T extends IModelGeometry<T>> {
	default Collection<? extends IModelGeometryPart> getParts() {
		return Collections.emptyList();
	}

	default Optional<? extends IModelGeometryPart> getPart(String name) {
		return Optional.empty();
	}

	class_1087 bake(IModelConfiguration owner, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation);

	Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors);
}