package io.github.vampirestudios.vampirelib.client.model;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_806;
import com.mojang.datafixers.util.Pair;

public interface ISimpleModelGeometry<T extends ISimpleModelGeometry<T>> extends IModelGeometry<T> {
	@Override
	default class_1087 bake(IModelConfiguration owner, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation) {
		class_1058 particle = spriteGetter.apply(owner.resolveTexture("particle"));

		IModelBuilder<?> builder = IModelBuilder.of(owner, overrides, particle);

		addQuads(owner, builder, bakery, spriteGetter, modelTransform, modelLocation);

		return builder.build();
	}

	void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation);

	@Override
	Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors);
}