package io.github.vampirestudios.vampirelib.client.model;

import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_793;
import net.minecraft.class_799;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_809.class_811;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

import com.mojang.datafixers.util.Pair;
import io.github.vampirestudios.vampirelib.api.TransformationExtensions;
import io.github.vampirestudios.vampirelib.client.TransformationHelper;
import io.github.vampirestudios.vampirelib.mixins.client.BlockModelAccessor;

public class ModelLoaderRegistry {
	private static final Map<class_2960, IModelLoader<?>> loaders = Maps.newHashMap();

	public static void init() {
		BlockModelAccessor.setGSON((new GsonBuilder())
				.registerTypeAdapter(class_793.class, new class_793.class_795())
				.registerTypeAdapter(class_785.class, new class_785.class_786())
				.registerTypeAdapter(class_783.class, new class_783.class_784())
				.registerTypeAdapter(class_787.class, new class_787.class_788())
				.registerTypeAdapter(class_804.class, new class_804.class_805())
				.registerTypeAdapter(class_809.class, new class_809.class_810())
				.registerTypeAdapter(class_799.class, new class_799.class_800())
				.registerTypeAdapter(class_4590.class, new TransformationHelper.Deserializer())
				.create());
		registerLoader(new class_2960("minecraft","elements"), VanillaProxy.Loader.INSTANCE);
//		registerLoader(new ResourceLocation("forge","bucket"), DynamicBucketModel.Loader.INSTANCE);
//		registerLoader(new ResourceLocation("forge","item-layers"), ItemLayerModel.Loader.INSTANCE);
	}

	public static void registerLoader(class_2960 id, IModelLoader<?> loader) {
		synchronized (loaders) {
			loaders.put(id, loader);
			((class_3304) class_310.method_1551().method_1478()).method_14477(loader);
		}
	}

	public static IModelGeometry<?> getModel(class_2960 loaderId, JsonDeserializationContext deserializationContext, JsonObject data) {
		try {
			if (!loaders.containsKey(loaderId)) {
				throw new IllegalStateException(String.format("Model loader '%s' not found. Registered loaders: %s", loaderId,
						loaders.keySet().stream().map(class_2960::toString).collect(Collectors.joining(", "))));
			}

			IModelLoader<?> loader = loaders.get(loaderId);

			return loader.read(deserializationContext, data);
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	@Nullable
	public static class_3665 deserializeModelTransforms(JsonDeserializationContext deserializationContext, JsonObject modelData) {
		if (!modelData.has("transform"))
			return null;

		return deserializeTransform(deserializationContext, modelData.get("transform")).orElse(null);
	}

	public static Optional<class_3665> deserializeTransform(JsonDeserializationContext context, JsonElement transformData) {
		if (!transformData.isJsonObject()) {
			try {
				class_4590 base = context.deserialize(transformData, class_4590.class);
				return Optional.of(new SimpleModelState(ImmutableMap.of(), ((TransformationExtensions) (Object) base).blockCenterToCorner()));
			} catch (JsonParseException e) {
				throw new JsonParseException("transform: expected a string, object or valid base transformation, got: " + transformData);
			}
		} else {
			JsonObject transform = transformData.getAsJsonObject();
			EnumMap<class_811, class_4590> transforms = Maps.newEnumMap(class_809.class_811.class);

			deserializeTRSR(context, transforms, transform, "thirdperson", class_809.class_811.field_4320);
			deserializeTRSR(context, transforms, transform, "thirdperson_righthand", class_809.class_811.field_4320);
			deserializeTRSR(context, transforms, transform, "thirdperson_lefthand", class_809.class_811.field_4323);

			deserializeTRSR(context, transforms, transform, "firstperson", class_809.class_811.field_4322);
			deserializeTRSR(context, transforms, transform, "firstperson_righthand", class_809.class_811.field_4322);
			deserializeTRSR(context, transforms, transform, "firstperson_lefthand", class_809.class_811.field_4321);

			deserializeTRSR(context, transforms, transform, "head", class_809.class_811.field_4316);
			deserializeTRSR(context, transforms, transform, "gui", class_809.class_811.field_4317);
			deserializeTRSR(context, transforms, transform, "ground", class_809.class_811.field_4318);
			deserializeTRSR(context, transforms, transform, "fixed", class_809.class_811.field_4319);

			int k = transform.entrySet().size();
			if (transform.has("matrix")) k--;
			if (transform.has("translation")) k--;
			if (transform.has("rotation")) k--;
			if (transform.has("scale")) k--;
			if (transform.has("post-rotation")) k--;
			if (transform.has("origin")) k--;
			if (k > 0) {
				throw new JsonParseException("transform: allowed keys: 'thirdperson', 'firstperson', 'gui', 'head', 'matrix', 'translation', 'rotation', 'scale', 'post-rotation', 'origin'");
			}
			class_4590 base = class_4590.method_22931();
			if (!transform.entrySet().isEmpty()) {
				base = context.deserialize(transform, class_4590.class);
			}
			class_3665 state = new SimpleModelState(Maps.immutableEnumMap(transforms), base);
			return Optional.of(state);
		}
	}

	private static void deserializeTRSR(JsonDeserializationContext context, EnumMap<class_809.class_811, class_4590> transforms, JsonObject transform, String name, class_809.class_811 itemCameraTransform) {
		if (transform.has(name)) {
			class_4590 t = context.deserialize(transform.remove(name), class_4590.class);
			transforms.put(itemCameraTransform, ((TransformationExtensions) (Object) t).blockCenterToCorner());
		}
	}

	@Nullable
	public static IModelGeometry<?> deserializeGeometry(JsonDeserializationContext deserializationContext, JsonObject object) {
		if (!object.has("loader")) {
			return null;
		}

		class_2960 loader = new class_2960(class_3518.method_15265(object, "loader"));
		return getModel(loader, deserializationContext, object);
	}

	public static class VanillaProxy implements ISimpleModelGeometry<VanillaProxy> {
		private final List<class_785> elements;

		public VanillaProxy(List<class_785> list) {
			this.elements = list;
		}

		@Override
		public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, class_1088 bakery, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
			for (class_785 blockpart : elements) {
				for (class_2350 direction : blockpart.field_4230.keySet()) {
					class_783 blockpartface = blockpart.field_4230.get(direction);
					class_1058 textureatlassprite1 = spriteGetter.apply(owner.resolveTexture(blockpartface.field_4224));
					if (blockpartface.field_4225 == null) {
						modelBuilder.addGeneralQuad(BlockModelAccessor.vl$bakeFace(blockpart, blockpartface, textureatlassprite1, direction, modelTransform, modelLocation));
					} else {
						modelBuilder.addFaceQuad(
								((TransformationExtensions) (Object) modelTransform.method_3509()).rotateTransform(blockpartface.field_4225),
								BlockModelAccessor.vl$bakeFace(blockpart, blockpartface, textureatlassprite1, direction, modelTransform, modelLocation));
					}
				}
			}
		}

		@Override
		public Collection<class_4730> getTextures(IModelConfiguration owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
			Set<class_4730> textures = Sets.newHashSet();

			for (class_785 part : elements) {
				for (class_783 face : part.field_4230.values()) {
					class_4730 texture = owner.resolveTexture(face.field_4224);
					if (Objects.equals(texture, class_1047.method_4539().toString())) {
						missingTextureErrors.add(Pair.of(face.field_4224, owner.getModelName()));
					}

					textures.add(texture);
				}
			}

			return textures;
		}

		public static class Loader implements IModelLoader<VanillaProxy> {
			public static final Loader INSTANCE = new Loader();

			private Loader() {
			}

			@Override
			public void method_14491(class_3300 resourceManager) {

			}

			@Override
			public VanillaProxy read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
				List<class_785> list = this.getModelElements(deserializationContext, modelContents);
				return new VanillaProxy(list);
			}

			private List<class_785> getModelElements(JsonDeserializationContext deserializationContext, JsonObject object) {
				List<class_785> list = Lists.newArrayList();
				if (object.has("elements")) {
					for (JsonElement jsonelement : class_3518.method_15261(object, "elements")) {
						list.add(deserializationContext.deserialize(jsonelement, class_785.class));
					}
				}

				return list;
			}
		}
	}
}