package io.github.vampirestudios.vampirelib.client.model;

import java.util.EnumMap;
import java.util.List;

import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import com.google.common.collect.ImmutableMap;
import io.github.vampirestudios.vampirelib.api.ModelStateExtensions;
import io.github.vampirestudios.vampirelib.api.TransformationExtensions;
import io.github.vampirestudios.vampirelib.client.TransformationHelper;
import io.github.vampirestudios.vampirelib.client.render.TransformTypeDependentItemBakedModel;

public class PerspectiveMapWrapper implements class_1087, TransformTypeDependentItemBakedModel {
	private final class_1087 parent;
	private final ImmutableMap<class_809.class_811, class_4590> transforms;
	private final OverrideListWrapper overrides = new OverrideListWrapper();

	public PerspectiveMapWrapper(class_1087 parent, ImmutableMap<class_809.class_811, class_4590> transforms) {
		this.parent = parent;
		this.transforms = transforms;
	}

	public PerspectiveMapWrapper(class_1087 parent, class_3665 state) {
		this(parent, getTransforms(state));
	}

	public static ImmutableMap<class_809.class_811, class_4590> getTransforms(class_3665 state) {
		EnumMap<class_809.class_811, class_4590> map = new EnumMap<>(class_809.class_811.class);
		for (class_809.class_811 type : class_809.class_811.values()) {
			class_4590 tr = ((ModelStateExtensions) state).getPartTransformation(type);
			if (!((TransformationExtensions) (Object) tr).isIdentity()) {
				map.put(type, tr);
			}
		}
		return ImmutableMap.copyOf(map);
	}

	@SuppressWarnings("deprecation")
	public static ImmutableMap<class_809.class_811, class_4590> getTransformsWithFallback(class_3665 state, class_809 transforms) {
		EnumMap<class_809.class_811, class_4590> map = new EnumMap<>(class_809.class_811.class);
		for (class_809.class_811 type : class_809.class_811.values()) {
			class_4590 tr = ((ModelStateExtensions) state).getPartTransformation(type);
			if (!((TransformationExtensions) (Object) tr).isIdentity()) {
				map.put(type, tr);
			} else if (transforms.method_3501(type)) {
				map.put(type, TransformationHelper.toTransformation(transforms.method_3503(type)));
			}
		}
		return ImmutableMap.copyOf(map);
	}

	@SuppressWarnings("deprecation")
	public static ImmutableMap<class_809.class_811, class_4590> getTransforms(class_809 transforms) {
		EnumMap<class_809.class_811, class_4590> map = new EnumMap<>(class_809.class_811.class);
		for (class_809.class_811 type : class_809.class_811.values()) {
			if (transforms.method_3501(type)) {
				map.put(type, TransformationHelper.toTransformation(transforms.method_3503(type)));
			}
		}
		return ImmutableMap.copyOf(map);
	}

	public static class_1087 handlePerspective(class_1087 model, ImmutableMap<class_809.class_811, class_4590> transforms, class_809.class_811 cameraTransformType, class_4587 mat) {
		class_4590 tr = transforms.getOrDefault(cameraTransformType, class_4590.method_22931());
		if (!((TransformationExtensions) (Object) tr).isIdentity()) {
			((TransformationExtensions) (Object) tr).push(mat);
		}
		return model;
	}

	public static class_1087 handlePerspective(class_1087 model, class_3665 state, class_809.class_811 cameraTransformType, class_4587 mat) {
		class_4590 tr = ((ModelStateExtensions) state).getPartTransformation(cameraTransformType);
		if (!((TransformationExtensions) (Object) tr).isIdentity()) {
			((TransformationExtensions) (Object) tr).push(mat);
		}
		return model;
	}

	@Override
	public boolean method_4708() {
		return parent.method_4708();
	}

	//  @Override public boolean useAmbientOcclusion(BlockState state) { return parent.useAmbientOcclusion(state); }
	@Override
	public boolean method_4712() {
		return parent.method_4712();
	}

	@Override
	public boolean method_24304() {
		return parent.method_24304();
	}

	@Override
	public boolean method_4713() {
		return parent.method_4713();
	}

	@Override
	public class_1058 method_4711() {
		return parent.method_4711();
	}

	@Override
	public class_809 method_4709() {
		return parent.method_4709();
	}

	@Override
	public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
		return parent.method_4707(state, side, rand);
	}

	@Override
	public class_806 method_4710() {
		return overrides;
	}

	@Override
	public class_1087 handlePerspective(class_809.class_811 cameraTransformType, class_4587 poseStack) {
		return handlePerspective(this, transforms, cameraTransformType, poseStack);
	}

	private class OverrideListWrapper extends class_806 {
		public OverrideListWrapper() {
			super();
		}

		@Nullable
		@Override
		public class_1087 method_3495(class_1087 model, class_1799 stack, @Nullable class_638 worldIn, @Nullable class_1309 entityIn, int seed) {
			model = parent.method_4710().method_3495(parent, stack, worldIn, entityIn, seed);
			return new PerspectiveMapWrapper(model, transforms);
		}

//    @Override
//    public ImmutableList<BakedOverride> getOverrides()
//    {
//      return parent.getOverrides().getOverrides();
//    }
	}
}