package io.github.vampirestudios.vampirelib.client.model;

import com.google.common.collect.ImmutableMap;
import io.github.vampirestudios.vampirelib.api.ModelStateExtensions;
import net.minecraft.class_3665;
import net.minecraft.class_4590;

/**
 * Simple implementation of IModelState via a map and a default value.
 */
public final class SimpleModelState implements class_3665, ModelStateExtensions {
	public static final SimpleModelState IDENTITY = new SimpleModelState(class_4590.method_22931());

	private final ImmutableMap<?, class_4590> map;
	private final class_4590 base;

	public SimpleModelState(ImmutableMap<?, class_4590> map) {
		this(map, class_4590.method_22931());
	}

	public SimpleModelState(class_4590 base) {
		this(ImmutableMap.of(), base);
	}

	public SimpleModelState(ImmutableMap<?, class_4590> map, class_4590 base) {
		this.map = map;
		this.base = base;
	}

	@Override
	public class_4590 method_3509() {
		return base;
	}

	@Override
	public class_4590 getPartTransformation(Object part) {
		return map.getOrDefault(part, class_4590.method_22931());
	}
}