/*
 *  GNU GENERAL PUBLIC LICENSE
 *                        Version 3, 29 June 2007
 *
 *  Copyright (C) 2021 Vampire Studios
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *                             Preamble
 *
 *   The GNU General Public License is a free, copyleft license for
 * software and other kinds of works.
 *
 *   The licenses for most software and other practical works are designed
 * to take away your freedom to share and change the works.  By contrast,
 * the GNU General Public License is intended to guarantee your freedom to
 * share and change all versions of a program--to make sure it remains free
 * software for all its users.  We, the Free Software Foundation, use the
 * GNU General Public License for most of our software; it applies also to
 * any other work released this way by its authors.  You can apply it to
 * your programs, too.
 *
 *   When we speak of free software, we are referring to freedom, not
 * price.  Our General Public Licenses are designed to make sure that you
 * have the freedom to distribute copies of free software (and charge for
 * them if you wish), that you receive source code or can get it if you
 * want it, that you can change the software or use pieces of it in new
 * free programs, and that you know you can do these things.
 *
 *   To protect your rights, we need to prevent others from denying you
 * these rights or asking you to surrender the rights.  Therefore, you have
 * certain responsibilities if you distribute copies of the software, or if
 * you modify it: responsibilities to respect the freedom of others.
 *
 *   For example, if you distribute copies of such a program, whether
 * gratis or for a fee, you must pass on to the recipients the same
 * freedoms that you received.  You must make sure that they, too, receive
 * or can get the source code.  And you must show them these terms so they
 * know their rights.
 *
 *   Developers that use the GNU GPL protect your rights with two steps:
 * (1) assert copyright on the software, and (2) offer you this License
 * giving you legal permission to copy, distribute and/or modify it.
 *
 *   For the developers' and authors' protection, the GPL clearly explains
 * that there is no warranty for this free software.  For both users' and
 * authors' sake, the GPL requires that modified versions be marked as
 * changed, so that their problems will not be attributed erroneously to
 * authors of previous versions.
 *
 *   Some devices are designed to deny users access to install or run
 * modified versions of the software inside them, although the manufacturer
 * can do so.  This is fundamentally incompatible with the aim of
 * protecting users' freedom to change the software.  The systematic
 * pattern of such abuse occurs in the area of products for individuals to
 * use, which is precisely where it is most unacceptable.  Therefore, we
 * have designed this version of the GPL to prohibit the practice for those
 * products.  If such problems arise substantially in other domains, we
 * stand ready to extend this provision to those domains in future versions
 * of the GPL, as needed to protect the freedom of users.
 *
 *   Finally, every program is threatened constantly by software patents.
 * States should not allow patents to restrict development and use of
 * software on general-purpose computers, but in those that do, we wish to
 * avoid the special danger that patents applied to a free program could
 * make it effectively proprietary.  To prevent this, the GPL assures that
 * patents cannot be used to render the program non-free.
 *
 *   The precise terms and conditions for copying, distribution and
 * modification follow.
 *
 *                        TERMS AND CONDITIONS
 *
 *   0. Definitions.
 *
 *   "This License" refers to version 3 of the GNU General Public License.
 *
 *   "Copyright" also means copyright-like laws that apply to other kinds of
 * works, such as semiconductor masks.
 *
 *   "The Program" refers to any copyrightable work licensed under this
 * License.  Each licensee is addressed as "you".  "Licensees" and
 * "recipients" may be individuals or organizations.
 *
 *   To "modify" a work means to copy from or adapt all or part of the work
 * in a fashion requiring copyright permission, other than the making of an
 * exact copy.  The resulting work is called a "modified version" of the
 * earlier work or a work "based on" the earlier work.
 *
 *   A "covered work" means either the unmodified Program or a work based
 * on the Program.
 *
 *   To "propagate" a work means to do anything with it that, without
 * permission, would make you directly or secondarily liable for
 * infringement under applicable copyright law, except executing it on a
 * computer or modifying a private copy.  Propagation includes copying,
 * distribution (with or without modification), making available to the
 * public, and in some countries other activities as well.
 *
 *   To "convey" a work means any kind of propagation that enables other
 * parties to make or receive copies.  Mere interaction with a user through
 * a computer network, with no transfer of a copy, is not conveying.
 *
 *   An interactive user interface displays "Appropriate Legal Notices"
 * to the extent that it includes a convenient and prominently visible
 * feature that (1) displays an appropriate copyright notice, and (2)
 * tells the user that there is no warranty for the work (except to the
 * extent that warranties are provided), that licensees may convey the
 * work under this License, and how to view a copy of this License.  If
 * the interface presents a list of user commands or options, such as a
 * menu, a prominent item in the list meets this criterion.
 *
 *   1. Source Code.
 *
 *   The "source code" for a work means the preferred form of the work
 * for making modifications to it.  "Object code" means any non-source
 * form of a work.
 *
 *   A "Standard Interface" means an interface that either is an official
 * standard defined by a recognized standards body, or, in the case of
 * interfaces specified for a particular programming language, one that
 * is widely used among developers working in that language.
 *
 *   The "System Libraries" of an executable work include anything, other
 * than the work as a whole, that (a) is included in the normal form of
 * packaging a Major Component, but which is not part of that Major
 * Component, and (b) serves only to enable use of the work with that
 * Major Component, or to implement a Standard Interface for which an
 * implementation is available to the public in source code form.  A
 * "Major Component", in this context, means a major essential component
 * (kernel, window system, and so on) of the specific operating system
 * (if any) on which the executable work runs, or a compiler used to
 * produce the work, or an object code interpreter used to run it.
 *
 *   The "Corresponding Source" for a work in object code form means all
 * the source code needed to generate, install, and (for an executable
 * work) run the object code and to modify the work, including scripts to
 * control those activities.  However, it does not include the work's
 * System Libraries, or general-purpose tools or generally available free
 * programs which are used unmodified in performing those activities but
 * which are not part of the work.  For example, Corresponding Source
 * includes interface definition files associated with source files for
 * the work, and the source code for shared libraries and dynamically
 * linked subprograms that the work is specifically designed to require,
 * such as by intimate data communication or control flow between those
 * subprograms and other parts of the work.
 *
 *   The Corresponding Source need not include anything that users
 * can regenerate automatically from other parts of the Corresponding
 * Source.
 *
 *   The Corresponding Source for a work in source code form is that
 * same work.
 *
 *   2. Basic Permissions.
 *
 *   All rights granted under this License are granted for the term of
 * copyright on the Program, and are irrevocable provided the stated
 * conditions are met.  This License explicitly affirms your unlimited
 * permission to run the unmodified Program.  The output from running a
 * covered work is covered by this License only if the output, given its
 * content, constitutes a covered work.  This License acknowledges your
 * rights of fair use or other equivalent, as provided by copyright law.
 *
 *   You may make, run and propagate covered works that you do not
 * convey, without conditions so long as your license otherwise remains
 * in force.  You may convey covered works to others for the sole purpose
 * of having them make modifications exclusively for you, or provide you
 * with facilities for running those works, provided that you comply with
 * the terms of this License in conveying all material for which you do
 * not control copyright.  Those thus making or running the covered works
 * for you must do so exclusively on your behalf, under your direction
 * and control, on terms that prohibit them from making any copies of
 * your copyrighted material outside their relationship with you.
 *
 *   Conveying under any other circumstances is permitted solely under
 * the conditions stated below.  Sublicensing is not allowed; section 10
 * makes it unnecessary.
 *
 *   3. Protecting Users' Legal Rights From Anti-Circumvention Law.
 *
 *   No covered work shall be deemed part of an effective technological
 * measure under any applicable law fulfilling obligations under article
 * 11 of the WIPO copyright treaty adopted on 20 December 1996, or
 * similar laws prohibiting or restricting circumvention of such
 * measures.
 *
 *   When you convey a covered work, you waive any legal power to forbid
 * circumvention of technological measures to the extent such circumvention
 * is effected by exercising rights under this License with respect to
 * the covered work, and you disclaim any intention to limit operation or
 * modification of the work as a means of enforcing, against the work's
 * users, your or third parties' legal rights to forbid circumvention of
 * technological measures.
 *
 *   4. Conveying Verbatim Copies.
 *
 *   You may convey verbatim copies of the Program's source code as you
 * receive it, in any medium, provided that you conspicuously and
 * appropriately publish on each copy an appropriate copyright notice;
 * keep intact all notices stating that this License and any
 * non-permissive terms added in accord with section 7 apply to the code;
 * keep intact all notices of the absence of any warranty; and give all
 * recipients a copy of this License along with the Program.
 *
 *   You may charge any price or no price for each copy that you convey,
 * and you may offer support or warranty protection for a fee.
 *
 *   5. Conveying Modified Source Versions.
 *
 *   You may convey a work based on the Program, or the modifications to
 * produce it from the Program, in the form of source code under the
 * terms of section 4, provided that you also meet all of these conditions:
 *
 *     a) The work must carry prominent notices stating that you modified
 *     it, and giving a relevant date.
 *
 *     b) The work must carry prominent notices stating that it is
 *     released under this License and any conditions added under section
 *     7.  This requirement modifies the requirement in section 4 to
 *     "keep intact all notices".
 *
 *     c) You must license the entire work, as a whole, under this
 *     License to anyone who comes into possession of a copy.  This
 *     License will therefore apply, along with any applicable section 7
 *     additional terms, to the whole of the work, and all its parts,
 *     regardless of how they are packaged.  This License gives no
 *     permission to license the work in any other way, but it does not
 *     invalidate such permission if you have separately received it.
 *
 *     d) If the work has interactive user interfaces, each must display
 *     Appropriate Legal Notices; however, if the Program has interactive
 *     interfaces that do not display Appropriate Legal Notices, your
 *     work need not make them do so.
 *
 *   A compilation of a covered work with other separate and independent
 * works, which are not by their nature extensions of the covered work,
 * and which are not combined with it such as to form a larger program,
 * in or on a volume of a storage or distribution medium, is called an
 * "aggregate" if the compilation and its resulting copyright are not
 * used to limit the access or legal rights of the compilation's users
 * beyond what the individual works permit.  Inclusion of a covered work
 * in an aggregate does not cause this License to apply to the other
 * parts of the aggregate.
 *
 *   6. Conveying Non-Source Forms.
 *
 *   You may convey a covered work in object code form under the terms
 * of sections 4 and 5, provided that you also convey the
 * machine-readable Corresponding Source under the terms of this License,
 * in one of these ways:
 *
 *     a) Convey the object code in, or embodied in, a physical product
 *     (including a physical distribution medium), accompanied by the
 *     Corresponding Source fixed on a durable physical medium
 *     customarily used for software interchange.
 *
 *     b) Convey the object code in, or embodied in, a physical product
 *     (including a physical distribution medium), accompanied by a
 *     written offer, valid for at least three years and valid for as
 *     long as you offer spare parts or customer support for that product
 *     model, to give anyone who possesses the object code either (1) a
 *     copy of the Corresponding Source for all the software in the
 *     product that is covered by this License, on a durable physical
 *     medium customarily used for software interchange, for a price no
 *     more than your reasonable cost of physically performing this
 *     conveying of source, or (2) access to copy the
 *     Corresponding Source from a network server at no charge.
 *
 *     c) Convey individual copies of the object code with a copy of the
 *     written offer to provide the Corresponding Source.  This
 *     alternative is allowed only occasionally and noncommercially, and
 *     only if you received the object code with such an offer, in accord
 *     with subsection 6b.
 *
 *     d) Convey the object code by offering access from a designated
 *     place (gratis or for a charge), and offer equivalent access to the
 *     Corresponding Source in the same way through the same place at no
 *     further charge.  You need not require recipients to copy the
 *     Corresponding Source along with the object code.  If the place to
 *     copy the object code is a network server, the Corresponding Source
 *     may be on a different server (operated by you or a third party)
 *     that supports equivalent copying facilities, provided you maintain
 *     clear directions next to the object code saying where to find the
 *     Corresponding Source.  Regardless of what server hosts the
 *     Corresponding Source, you remain obligated to ensure that it is
 *     available for as long as needed to satisfy these requirements.
 *
 *     e) Convey the object code using peer-to-peer transmission, provided
 *     you inform other peers where the object code and Corresponding
 *     Source of the work are being offered to the general public at no
 *     charge under subsection 6d.
 *
 *   A separable portion of the object code, whose source code is excluded
 * from the Corresponding Source as a System Library, need not be
 * included in conveying the object code work.
 *
 *   A "User Product" is either (1) a "consumer product", which means any
 * tangible personal property which is normally used for personal, family,
 * or household purposes, or (2) anything designed or sold for incorporation
 * into a dwelling.  In determining whether a product is a consumer product,
 * doubtful cases shall be resolved in favor of coverage.  For a particular
 * product received by a particular user, "normally used" refers to a
 * typical or common use of that class of product, regardless of the status
 * of the particular user or of the way in which the particular user
 * actually uses, or expects or is expected to use, the product.  A product
 * is a consumer product regardless of whether the product has substantial
 * commercial, industrial or non-consumer uses, unless such uses represent
 * the only significant mode of use of the product.
 *
 *   "Installation Information" for a User Product means any methods,
 * procedures, authorization keys, or other information required to install
 * and execute modified versions of a covered work in that User Product from
 * a modified version of its Corresponding Source.  The information must
 * suffice to ensure that the continued functioning of the modified object
 * code is in no case prevented or interfered with solely because
 * modification has been made.
 *
 *   If you convey an object code work under this section in, or with, or
 * specifically for use in, a User Product, and the conveying occurs as
 * part of a transaction in which the right of possession and use of the
 * User Product is transferred to the recipient in perpetuity or for a
 * fixed term (regardless of how the transaction is characterized), the
 * Corresponding Source conveyed under this section must be accompanied
 * by the Installation Information.  But this requirement does not apply
 * if neither you nor any third party retains the ability to install
 * modified object code on the User Product (for example, the work has
 * been installed in ROM).
 *
 *   The requirement to provide Installation Information does not include a
 * requirement to continue to provide support service, warranty, or updates
 * for a work that has been modified or installed by the recipient, or for
 * the User Product in which it has been modified or installed.  Access to a
 * network may be denied when the modification itself materially and
 * adversely affects the operation of the network or violates the rules and
 * protocols for communication across the network.
 *
 *   Corresponding Source conveyed, and Installation Information provided,
 * in accord with this section must be in a format that is publicly
 * documented (and with an implementation available to the public in
 * source code form), and must require no special password or key for
 * unpacking, reading or copying.
 *
 *   7. Additional Terms.
 *
 *   "Additional permissions" are terms that supplement the terms of this
 * License by making exceptions from one or more of its conditions.
 * Additional permissions that are applicable to the entire Program shall
 * be treated as though they were included in this License, to the extent
 * that they are valid under applicable law.  If additional permissions
 * apply only to part of the Program, that part may be used separately
 * under those permissions, but the entire Program remains governed by
 * this License without regard to the additional permissions.
 *
 *   When you convey a copy of a covered work, you may at your option
 * remove any additional permissions from that copy, or from any part of
 * it.  (Additional permissions may be written to require their own
 * removal in certain cases when you modify the work.)  You may place
 * additional permissions on material, added by you to a covered work,
 * for which you have or can give appropriate copyright permission.
 *
 *   Notwithstanding any other provision of this License, for material you
 * add to a covered work, you may (if authorized by the copyright holders of
 * that material) supplement the terms of this License with terms:
 *
 *     a) Disclaiming warranty or limiting liability differently from the
 *     terms of sections 15 and 16 of this License; or
 *
 *     b) Requiring preservation of specified reasonable legal notices or
 *     author attributions in that material or in the Appropriate Legal
 *     Notices displayed by works containing it; or
 *
 *     c) Prohibiting misrepresentation of the origin of that material, or
 *     requiring that modified versions of such material be marked in
 *     reasonable ways as different from the original version; or
 *
 *     d) Limiting the use for publicity purposes of names of licensors or
 *     authors of the material; or
 *
 *     e) Declining to grant rights under trademark law for use of some
 *     trade names, trademarks, or service marks; or
 *
 *     f) Requiring indemnification of licensors and authors of that
 *     material by anyone who conveys the material (or modified versions of
 *     it) with contractual assumptions of liability to the recipient, for
 *     any liability that these contractual assumptions directly impose on
 *     those licensors and authors.
 *
 *   All other non-permissive additional terms are considered "further
 * restrictions" within the meaning of section 10.  If the Program as you
 * received it, or any part of it, contains a notice stating that it is
 * governed by this License along with a term that is a further
 * restriction, you may remove that term.  If a license document contains
 * a further restriction but permits relicensing or conveying under this
 * License, you may add to a covered work material governed by the terms
 * of that license document, provided that the further restriction does
 * not survive such relicensing or conveying.
 *
 *   If you add terms to a covered work in accord with this section, you
 * must place, in the relevant source files, a statement of the
 * additional terms that apply to those files, or a notice indicating
 * where to find the applicable terms.
 *
 *   Additional terms, permissive or non-permissive, may be stated in the
 * form of a separately written license, or stated as exceptions;
 * the above requirements apply either way.
 *
 *   8. Termination.
 *
 *   You may not propagate or modify a covered work except as expressly
 * provided under this License.  Any attempt otherwise to propagate or
 * modify it is void, and will automatically terminate your rights under
 * this License (including any patent licenses granted under the third
 * paragraph of section 11).
 *
 *   However, if you cease all violation of this License, then your
 * license from a particular copyright holder is reinstated (a)
 * provisionally, unless and until the copyright holder explicitly and
 * finally terminates your license, and (b) permanently, if the copyright
 * holder fails to notify you of the violation by some reasonable means
 * prior to 60 days after the cessation.
 *
 *   Moreover, your license from a particular copyright holder is
 * reinstated permanently if the copyright holder notifies you of the
 * violation by some reasonable means, this is the first time you have
 * received notice of violation of this License (for any work) from that
 * copyright holder, and you cure the violation prior to 30 days after
 * your receipt of the notice.
 *
 *   Termination of your rights under this section does not terminate the
 * licenses of parties who have received copies or rights from you under
 * this License.  If your rights have been terminated and not permanently
 * reinstated, you do not qualify to receive new licenses for the same
 * material under section 10.
 *
 *   9. Acceptance Not Required for Having Copies.
 *
 *   You are not required to accept this License in order to receive or
 * run a copy of the Program.  Ancillary propagation of a covered work
 * occurring solely as a consequence of using peer-to-peer transmission
 * to receive a copy likewise does not require acceptance.  However,
 * nothing other than this License grants you permission to propagate or
 * modify any covered work.  These actions infringe copyright if you do
 * not accept this License.  Therefore, by modifying or propagating a
 * covered work, you indicate your acceptance of this License to do so.
 *
 *   10. Automatic Licensing of Downstream Recipients.
 *
 *   Each time you convey a covered work, the recipient automatically
 * receives a license from the original licensors, to run, modify and
 * propagate that work, subject to this License.  You are not responsible
 * for enforcing compliance by third parties with this License.
 *
 *   An "entity transaction" is a transaction transferring control of an
 * organization, or substantially all assets of one, or subdividing an
 * organization, or merging organizations.  If propagation of a covered
 * work results from an entity transaction, each party to that
 * transaction who receives a copy of the work also receives whatever
 * licenses to the work the party's predecessor in interest had or could
 * give under the previous paragraph, plus a right to possession of the
 * Corresponding Source of the work from the predecessor in interest, if
 * the predecessor has it or can get it with reasonable efforts.
 *
 *   You may not impose any further restrictions on the exercise of the
 * rights granted or affirmed under this License.  For example, you may
 * not impose a license fee, royalty, or other charge for exercise of
 * rights granted under this License, and you may not initiate litigation
 * (including a cross-claim or counterclaim in a lawsuit) alleging that
 * any patent claim is infringed by making, using, selling, offering for
 * sale, or importing the Program or any portion of it.
 *
 *   11. Patents.
 *
 *   A "contributor" is a copyright holder who authorizes use under this
 * License of the Program or a work on which the Program is based.  The
 * work thus licensed is called the contributor's "contributor version".
 *
 *   A contributor's "essential patent claims" are all patent claims
 * owned or controlled by the contributor, whether already acquired or
 * hereafter acquired, that would be infringed by some manner, permitted
 * by this License, of making, using, or selling its contributor version,
 * but do not include claims that would be infringed only as a
 * consequence of further modification of the contributor version.  For
 * purposes of this definition, "control" includes the right to grant
 * patent sublicenses in a manner consistent with the requirements of
 * this License.
 *
 *   Each contributor grants you a non-exclusive, worldwide, royalty-free
 * patent license under the contributor's essential patent claims, to
 * make, use, sell, offer for sale, import and otherwise run, modify and
 * propagate the contents of its contributor version.
 *
 *   In the following three paragraphs, a "patent license" is any express
 * agreement or commitment, however denominated, not to enforce a patent
 * (such as an express permission to practice a patent or covenant not to
 * sue for patent infringement).  To "grant" such a patent license to a
 * party means to make such an agreement or commitment not to enforce a
 * patent against the party.
 *
 *   If you convey a covered work, knowingly relying on a patent license,
 * and the Corresponding Source of the work is not available for anyone
 * to copy, free of charge and under the terms of this License, through a
 * publicly available network server or other readily accessible means,
 * then you must either (1) cause the Corresponding Source to be so
 * available, or (2) arrange to deprive yourself of the benefit of the
 * patent license for this particular work, or (3) arrange, in a manner
 * consistent with the requirements of this License, to extend the patent
 * license to downstream recipients.  "Knowingly relying" means you have
 * actual knowledge that, but for the patent license, your conveying the
 * covered work in a country, or your recipient's use of the covered work
 * in a country, would infringe one or more identifiable patents in that
 * country that you have reason to believe are valid.
 *
 *   If, pursuant to or in connection with a single transaction or
 * arrangement, you convey, or propagate by procuring conveyance of, a
 * covered work, and grant a patent license to some of the parties
 * receiving the covered work authorizing them to use, propagate, modify
 * or convey a specific copy of the covered work, then the patent license
 * you grant is automatically extended to all recipients of the covered
 * work and works based on it.
 *
 *   A patent license is "discriminatory" if it does not include within
 * the scope of its coverage, prohibits the exercise of, or is
 * conditioned on the non-exercise of one or more of the rights that are
 * specifically granted under this License.  You may not convey a covered
 * work if you are a party to an arrangement with a third party that is
 * in the business of distributing software, under which you make payment
 * to the third party based on the extent of your activity of conveying
 * the work, and under which the third party grants, to any of the
 * parties who would receive the covered work from you, a discriminatory
 * patent license (a) in connection with copies of the covered work
 * conveyed by you (or copies made from those copies), or (b) primarily
 * for and in connection with specific products or compilations that
 * contain the covered work, unless you entered into that arrangement,
 * or that patent license was granted, prior to 28 March 2007.
 *
 *   Nothing in this License shall be construed as excluding or limiting
 * any implied license or other defenses to infringement that may
 * otherwise be available to you under applicable patent law.
 *
 *   12. No Surrender of Others' Freedom.
 *
 *   If conditions are imposed on you (whether by court order, agreement or
 * otherwise) that contradict the conditions of this License, they do not
 * excuse you from the conditions of this License.  If you cannot convey a
 * covered work so as to satisfy simultaneously your obligations under this
 * License and any other pertinent obligations, then as a consequence you may
 * not convey it at all.  For example, if you agree to terms that obligate you
 * to collect a royalty for further conveying from those to whom you convey
 * the Program, the only way you could satisfy both those terms and this
 * License would be to refrain entirely from conveying the Program.
 *
 *   13. Use with the GNU Affero General Public License.
 *
 *   Notwithstanding any other provision of this License, you have
 * permission to link or combine any covered work with a work licensed
 * under version 3 of the GNU Affero General Public License into a single
 * combined work, and to convey the resulting work.  The terms of this
 * License will continue to apply to the part which is the covered work,
 * but the special requirements of the GNU Affero General Public License,
 * section 13, concerning interaction through a network will apply to the
 * combination as such.
 *
 *   14. Revised Versions of this License.
 *
 *   The Free Software Foundation may publish revised and/or new versions of
 * the GNU General Public License from time to time.  Such new versions will
 * be similar in spirit to the present version, but may differ in detail to
 * address new problems or concerns.
 *
 *   Each version is given a distinguishing version number.  If the
 * Program specifies that a certain numbered version of the GNU General
 * Public License "or any later version" applies to it, you have the
 * option of following the terms and conditions either of that numbered
 * version or of any later version published by the Free Software
 * Foundation.  If the Program does not specify a version number of the
 * GNU General Public License, you may choose any version ever published
 * by the Free Software Foundation.
 *
 *   If the Program specifies that a proxy can decide which future
 * versions of the GNU General Public License can be used, that proxy's
 * public statement of acceptance of a version permanently authorizes you
 * to choose that version for the Program.
 *
 *   Later license versions may give you additional or different
 * permissions.  However, no additional obligations are imposed on any
 * author or copyright holder as a result of your choosing to follow a
 * later version.
 *
 *   15. Disclaimer of Warranty.
 *
 *   THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
 * APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 * HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY
 * OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
 * IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
 * ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
 *
 *   16. Limitation of Liability.
 *
 *   IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
 * WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS
 * THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
 * GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
 * USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 * DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD
 * PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),
 * EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 *
 *   17. Interpretation of Sections 15 and 16.
 *
 *   If the disclaimer of warranty and limitation of liability provided
 * above cannot be given local legal effect according to their terms,
 * reviewing courts shall apply local law that most closely approximates
 * an absolute waiver of all civil liability in connection with the
 * Program, unless a warranty or assumption of liability accompanies a
 * copy of the Program in return for a fee.
 *
 *                      END OF TERMS AND CONDITIONS
 *
 *             How to Apply These Terms to Your New Programs
 *
 *   If you develop a new program, and you want it to be of the greatest
 * possible use to the public, the best way to achieve this is to make it
 * free software which everyone can redistribute and change under these terms.
 *
 *   To do so, attach the following notices to the program.  It is safest
 * to attach them to the start of each source file to most effectively
 * state the exclusion of warranty; and each file should have at least
 * the "copyright" line and a pointer to where the full notice is found.
 *
 *     <one line to give the program's name and a brief idea of what it does.>
 *     Copyright (C) <year>  <name of author>
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Also add information on how to contact you by electronic and paper mail.
 *
 *   If the program does terminal interaction, make it output a short
 * notice like this when it starts in an interactive mode:
 *
 *     <program>  Copyright (C) <year>  <name of author>
 *     This program comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
 *     This is free software, and you are welcome to redistribute it
 *     under certain conditions; type `show c' for details.
 *
 * The hypothetical commands `show w' and `show c' should show the appropriate
 * parts of the General Public License.  Of course, your program's commands
 * might be different; for a GUI interface, you would use an "about box".
 *
 *   You should also get your employer (if you work as a programmer) or school,
 * if any, to sign a "copyright disclaimer" for the program, if necessary.
 * For more information on this, and how to apply and follow the GNU GPL, see
 * <https://www.gnu.org/licenses/>.
 *
 *   The GNU General Public License does not permit incorporating your program
 * into proprietary programs.  If your program is a subroutine library, you
 * may consider it more useful to permit linking proprietary applications with
 * the library.  If this is what you want to do, use the GNU Lesser General
 * Public License instead of this License.  But first, please read
 * <https://www.gnu.org/licenses/why-not-lgpl.html>.
 */

package io.github.vampirestudios.vampirelib.init;

import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5284;
import net.minecraft.class_6862;

public class VTags {

    public static class Blocks {
        public static final class_6862<class_2248> LEAF_PILES = tag("leaf_piles");
        public static final class_6862<class_2248> LEAF_CARPETS = tag("leaf_carpets");
        public static final class_6862<class_2248> WART_PILES = tag("wart_piles");
        public static final class_6862<class_2248> WART_CARPETS = tag("wart_carpets");

        public static final class_6862<class_2248> BARRELS_WOODEN = tag("barrels/wooden");
		public static final class_6862<class_2248> BARRELS = tag("barrels");
        public static final class_6862<class_2248> CHESTS_ENDER = tag("chests/ender");
        public static final class_6862<class_2248> CHESTS_TRAPPED = tag("chests/trapped");
        public static final class_6862<class_2248> CHESTS_WOODEN = tag("chests/wooden");
		public static final class_6862<class_2248> CHESTS = tag("chests");
		public static final class_6862<class_2248> COBBLESTONE = tag("cobblestone");
        public static final class_6862<class_2248> COBBLESTONE_NORMAL = tag("cobblestone/normal");
        public static final class_6862<class_2248> COBBLESTONE_INFESTED = tag("cobblestone/infested");
        public static final class_6862<class_2248> COBBLESTONE_MOSSY = tag("cobblestone/mossy");
        public static final class_6862<class_2248> COBBLESTONE_DEEPSLATE = tag("cobblestone/deepslate");
		public static final class_6862<class_2248> DIRT = tag("dirt");
		public static final class_6862<class_2248> END_STONES = tag("end_stones");
		public static final class_6862<class_2248> ENDERMAN_PLACE_ON_BLACKLIST = tag("enderman_place_on_blacklist");
		public static final class_6862<class_2248> FENCE_GATES = tag("fence_gates");
		public static final class_6862<class_2248> FENCE_GATES_WOODEN = tag("fence_gates/wooden");
		public static final class_6862<class_2248> FENCES = tag("fences");
		public static final class_6862<class_2248> FENCES_NETHER_BRICK = tag("fences/nether_brick");
		public static final class_6862<class_2248> FENCES_WOODEN = tag("fences/wooden");

		public static final class_6862<class_2248> GLASS = tag("glass");
		public static final class_6862<class_2248> GLASS_BLACK = tag("glass/black");
		public static final class_6862<class_2248> GLASS_BLUE = tag("glass/blue");
		public static final class_6862<class_2248> GLASS_BROWN = tag("glass/brown");
		public static final class_6862<class_2248> GLASS_COLORLESS = tag("glass/colorless");
		public static final class_6862<class_2248> GLASS_CYAN = tag("glass/cyan");
		public static final class_6862<class_2248> GLASS_GRAY = tag("glass/gray");
		public static final class_6862<class_2248> GLASS_GREEN = tag("glass/green");
		public static final class_6862<class_2248> GLASS_LIGHT_BLUE = tag("glass/light_blue");
		public static final class_6862<class_2248> GLASS_LIGHT_GRAY = tag("glass/light_gray");
		public static final class_6862<class_2248> GLASS_LIME = tag("glass/lime");
		public static final class_6862<class_2248> GLASS_MAGENTA = tag("glass/magenta");
		public static final class_6862<class_2248> GLASS_ORANGE = tag("glass/orange");
		public static final class_6862<class_2248> GLASS_PINK = tag("glass/pink");
		public static final class_6862<class_2248> GLASS_PURPLE = tag("glass/purple");
		public static final class_6862<class_2248> GLASS_RED = tag("glass/red");
		/**
		 * Glass which is made from sand and only minor additional ingredients like dyes
		 */
		public static final class_6862<class_2248> GLASS_SILICA = tag("glass/silica");
		public static final class_6862<class_2248> GLASS_TINTED = tag("glass/tinted");
		public static final class_6862<class_2248> GLASS_WHITE = tag("glass/white");
		public static final class_6862<class_2248> GLASS_YELLOW = tag("glass/yellow");

		public static final class_6862<class_2248> GLASS_PANES = tag("glass_panes");
		public static final class_6862<class_2248> GLASS_PANES_BLACK = tag("glass_panes/black");
		public static final class_6862<class_2248> GLASS_PANES_BLUE = tag("glass_panes/blue");
		public static final class_6862<class_2248> GLASS_PANES_BROWN = tag("glass_panes/brown");
		public static final class_6862<class_2248> GLASS_PANES_COLORLESS = tag("glass_panes/colorless");
		public static final class_6862<class_2248> GLASS_PANES_CYAN = tag("glass_panes/cyan");
		public static final class_6862<class_2248> GLASS_PANES_GRAY = tag("glass_panes/gray");
		public static final class_6862<class_2248> GLASS_PANES_GREEN = tag("glass_panes/green");
		public static final class_6862<class_2248> GLASS_PANES_LIGHT_BLUE = tag("glass_panes/light_blue");
		public static final class_6862<class_2248> GLASS_PANES_LIGHT_GRAY = tag("glass_panes/light_gray");
		public static final class_6862<class_2248> GLASS_PANES_LIME = tag("glass_panes/lime");
		public static final class_6862<class_2248> GLASS_PANES_MAGENTA = tag("glass_panes/magenta");
		public static final class_6862<class_2248> GLASS_PANES_ORANGE = tag("glass_panes/orange");
		public static final class_6862<class_2248> GLASS_PANES_PINK = tag("glass_panes/pink");
		public static final class_6862<class_2248> GLASS_PANES_PURPLE = tag("glass_panes/purple");
		public static final class_6862<class_2248> GLASS_PANES_RED = tag("glass_panes/red");
		public static final class_6862<class_2248> GLASS_PANES_WHITE = tag("glass_panes/white");
		public static final class_6862<class_2248> GLASS_PANES_YELLOW = tag("glass_panes/yellow");

		public static final class_6862<class_2248> GRAVEL = tag("gravel");
		public static final class_6862<class_2248> NETHERRACK = tag("netherrack");
		public static final class_6862<class_2248> OBSIDIAN = tag("obsidian");
		/**
		 * Blocks which are often replaced by deepslate ores, i.e. the ores in the tag {@link #ORES_IN_GROUND_DEEPSLATE}, during world generation
		 */
		public static final class_6862<class_2248> ORE_BEARING_GROUND_DEEPSLATE = tag("ore_bearing_ground/deepslate");
		/**
		 * Blocks which are often replaced by netherrack ores, i.e. the ores in the tag {@link #ORES_IN_GROUND_NETHERRACK}, during world generation
		 */
		public static final class_6862<class_2248> ORE_BEARING_GROUND_NETHERRACK = tag("ore_bearing_ground/netherrack");
		/**
		 * Blocks which are often replaced by stone ores, i.e. the ores in the tag {@link #ORES_IN_GROUND_STONE}, during world generation
		 */
		public static final class_6862<class_2248> ORE_BEARING_GROUND_STONE = tag("ore_bearing_ground/stone");
		/**
		 * Ores which on average result in more than one resource worth of materials
		 */
		public static final class_6862<class_2248> ORE_RATES_DENSE = tag("ore_rates/dense");
		/**
		 * Ores which on average result in one resource worth of materials
		 */
		public static final class_6862<class_2248> ORE_RATES_SINGULAR = tag("ore_rates/singular");
		/**
		 * Ores which on average result in less than one resource worth of materials
		 */
		public static final class_6862<class_2248> ORE_RATES_SPARSE = tag("ore_rates/sparse");
		public static final class_6862<class_2248> ORES = tag("ores");
		public static final class_6862<class_2248> ORES_COAL = tag("ores/coal");
		public static final class_6862<class_2248> ORES_COPPER = tag("ores/copper");
		public static final class_6862<class_2248> ORES_DIAMOND = tag("ores/diamond");
		public static final class_6862<class_2248> ORES_EMERALD = tag("ores/emerald");
		public static final class_6862<class_2248> ORES_GOLD = tag("ores/gold");
		public static final class_6862<class_2248> ORES_IRON = tag("ores/iron");
		public static final class_6862<class_2248> ORES_LAPIS = tag("ores/lapis");
		public static final class_6862<class_2248> ORES_NETHERITE_SCRAP = tag("ores/netherite_scrap");
		public static final class_6862<class_2248> ORES_QUARTZ = tag("ores/quartz");
		public static final class_6862<class_2248> ORES_REDSTONE = tag("ores/redstone");
		/**
		 * Ores in deepslate (or in equivalent blocks in the tag {@link #ORE_BEARING_GROUND_DEEPSLATE}) which could logically use deepslate as recipe input or output
		 */
		public static final class_6862<class_2248> ORES_IN_GROUND_DEEPSLATE = tag("ores_in_ground/deepslate");
		/**
		 * Ores in netherrack (or in equivalent blocks in the tag {@link #ORE_BEARING_GROUND_NETHERRACK}) which could logically use netherrack as recipe input or output
		 */
		public static final class_6862<class_2248> ORES_IN_GROUND_NETHERRACK = tag("ores_in_ground/netherrack");
		/**
		 * Ores in stone (or in equivalent blocks in the tag {@link #ORE_BEARING_GROUND_STONE}) which could logically use stone as recipe input or output
		 */
		public static final class_6862<class_2248> ORES_IN_GROUND_STONE = tag("ores_in_ground/stone");

		public static final class_6862<class_2248> SAND = tag("sand");
		public static final class_6862<class_2248> SAND_COLORLESS = tag("sand/colorless");
		public static final class_6862<class_2248> SAND_RED = tag("sand/red");

		public static final class_6862<class_2248> SANDSTONE = tag("sandstone");
		public static final class_6862<class_2248> STAINED_GLASS = tag("stained_glass");
		public static final class_6862<class_2248> STAINED_GLASS_PANES = tag("stained_glass_panes");
		public static final class_6862<class_2248> STONE = tag("stone");
		public static final class_6862<class_2248> STORAGE_BLOCKS = tag("storage_blocks");
		public static final class_6862<class_2248> STORAGE_BLOCKS_AMETHYST = tag("storage_blocks/amethyst");
		public static final class_6862<class_2248> STORAGE_BLOCKS_COAL = tag("storage_blocks/coal");
		public static final class_6862<class_2248> STORAGE_BLOCKS_COPPER = tag("storage_blocks/copper");
		public static final class_6862<class_2248> STORAGE_BLOCKS_DIAMOND = tag("storage_blocks/diamond");
		public static final class_6862<class_2248> STORAGE_BLOCKS_EMERALD = tag("storage_blocks/emerald");
		public static final class_6862<class_2248> STORAGE_BLOCKS_GOLD = tag("storage_blocks/gold");
		public static final class_6862<class_2248> STORAGE_BLOCKS_IRON = tag("storage_blocks/iron");
		public static final class_6862<class_2248> STORAGE_BLOCKS_LAPIS = tag("storage_blocks/lapis");
		public static final class_6862<class_2248> STORAGE_BLOCKS_NETHERITE = tag("storage_blocks/netherite");
		public static final class_6862<class_2248> STORAGE_BLOCKS_QUARTZ = tag("storage_blocks/quartz");
		public static final class_6862<class_2248> STORAGE_BLOCKS_RAW_COPPER = tag("storage_blocks/raw_copper");
		public static final class_6862<class_2248> STORAGE_BLOCKS_RAW_GOLD = tag("storage_blocks/raw_gold");
		public static final class_6862<class_2248> STORAGE_BLOCKS_RAW_IRON = tag("storage_blocks/raw_iron");
		public static final class_6862<class_2248> STORAGE_BLOCKS_REDSTONE = tag("storage_blocks/redstone");

		public static final class_6862<class_2248> NEEDS_WOOD_TOOL = tag("needs_wood_tool");
		public static final class_6862<class_2248> NEEDS_GOLD_TOOL = tag("needs_gold_tool");
		public static final class_6862<class_2248> NEEDS_NETHERITE_TOOL = tag("needs_netherite_tool");

		public static final class_6862<class_2248> LADDERS = tag("ladders");

        public static class_6862<class_2248> tag(String id) {
            return class_6862.method_40092(class_2378.field_25105, new class_2960("c", id));
        }
    }

    public static class Items {

		public static final class_6862<class_1792> BARRELS = tag("barrels");
		public static final class_6862<class_1792> BARRELS_WOODEN = tag("barrels/wooden");
		public static final class_6862<class_1792> BONES = tag("bones");
		public static final class_6862<class_1792> BOOKSHELVES = tag("bookshelves");
		public static final class_6862<class_1792> CHESTS = tag("chests");
		public static final class_6862<class_1792> CHESTS_ENDER = tag("chests/ender");
		public static final class_6862<class_1792> CHESTS_TRAPPED = tag("chests/trapped");
		public static final class_6862<class_1792> CHESTS_WOODEN = tag("chests/wooden");
		public static final class_6862<class_1792> COBBLESTONE = tag("cobblestone");
        public static final class_6862<class_1792> COBBLESTONE_NORMAL = tag("cobblestone/normal");
        public static final class_6862<class_1792> COBBLESTONE_INFESTED = tag("cobblestone/infested");
        public static final class_6862<class_1792> COBBLESTONE_MOSSY = tag("cobblestone/mossy");
        public static final class_6862<class_1792> COBBLESTONE_DEEPSLATE = tag("cobblestone/deepslate");
		public static final class_6862<class_1792> CROPS = tag("crops");
		public static final class_6862<class_1792> CROPS_BEETROOT = tag("crops/beetroot");
		public static final class_6862<class_1792> CROPS_CARROT = tag("crops/carrot");
		public static final class_6862<class_1792> CROPS_NETHER_WART = tag("crops/nether_wart");
		public static final class_6862<class_1792> CROPS_POTATO = tag("crops/potato");
		public static final class_6862<class_1792> CROPS_WHEAT = tag("crops/wheat");
		public static final class_6862<class_1792> DUSTS = tag("dusts");
		public static final class_6862<class_1792> DUSTS_PRISMARINE = tag("dusts/prismarine");
		public static final class_6862<class_1792> DUSTS_REDSTONE = tag("dusts/redstone");
		public static final class_6862<class_1792> DUSTS_GLOWSTONE = tag("dusts/glowstone");

		public static final class_6862<class_1792> DYES = tag("dyes");
		public static final class_6862<class_1792> DYES_BLACK = tag("dyes/black");
		public static final class_6862<class_1792> DYES_RED = tag("dyes/red");
		public static final class_6862<class_1792> DYES_GREEN = tag("dyes/green");
		public static final class_6862<class_1792> DYES_BROWN = tag("dyes/brown");
		public static final class_6862<class_1792> DYES_BLUE = tag("dyes/blue");
		public static final class_6862<class_1792> DYES_PURPLE = tag("dyes/purple");
		public static final class_6862<class_1792> DYES_CYAN = tag("dyes/cyan");
		public static final class_6862<class_1792> DYES_LIGHT_GRAY = tag("dyes/light_gray");
		public static final class_6862<class_1792> DYES_GRAY = tag("dyes/gray");
		public static final class_6862<class_1792> DYES_PINK = tag("dyes/pink");
		public static final class_6862<class_1792> DYES_LIME = tag("dyes/lime");
		public static final class_6862<class_1792> DYES_YELLOW = tag("dyes/yellow");
		public static final class_6862<class_1792> DYES_LIGHT_BLUE = tag("dyes/light_blue");
		public static final class_6862<class_1792> DYES_MAGENTA = tag("dyes/magenta");
		public static final class_6862<class_1792> DYES_ORANGE = tag("dyes/orange");
		public static final class_6862<class_1792> DYES_WHITE = tag("dyes/white");

		public static final class_6862<class_1792> EGGS = tag("eggs");
		public static final class_6862<class_1792> ENCHANTING_FUELS = tag("enchanting_fuels"/*, Set.of(net.minecraft.world.item.Items.LAPIS_LAZULI)*/);
		public static final class_6862<class_1792> END_STONES = tag("end_stones");
		public static final class_6862<class_1792> ENDER_PEARLS = tag("ender_pearls");
		public static final class_6862<class_1792> FEATHERS = tag("feathers");
		public static final class_6862<class_1792> FENCE_GATES = tag("fence_gates");
		public static final class_6862<class_1792> FENCE_GATES_WOODEN = tag("fence_gates/wooden");
		public static final class_6862<class_1792> FENCES = tag("fences");
		public static final class_6862<class_1792> FENCES_NETHER_BRICK = tag("fences/nether_brick");
		public static final class_6862<class_1792> FENCES_WOODEN = tag("fences/wooden");
		public static final class_6862<class_1792> GEMS = tag("gems");
		public static final class_6862<class_1792> GEMS_DIAMOND = tag("gems/diamond");
		public static final class_6862<class_1792> GEMS_EMERALD = tag("gems/emerald");
		public static final class_6862<class_1792> GEMS_AMETHYST = tag("gems/amethyst");
		public static final class_6862<class_1792> GEMS_LAPIS = tag("gems/lapis");
		public static final class_6862<class_1792> GEMS_PRISMARINE = tag("gems/prismarine");
		public static final class_6862<class_1792> GEMS_QUARTZ = tag("gems/quartz");

		public static final class_6862<class_1792> GLASS = tag("glass");
		public static final class_6862<class_1792> GLASS_BLACK = tag("glass/black");
		public static final class_6862<class_1792> GLASS_BLUE = tag("glass/blue");
		public static final class_6862<class_1792> GLASS_BROWN = tag("glass/brown");
		public static final class_6862<class_1792> GLASS_COLORLESS = tag("glass/colorless");
		public static final class_6862<class_1792> GLASS_CYAN = tag("glass/cyan");
		public static final class_6862<class_1792> GLASS_GRAY = tag("glass/gray");
		public static final class_6862<class_1792> GLASS_GREEN = tag("glass/green");
		public static final class_6862<class_1792> GLASS_LIGHT_BLUE = tag("glass/light_blue");
		public static final class_6862<class_1792> GLASS_LIGHT_GRAY = tag("glass/light_gray");
		public static final class_6862<class_1792> GLASS_LIME = tag("glass/lime");
		public static final class_6862<class_1792> GLASS_MAGENTA = tag("glass/magenta");
		public static final class_6862<class_1792> GLASS_ORANGE = tag("glass/orange");
		public static final class_6862<class_1792> GLASS_PINK = tag("glass/pink");
		public static final class_6862<class_1792> GLASS_PURPLE = tag("glass/purple");
		public static final class_6862<class_1792> GLASS_RED = tag("glass/red");
		/**
		 * Glass which is made from sand and only minor additional ingredients like dyes
		 */
		public static final class_6862<class_1792> GLASS_SILICA = tag("glass/silica");
		public static final class_6862<class_1792> GLASS_TINTED = tag("glass/tinted");
		public static final class_6862<class_1792> GLASS_WHITE = tag("glass/white");
		public static final class_6862<class_1792> GLASS_YELLOW = tag("glass/yellow");

		public static final class_6862<class_1792> GLASS_PANES = tag("glass_panes");
		public static final class_6862<class_1792> GLASS_PANES_BLACK = tag("glass_panes/black");
		public static final class_6862<class_1792> GLASS_PANES_BLUE = tag("glass_panes/blue");
		public static final class_6862<class_1792> GLASS_PANES_BROWN = tag("glass_panes/brown");
		public static final class_6862<class_1792> GLASS_PANES_COLORLESS = tag("glass_panes/colorless");
		public static final class_6862<class_1792> GLASS_PANES_CYAN = tag("glass_panes/cyan");
		public static final class_6862<class_1792> GLASS_PANES_GRAY = tag("glass_panes/gray");
		public static final class_6862<class_1792> GLASS_PANES_GREEN = tag("glass_panes/green");
		public static final class_6862<class_1792> GLASS_PANES_LIGHT_BLUE = tag("glass_panes/light_blue");
		public static final class_6862<class_1792> GLASS_PANES_LIGHT_GRAY = tag("glass_panes/light_gray");
		public static final class_6862<class_1792> GLASS_PANES_LIME = tag("glass_panes/lime");
		public static final class_6862<class_1792> GLASS_PANES_MAGENTA = tag("glass_panes/magenta");
		public static final class_6862<class_1792> GLASS_PANES_ORANGE = tag("glass_panes/orange");
		public static final class_6862<class_1792> GLASS_PANES_PINK = tag("glass_panes/pink");
		public static final class_6862<class_1792> GLASS_PANES_PURPLE = tag("glass_panes/purple");
		public static final class_6862<class_1792> GLASS_PANES_RED = tag("glass_panes/red");
		public static final class_6862<class_1792> GLASS_PANES_WHITE = tag("glass_panes/white");
		public static final class_6862<class_1792> GLASS_PANES_YELLOW = tag("glass_panes/yellow");

		public static final class_6862<class_1792> GRAVEL = tag("gravel");
		public static final class_6862<class_1792> GUNPOWDER = tag("gunpowder");
		public static final class_6862<class_1792> HEADS = tag("heads");
		public static final class_6862<class_1792> INGOTS = tag("ingots");
		public static final class_6862<class_1792> INGOTS_BRICK = tag("ingots/brick");
		public static final class_6862<class_1792> INGOTS_COPPER = tag("ingots/copper");
		public static final class_6862<class_1792> INGOTS_GOLD = tag("ingots/gold");
		public static final class_6862<class_1792> INGOTS_IRON = tag("ingots/iron");
		public static final class_6862<class_1792> INGOTS_NETHERITE = tag("ingots/netherite");
		public static final class_6862<class_1792> INGOTS_NETHER_BRICK = tag("ingots/nether_brick");
		public static final class_6862<class_1792> LEATHER = tag("leather");
		public static final class_6862<class_1792> MUSHROOMS = tag("mushrooms");
		public static final class_6862<class_1792> NETHER_STARS = tag("nether_stars");
		public static final class_6862<class_1792> NETHERRACK = tag("netherrack");
		public static final class_6862<class_1792> NUGGETS = tag("nuggets");
		public static final class_6862<class_1792> NUGGETS_GOLD = tag("nuggets/gold");
		public static final class_6862<class_1792> NUGGETS_IRON = tag("nuggets/iron");
		public static final class_6862<class_1792> OBSIDIAN = tag("obsidian");
		/**
		 * Blocks which are often replaced by deepslate ores, i.e. the ores in the tag {@link #ORES_IN_GROUND_DEEPSLATE}, during world generation
		 */
		public static final class_6862<class_1792> ORE_BEARING_GROUND_DEEPSLATE = tag("ore_bearing_ground/deepslate");
		/**
		 * Blocks which are often replaced by netherrack ores, i.e. the ores in the tag {@link #ORES_IN_GROUND_NETHERRACK}, during world generation
		 */
		public static final class_6862<class_1792> ORE_BEARING_GROUND_NETHERRACK = tag("ore_bearing_ground/netherrack");
		/**
		 * Blocks which are often replaced by stone ores, i.e. the ores in the tag {@link #ORES_IN_GROUND_STONE}, during world generation
		 */
		public static final class_6862<class_1792> ORE_BEARING_GROUND_STONE = tag("ore_bearing_ground/stone");
		/**
		 * Ores which on average result in more than one resource worth of materials
		 */
		public static final class_6862<class_1792> ORE_RATES_DENSE = tag("ore_rates/dense");
		/**
		 * Ores which on average result in one resource worth of materials
		 */
		public static final class_6862<class_1792> ORE_RATES_SINGULAR = tag("ore_rates/singular");
		/**
		 * Ores which on average result in less than one resource worth of materials
		 */
		public static final class_6862<class_1792> ORE_RATES_SPARSE = tag("ore_rates/sparse");
		public static final class_6862<class_1792> ORES = tag("ores");
		public static final class_6862<class_1792> ORES_COAL = tag("ores/coal");
		public static final class_6862<class_1792> ORES_COPPER = tag("ores/copper");
		public static final class_6862<class_1792> ORES_DIAMOND = tag("ores/diamond");
		public static final class_6862<class_1792> ORES_EMERALD = tag("ores/emerald");
		public static final class_6862<class_1792> ORES_GOLD = tag("ores/gold");
		public static final class_6862<class_1792> ORES_IRON = tag("ores/iron");
		public static final class_6862<class_1792> ORES_LAPIS = tag("ores/lapis");
		public static final class_6862<class_1792> ORES_NETHERITE_SCRAP = tag("ores/netherite_scrap");
		public static final class_6862<class_1792> ORES_QUARTZ = tag("ores/quartz");
		public static final class_6862<class_1792> ORES_REDSTONE = tag("ores/redstone");
		/**
		 * Ores in deepslate (or in equivalent blocks in the tag {@link #ORE_BEARING_GROUND_DEEPSLATE}) which could logically use deepslate as recipe input or output
		 */
		public static final class_6862<class_1792> ORES_IN_GROUND_DEEPSLATE = tag("ores_in_ground/deepslate");
		/**
		 * Ores in netherrack (or in equivalent blocks in the tag {@link #ORE_BEARING_GROUND_NETHERRACK}) which could logically use netherrack as recipe input or output
		 */
		public static final class_6862<class_1792> ORES_IN_GROUND_NETHERRACK = tag("ores_in_ground/netherrack");
		/**
		 * Ores in stone (or in equivalent blocks in the tag {@link #ORE_BEARING_GROUND_STONE}) which could logically use stone as recipe input or output
		 */
		public static final class_6862<class_1792> ORES_IN_GROUND_STONE = tag("ores_in_ground/stone");
		public static final class_6862<class_1792> RAW_MATERIALS = tag("raw_materials");
		public static final class_6862<class_1792> RAW_MATERIALS_COPPER = tag("raw_materials/copper");
		public static final class_6862<class_1792> RAW_MATERIALS_GOLD = tag("raw_materials/gold");
		public static final class_6862<class_1792> RAW_MATERIALS_IRON = tag("raw_materials/iron");
		public static final class_6862<class_1792> RODS = tag("rods");
		public static final class_6862<class_1792> RODS_BLAZE = tag("rods/blaze");
		public static final class_6862<class_1792> RODS_WOODEN = tag("rods/wooden");

		public static final class_6862<class_1792> SAND = tag("sand");
		public static final class_6862<class_1792> SAND_COLORLESS = tag("sand/colorless");
		public static final class_6862<class_1792> SAND_RED = tag("sand/red");

		public static final class_6862<class_1792> SANDSTONE = tag("sandstone");
		public static final class_6862<class_1792> SEEDS = tag("seeds");
		public static final class_6862<class_1792> SEEDS_BEETROOT = tag("seeds/beetroot");
		public static final class_6862<class_1792> SEEDS_MELON = tag("seeds/melon");
		public static final class_6862<class_1792> SEEDS_PUMPKIN = tag("seeds/pumpkin");
		public static final class_6862<class_1792> SEEDS_WHEAT = tag("seeds/wheat");
		public static final class_6862<class_1792> SHEARS = tag("shears");
		public static final class_6862<class_1792> SLIMEBALLS = tag("slimeballs");
		public static final class_6862<class_1792> STAINED_GLASS = tag("stained_glass");
		public static final class_6862<class_1792> STAINED_GLASS_PANES = tag("stained_glass_panes");
		public static final class_6862<class_1792> STONE = tag("stone");
		public static final class_6862<class_1792> STORAGE_BLOCKS = tag("storage_blocks");
		public static final class_6862<class_1792> STORAGE_BLOCKS_AMETHYST = tag("storage_blocks/amethyst");
		public static final class_6862<class_1792> STORAGE_BLOCKS_COAL = tag("storage_blocks/coal");
		public static final class_6862<class_1792> STORAGE_BLOCKS_COPPER = tag("storage_blocks/copper");
		public static final class_6862<class_1792> STORAGE_BLOCKS_DIAMOND = tag("storage_blocks/diamond");
		public static final class_6862<class_1792> STORAGE_BLOCKS_EMERALD = tag("storage_blocks/emerald");
		public static final class_6862<class_1792> STORAGE_BLOCKS_GOLD = tag("storage_blocks/gold");
		public static final class_6862<class_1792> STORAGE_BLOCKS_IRON = tag("storage_blocks/iron");
		public static final class_6862<class_1792> STORAGE_BLOCKS_LAPIS = tag("storage_blocks/lapis");
		public static final class_6862<class_1792> STORAGE_BLOCKS_NETHERITE = tag("storage_blocks/netherite");
		public static final class_6862<class_1792> STORAGE_BLOCKS_QUARTZ = tag("storage_blocks/quartz");
		public static final class_6862<class_1792> STORAGE_BLOCKS_RAW_COPPER = tag("storage_blocks/raw_copper");
		public static final class_6862<class_1792> STORAGE_BLOCKS_RAW_GOLD = tag("storage_blocks/raw_gold");
		public static final class_6862<class_1792> STORAGE_BLOCKS_RAW_IRON = tag("storage_blocks/raw_iron");
		public static final class_6862<class_1792> STORAGE_BLOCKS_REDSTONE = tag("storage_blocks/redstone");
		public static final class_6862<class_1792> STRING = tag("string");

		public static final class_6862<class_1792> BUCKETS_WATER = tag("buckets/water");
		public static final class_6862<class_1792> BUCKETS_LAVA = tag("buckets/lava");
		public static final class_6862<class_1792> BUCKETS_MILK = tag("buckets/milk");
		public static final class_6862<class_1792> BUCKETS_POWDER_SNOW = tag("buckets/powder_snow");
		public static final class_6862<class_1792> BUCKETS = tag("buckets");

		public static final class_6862<class_1792> LADDERS = tag("ladders");

        public static class_6862<class_1792> tag(String id) {
            return class_6862.method_40092(class_2378.field_25108, new class_2960("c", id));
        }
    }

    public static class EntityTypes {
        public static final class_6862<class_1299<?>> BOSSES = tag("bosses");

        /**
         * Mobs that are dragons, draconic, or close enough to being dragons
         */
        public static final class_6862<class_1299<?>> DRAGONS = tag("dragons");

        public static final class_6862<class_1299<?>> GOLEMS = tag("golems");

        /**
         * Mobs that are build with blocks and then summoned
         */
        public static final class_6862<class_1299<?>> BUILDABLE_MOBS = tag("buildable_mobs");

        public static final class_6862<class_1299<?>> BIG_NOSES = tag("big_noses");
        public static final class_6862<class_1299<?>> ILLAGERS = tag("illagers");

        /**
         * Mobs that are logically composed of an element
         * If your mob is made of a different element, and you want cross-compatibility between mods, feel free to make a new tag
         * If your mob is made of a combination of elements, feel free to add all appropriate tags to it
         */
        public static final class_6862<class_1299<?>> ELEMENTAL = tag("elemental");
        public static final class_6862<class_1299<?>> ELEMENTAL_FIRE = tag("elemental/fire");
        public static final class_6862<class_1299<?>> ELEMENTAL_ICE = tag("elemental/ice");
        public static final class_6862<class_1299<?>> ELEMENTAL_METAL = tag("elemental/metal");

        /**
         * Attack entities that have logical elemental properties
         * If your attack entity is made of a different element, and you want cross-compatibility between mods, feel free to make a new tag
         * If your attack entity is made of a combination of elements, feel free to add all appropriate tags to it
         */
        public static final class_6862<class_1299<?>> ELEMENTAL_ATTACKS = tag("elemental_attacks");
        public static final class_6862<class_1299<?>> ELEMENTAL_ATTACKS_ELECTRIC = tag("elemental_attacks/electric");
        public static final class_6862<class_1299<?>> ELEMENTAL_ATTACKS_FIRE = tag("elemental_attacks/fire");
        public static final class_6862<class_1299<?>> ELEMENTAL_ATTACKS_ICE = tag("elemental_attacks/ice");

        public static final class_6862<class_1299<?>> ARTHROPODS = tag("animals/arthropods");

        public static final class_6862<class_1299<?>> AVIANS = tag("avians");
        public static final class_6862<class_1299<?>> AVIANS_FOWLS = tag("avians/fowls");

        //Mobs which are living in the water
        public static final class_6862<class_1299<?>> AQUATIC = tag("aquatic");
        public static final class_6862<class_1299<?>> FISH = tag("aquatic/fish");
        public static final class_6862<class_1299<?>> CEPHALOPODS = tag("aquatic/cephalopods");
        public static final class_6862<class_1299<?>> GUARDIANS = tag("aquatic/guardians");

        public static final class_6862<class_1299<?>> REPTILES = tag("reptiles");

        public static final class_6862<class_1299<?>> MAMMALS = tag("mammals");
        public static final class_6862<class_1299<?>> MAMMALS_BOVINES = tag("mammals/bovines");
        public static final class_6862<class_1299<?>> MAMMALS_BOVINES_CATTLE = tag("mammals/bovines_cattle");
        public static final class_6862<class_1299<?>> MAMMALS_CAMELIDS = tag("mammals/camelids");
        public static final class_6862<class_1299<?>> MAMMALS_CANIDS = tag("mammals/canids");
        public static final class_6862<class_1299<?>> MAMMALS_CAPRINES = tag("mammals/caprines");
        public static final class_6862<class_1299<?>> MAMMALS_EQUINES = tag("mammals/equines");
        public static final class_6862<class_1299<?>> MAMMALS_FELINES = tag("mammals/felines");
        public static final class_6862<class_1299<?>> MAMMALS_SWINES = tag("mammals/swines");
        public static final class_6862<class_1299<?>> MAMMALS_URSIDS = tag("mammals/ursids");

        public static final class_6862<class_1299<?>> GHOSTS = tag("ghosts");

        public static final class_6862<class_1299<?>> MILKABLE = tag("milkable");
        public static final class_6862<class_1299<?>> MUSHROOM_COWS = tag("mushroom_cows");

        public static final class_6862<class_1299<?>> BLIND_MOBS = tag("blind_mobs");

        public static final class_6862<class_1299<?>> FLYING = tag("flying");
        public static final class_6862<class_1299<?>> LAND = tag("land");

        /**
         * Mobs that prefer to live in lava
         */
        public static final class_6862<class_1299<?>> VOLCANIC = tag("volcanic");

        public static final class_6862<class_1299<?>> HELL_MOBS = tag("hell_mobs");

        /**
         * Mobs that are meant to be antagonistic to the player
         */
        public static final class_6862<class_1299<?>> ENEMIES = tag("enemies");
        public static final class_6862<class_1299<?>> CREEPERS = tag("creepers");

        public static final class_6862<class_1299<?>> UNDEAD = tag("undead");
        public static final class_6862<class_1299<?>> SKELETONS = tag("undead/skeletons");
        public static final class_6862<class_1299<?>> ZOMBIES = tag("undead/zombies");

        /**
         * Mobs that simulate an intelligent, independent relationship of some sort with the player
         */
        public static final class_6862<class_1299<?>> NPC = tag("npc");

        private static class_6862<class_1299<?>> tag(String name) {
            return class_6862.method_40092(class_2378.field_25107, new class_2960("c", name));
        }
    }

    public static class Biomes {
        // Tags specifying aquatic biomes

		// Tags specifying that a biome is a variant of a normal biome
		public static final class_6862<class_1959> RARE = tag("rare");
		public static final class_6862<class_1959> PLATEAUS = tag("plateaus"); // plateau variants of other biomes
		public static final class_6862<class_1959> HILLS = tag("hills"); // hills variants of other biomes

		// Tags specifying aquatic biomes
		public static final class_6862<class_1959> OCEANS = tag("water/oceans");
		public static final class_6862<class_1959> SHALLOW_OCEANS = tag("water/oceans/shallow");
		public static final class_6862<class_1959> DEEP_OCEANS = tag("water/oceans/deep");
		public static final class_6862<class_1959> RIVERS = tag("water/rivers");
		public static final class_6862<class_1959> WATER = tag("water");

		// Tags specifying generic types of biomes
		public static final class_6862<class_1959> BADLANDS = tag("badlands");
		public static final class_6862<class_1959> BEACHES = tag("beaches");
		public static final class_6862<class_1959> DESERTS = tag("deserts");
		public static final class_6862<class_1959> FORESTS = tag("forests");
		public static final class_6862<class_1959> BIRCH_FORESTS = tag("forests/birch");
		public static final class_6862<class_1959> DARK_FORESTS = tag("forests/dark");
		public static final class_6862<class_1959> JUNGLE_FORESTS = tag("forests/jungles");
		public static final class_6862<class_1959> BAMBOO_JUNGLE_FORESTS = tag("forests/jungles/bamboo");
		public static final class_6862<class_1959> NETHER_FORESTS = tag("forests/nether");
		public static final class_6862<class_1959> OAK_FORESTS = tag("forests/oak");
		public static final class_6862<class_1959> TAIGA_FORESTS = tag("forests/taigas");
		public static final class_6862<class_1959> GRASSLANDS = tag("grasslands"); // plains and savannas
		public static final class_6862<class_1959> MUSHROOM = tag("mushroom");
		public static final class_6862<class_1959> MOUNTAINS = tag("mountains");
		public static final class_6862<class_1959> PEAKS = tag("peaks");
		public static final class_6862<class_1959> PLAINS = tag("plains");
		public static final class_6862<class_1959> SAVANNAS = tag("savannas");
		public static final class_6862<class_1959> SNOWY = tag("snowy"); // indicates that a biome has snow and/or ice
		public static final class_6862<class_1959> SLOPES = tag("slopes");
		public static final class_6862<class_1959> SWAMPS = tag("swamps");
		public static final class_6862<class_1959> VOIDS = tag("voids");

		// Tags specifying that a biome generates in a vanilla dimension. Specifying none of these indicates that the biome only generates in a modded dimension
		public static final class_6862<class_1959> OVERWORLD = tag("overworld");
		public static final class_6862<class_1959> OVERWORLD_SURFACE = tag("overworld/surface");
		public static final class_6862<class_1959> OVERWORLD_UNDERGROUND = tag("overworld/underground");
		public static final class_6862<class_1959> NETHER = tag("nether");
		public static final class_6862<class_1959> END = tag("end");

        private static class_6862<class_1959> tag(String name) {
            return class_6862.method_40092(class_2378.field_25114, new class_2960("c", name));
        }
    }

    public static class NoiseSettings {
		public static final class_6862<class_5284> AMPLIFIED = tag("amplified");
		public static final class_6862<class_5284> CAVES = tag("caves");
		public static final class_6862<class_5284> END = tag("end");
		public static final class_6862<class_5284> FLOATING_ISLANDS = tag("floating_islands");
		public static final class_6862<class_5284> NETHER = tag("nether");
		public static final class_6862<class_5284> OVERWORLD = tag("overworld");

        private static class_6862<class_5284> tag(String name) {
            return class_6862.method_40092(class_2378.field_26374, new class_2960("c", name));
        }
    }

    public static class DimensionTypes {
		public static final class_6862<class_2874> END = tag("end");
		public static final class_6862<class_2874> NETHER = tag("nether");
		public static final class_6862<class_2874> OVERWORLD = tag("overworld");
		public static final class_6862<class_2874> OVERWORLD_CAVES = tag("overworld/caves");

        private static class_6862<class_2874> tag(String name) {
            return class_6862.method_40092(class_2378.field_25095, new class_2960("c", name));
        }
    }

    public static class MobEffects {
        public static final class_6862<class_1291> NEGATIVES = tag("negatives");
        public static final class_6862<class_1291> POSITIVES = tag("positives");

        public static final class_6862<class_1291> INSTANT = tag("instant");
        public static final class_6862<class_1291> LASTING = tag("lasting");

        private static class_6862<class_1291> tag(String name) {
            return class_6862.method_40092(class_2378.field_25104, new class_2960("c", name));
        }
    }

    public static class Enchantments {
        public static final class_6862<class_1887> TOOL_ENCHANTMENTS = tag("tools");
        public static final class_6862<class_1887> PICKAXE_ENCHANTMENTS = tag("tools/pickaxes");
        public static final class_6862<class_1887> AXE_ENCHANTMENTS = tag("tools/axes");
        public static final class_6862<class_1887> HOE_ENCHANTMENTS = tag("tools/hoes");
        public static final class_6862<class_1887> SHOVEL_ENCHANTMENTS = tag("tools/shovels");

        public static final class_6862<class_1887> WEAPON_ENCHANTMENTS = tag("weapons");
        public static final class_6862<class_1887> SWORD_ENCHANTMENTS = tag("weapons/sword");

        public static final class_6862<class_1887> BOW_ENCHANTMENTS = tag("range/bows");
        public static final class_6862<class_1887> CROSSBOW_ENCHANTMENTS = tag("range/crossbows");
        public static final class_6862<class_1887> TRIDENT_ENCHANTMENTS = tag("range/tridents");

        public static final class_6862<class_1887> CURSES = tag("curses");

        public static final class_6862<class_1887> ARMOR_ENCHANTMENTS = tag("armors");
        public static final class_6862<class_1887> HEAD_ENCHANTMENTS = tag("armors/head");
        public static final class_6862<class_1887> CHEST_ENCHANTMENTS = tag("armors/chest");
        public static final class_6862<class_1887> LEGS_ENCHANTMENTS = tag("armors/legs");
        public static final class_6862<class_1887> FEET_ENCHANTMENTS = tag("armors/feet");

        private static class_6862<class_1887> tag(String name) {
            return class_6862.method_40092(class_2378.field_25106, new class_2960("c", name));
        }
    }

    public static class Potions {
        public static final class_6862<class_1842> NEGATIVE_POTIONS = tag("negatives");
        public static final class_6862<class_1842> POSITIVE_POTIONS = tag("positives");

        public static final class_6862<class_1842> INSTANT_POTIONS = tag("instant");
        public static final class_6862<class_1842> LASTING_POTIONS = tag("lasting");

        private static class_6862<class_1842> tag(String name) {
            return class_6862.method_40092(class_2378.field_25109, new class_2960("c", name));
        }
    }

    public static class Motives {
        public static final class_6862<class_1535> ONE_X_ONE = tag("1x1");
        public static final class_6862<class_1535> TWO_X_ONE = tag("2x1");
        public static final class_6862<class_1535> ONE_X_TWO = tag("1x2");
        public static final class_6862<class_1535> TWO_X_TWO = tag("2x2");
        public static final class_6862<class_1535> FOUR_X_TWO = tag("4x2");
        public static final class_6862<class_1535> FOUR_X_THREE = tag("4x3");
        public static final class_6862<class_1535> FOUR_X_FOUR = tag("4x4");

        private static class_6862<class_1535> tag(String name) {
            return class_6862.method_40092(class_2378.field_25074, new class_2960("c", name));
        }
    }

}
