package io.github.vampirestudios.vampirelib.mixins;

import org.jetbrains.annotations.Contract;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import io.github.vampirestudios.vampirelib.api.Matrix4fExtensions;
import net.minecraft.class_1159;

@Mixin(class_1159.class)
public abstract class Matrix4fMixin implements Matrix4fExtensions {
	@Shadow
	protected float m00;
	@Shadow
	protected float m01;
	@Shadow
	protected float m02;
	@Shadow
	protected float m03;
	@Shadow
	protected float m10;
	@Shadow
	protected float m11;
	@Shadow
	protected float m12;
	@Shadow
	protected float m13;
	@Shadow
	protected float m20;
	@Shadow
	protected float m21;
	@Shadow
	protected float m22;
	@Shadow
	protected float m23;
	@Shadow
	protected float m30;
	@Shadow
	protected float m31;
	@Shadow
	protected float m32;
	@Shadow
	protected float m33;

	@Shadow
	public abstract void load(class_1159 other);

	@Override
	@Contract(mutates = "this")
	public void fromFloatArray(float[] floats) {
		m00 = floats[0];
		m01 = floats[1];
		m02 = floats[2];
		m03 = floats[3];

		m10 = floats[4];
		m11 = floats[5];
		m12 = floats[6];
		m13 = floats[7];

		m20 = floats[8];
		m21 = floats[9];
		m22 = floats[10];
		m23 = floats[11];

		m30 = floats[12];
		m31 = floats[13];
		m32 = floats[14];
		m33 = floats[15];
	}

	@Unique
	@Override
	public void setTranslation(float x, float y, float z) {
		m00 = 1.0F;
		m11 = 1.0F;
		m22 = 1.0F;
		m33 = 1.0F;
		m03 = x;
		m13 = y;
		m23 = z;
	}

	@Unique
	@Override
	public void multiplyBackward(class_1159 other) {
		class_1159 copy = other.method_22673();
		copy.method_22672((class_1159) (Object) this);
		this.load(copy);
	}
}