package io.github.vampirestudios.vampirelib.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import io.github.vampirestudios.vampirelib.callbacks.PlayerEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1657;

@Mixin(class_1657.class)
public class PlayerMixin {
    @Inject(method = "isScoping", at = @At("RETURN"), cancellable = true)
    public void isScoping(CallbackInfoReturnable<Boolean> cir) {
        boolean currentScoping = cir.getReturnValue();
        if (currentScoping != PlayerEvents.oldScoping) {
            PlayerEvents.oldScoping = currentScoping;
            class_1269 result = PlayerEvents.SCOPING.invoker().onPlayerScoping(currentScoping, (class_1657)(Object)this);
            if (result == class_1269.field_5814) PlayerEvents.oldScoping = !currentScoping;
            System.out.println(currentScoping);
        }
        cir.setReturnValue(PlayerEvents.oldScoping);
    }
}
