package io.github.vampirestudios.vampirelib.mixins.block;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import io.github.vampirestudios.vampirelib.api.blockspreading.BlockSpreadingType;
import io.github.vampirestudios.vampirelib.api.blockspreading.SpreadBehaviors;
import io.github.vampirestudios.vampirelib.api.blockspreading.SpreadingBlock;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2488;
import net.minecraft.class_2493;
import net.minecraft.class_2500;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3558;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

@Mixin(class_2500.class)
public abstract class SpreadableBlockMixin extends class_2493 implements SpreadingBlock {

	protected SpreadableBlockMixin(class_4970.class_2251 settings) {
		super(settings);
	}

	@Shadow
	private static boolean canBeGrass(class_2680 state, class_4538 levelReader, class_2338 pos) {
		class_2338 blockPos = pos.method_10084();
		class_2680 blockState = levelReader.method_8320(blockPos);
		if (blockState.method_27852(class_2246.field_10477) && blockState.method_11654(class_2488.field_11518) == 1) {
			return true;
		} else if (blockState.method_26227().method_15761() == 8) {
			return false;
		} else {
			int i = class_3558.method_20049(levelReader, state, pos, blockState, blockPos, class_2350.field_11036, blockState.method_26193(levelReader, blockPos));
			return i < levelReader.method_8315();
		}
	}

	@Shadow
	private static boolean canPropagate(class_2680 state, class_4538 level, class_2338 pos) {
		class_2338 blockPos = pos.method_10084();
		return canBeGrass(state, level, pos) && !level.method_8316(blockPos).method_15767(class_3486.field_15517);
	}

	/**
	 * @author OliviaTheVampire
	 */
	@Inject(method = "randomTick", at=@At("HEAD"), cancellable = true)
	public void randomTick(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
		if (!canBeGrass(state, world, pos)) {
			if (!world.method_22343(pos.method_10069(-1, -1, -1), pos.method_10069(1, 1, 1))) return; // Forge: prevent loading unloaded chunks when checking neighbor's light and spreading
			if (SpreadBehaviors.canSpread(state, BlockSpreadingType.REVERT)) //Forge: switch to use SpreadBehaviors API, so this class can be used more easily
				world.method_8501(pos, SpreadBehaviors.getSpreadState(state, world, pos, BlockSpreadingType.REVERT));
		} else {
			if (!world.method_22343(pos.method_10069(-3, -3, -3), pos.method_10069(3, 3, 3))) return; // Forge: prevent loading unloaded chunks when checking neighbor's light and spreading
			if (world.method_8317(pos.method_10084()) >= 9) {
				this.spread(state, world, pos, random, 4, 1);
				class_2680 blockState = this.method_9564();

				for (int i = 0; i < 4; ++i) {
					class_2338 blockPos = pos.method_10069(random.method_43048(3) - 1, random.method_43048(5) - 3, random.method_43048(3) - 1);
					if (world.method_8320(blockPos).method_27852(class_2246.field_10566) && canPropagate(blockState, world, blockPos)) {
						world.method_8501(blockPos, blockState.method_11657(field_11522, world.method_8320(blockPos.method_10084()).method_27852(class_2246.field_10477)));
					}
				}
			}
		}
		ci.cancel();
	}
}
