package io.github.vampirestudios.vampirelib.mixins.client;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_785;
import net.minecraft.class_793;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import io.github.vampirestudios.vampirelib.api.BlockModelExtensions;
import io.github.vampirestudios.vampirelib.client.model.IModelGeometry;
import io.github.vampirestudios.vampirelib.client.model.ModelLoaderRegistry;

@Mixin(class_793.class_795.class)
public abstract class BlockModelDeserializerMixin {

	@Inject(method = "deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/client/renderer/block/model/BlockModel;", at = @At("RETURN"), cancellable = true)
	public void modelLoading(JsonElement element, Type type, JsonDeserializationContext deserializationContext, CallbackInfoReturnable<class_793> cir) {
		class_793 model = cir.getReturnValue();
		JsonObject jsonobject = element.getAsJsonObject();
		IModelGeometry<?> geometry = ModelLoaderRegistry.deserializeGeometry(deserializationContext, jsonobject);

		List<class_785> elements = model.method_3433();
		if (geometry != null) {
			elements.clear();
			((BlockModelExtensions) model).getGeometry().setCustomGeometry(geometry);
		}

		class_3665 modelState = ModelLoaderRegistry.deserializeModelTransforms(deserializationContext, jsonobject);
		if (modelState != null) {
			((BlockModelExtensions) model).getGeometry().setCustomModelState(modelState);
		}

		if (jsonobject.has("visibility")) {
			JsonObject visibility = class_3518.method_15296(jsonobject, "visibility");
			for (Map.Entry<String, JsonElement> part : visibility.entrySet()) {
				((BlockModelExtensions) model).getGeometry().visibilityData.setVisibilityState(part.getKey(), part.getValue().getAsBoolean());
			}
		}
	}
}