package io.github.vampirestudios.vampirelib.mixins.client;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_799;
import net.minecraft.class_801;
import net.minecraft.class_806;
import com.google.common.collect.Sets;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import com.mojang.datafixers.util.Pair;
import io.github.vampirestudios.vampirelib.api.BlockModelExtensions;
import io.github.vampirestudios.vampirelib.client.model.BlockModelConfiguration;
import io.github.vampirestudios.vampirelib.client.model.CompositeModelState;
import io.github.vampirestudios.vampirelib.client.model.IModelGeometry;
import io.github.vampirestudios.vampirelib.client.model.PerspectiveMapWrapper;
import io.github.vampirestudios.vampirelib.client.render.TransformTypeDependentItemBakedModel;

@Mixin(class_793.class)
public abstract class BlockModelMixin implements BlockModelExtensions {
	@Shadow
	@Final
	private static Logger LOGGER;

	@Unique
	private final BlockModelConfiguration data = new BlockModelConfiguration((class_793) (Object) this);

	@Shadow
	public String name;

	@Shadow
	@Nullable
	public class_2960 parentLocation;

	@Shadow
	@Final
	private List<class_799> overrides;

	@Shadow
	public abstract class_793 getRootModel();

	@Shadow
	public abstract class_4730 getMaterial(String name);

	@Shadow
	public abstract List<class_785> getElements();

	@Unique
	@Override
	public BlockModelConfiguration getGeometry() {
		return data;
	}

	@Unique
	@Override
	public class_806 getOverrides(class_1088 pModelBakery, class_793 pModel, Function<class_4730, class_1058> textureGetter) {
		return this.overrides.isEmpty() ? class_806.field_4292 : new class_806(pModelBakery, pModel, pModelBakery::method_4726/*, textureGetter*/, this.overrides);
	}

	/**
	 * @author AlphaMode
	 * TODO: Replace with ASM PortingLibER
	 */
	@Overwrite
	public Collection<class_4730> getMaterials(Function<class_2960, class_1100> pModelGetter, Set<Pair<String, String>> pMissingTextureErrors) {
		Set<class_1100> set = Sets.newLinkedHashSet();
		for (class_793 blockmodel = (class_793) (Object) this; blockmodel.field_4247 != null && blockmodel.field_4253 == null; blockmodel = blockmodel.field_4253) {
			set.add(blockmodel);
			class_1100 unbakedmodel = pModelGetter.apply(blockmodel.field_4247);
			if (unbakedmodel == null) {
				LOGGER.warn("No parent '{}' while loading model '{}'", this.parentLocation, blockmodel);
			}

			if (set.contains(unbakedmodel)) {
				LOGGER.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", blockmodel, set.stream().map(Object::toString).collect(Collectors.joining(" -> ")), this.parentLocation);
				unbakedmodel = null;
			}

			if (unbakedmodel == null) {
				blockmodel.field_4247 = class_1088.field_5374;
				unbakedmodel = pModelGetter.apply(blockmodel.field_4247);
			}

			if (!(unbakedmodel instanceof class_793)) {
				throw new IllegalStateException("BlockModel parent has to be a block model.");
			}

			blockmodel.field_4253 = (class_793) unbakedmodel;
		}

		Set<class_4730> set1 = Sets.newHashSet(this.getMaterial("particle"));

		if (data.hasCustomGeometry())
			set1.addAll(data.getTextureDependencies(pModelGetter, pMissingTextureErrors));
		else
			for (class_785 blockelement : this.getElements()) {
				for (class_783 blockelementface : blockelement.field_4230.values()) {
					class_4730 material = this.getMaterial(blockelementface.field_4224);
					if (Objects.equals(material.method_24147(), class_1047.method_4539())) {
						pMissingTextureErrors.add(Pair.of(blockelementface.field_4224, this.name));
					}

					set1.add(material);
				}
			}

		this.overrides.forEach((p_111475_) -> {
			class_1100 unbakedmodel1 = pModelGetter.apply(p_111475_.method_3472());
			if (!Objects.equals(unbakedmodel1, this)) {
				set1.addAll(unbakedmodel1.method_4754(pModelGetter, pMissingTextureErrors));
			}
		});
		if (this.getRootModel() == class_1088.field_5400) {
			class_801.field_4270.forEach((p_111467_) -> set1.add(this.getMaterial(p_111467_)));
		}

		return set1;
	}

	@Inject(method = "bake(Lnet/minecraft/client/resources/model/ModelBakery;Lnet/minecraft/client/renderer/block/model/BlockModel;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Lnet/minecraft/resources/ResourceLocation;Z)Lnet/minecraft/client/resources/model/BakedModel;", at = @At("HEAD"), cancellable = true)
	public void handleCustomModels(class_1088 modelBakery, class_793 otherModel, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation, boolean guiLight3d, CallbackInfoReturnable<class_1087> cir) {
		class_793 blockModel = (class_793) (Object) this;
		IModelGeometry<?> customModel = data.getCustomGeometry();
		class_3665 customModelState = data.getCustomModelState();
		class_3665 newModelState = modelTransform;
		if (customModelState != null)
			newModelState = new CompositeModelState(modelTransform, customModelState, modelTransform.method_3512());

		if (customModel != null) {
			class_1087 model = customModel.bake(((BlockModelExtensions) blockModel).getGeometry(), modelBakery, spriteGetter, newModelState, ((BlockModelExtensions) blockModel).getOverrides(modelBakery, otherModel, spriteGetter), modelLocation);
			if (customModelState != null && !(model instanceof TransformTypeDependentItemBakedModel))
				model = new PerspectiveMapWrapper(model, customModelState);
			cir.setReturnValue(model);
		}
	}

	@Inject(method = "getElements", at = @At("HEAD"), cancellable = true)
	public void fixElements(CallbackInfoReturnable<List<class_785>> cir) {
		if (data.hasCustomGeometry()) cir.setReturnValue(java.util.Collections.emptyList());
	}

}