package io.github.vampirestudios.vampirelib.mixins.client;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_756;
import net.minecraft.class_763;
import net.minecraft.class_809;
import net.minecraft.class_918;
import io.github.vampirestudios.vampirelib.api.Matrix3fExtensions;
import io.github.vampirestudios.vampirelib.api.Matrix4fExtensions;
import io.github.vampirestudios.vampirelib.client.render.LayeredBakedModel;
import io.github.vampirestudios.vampirelib.client.render.TransformTypeDependentItemBakedModel;

@Environment(EnvType.CLIENT)
@Mixin(value = class_918.class, priority = 10000)
public abstract class ItemRendererMixin {
	@Shadow
	@Final
	private class_763 itemModelShaper;

	@Shadow
	public static class_4588 getCompassFoilBufferDirect(class_4597 buffer, class_1921 renderType, class_4587.class_4665 matrixEntry) {
		return null;
	}

	@Shadow
	public static class_4588 getCompassFoilBuffer(class_4597 buffer, class_1921 renderType, class_4587.class_4665 matrixEntry) {
		return null;
	}

	@Shadow
	public static class_4588 getFoilBufferDirect(class_4597 buffer, class_1921 renderType, boolean noEntity, boolean withGlint) {
		return null;
	}

	@Shadow
	public static class_4588 getFoilBuffer(class_4597 buffer, class_1921 renderType, boolean isItem, boolean glint) {
		return null;
	}

	@Shadow
	protected abstract void renderModelLists(class_1087 model, class_1799 stack, int combinedLight, int combinedOverlay, class_4587 matrixStack, class_4588 buffer);

	@Shadow
	@Final
	private class_756 blockEntityRenderer;

	private static final class_1159 flipX;
	private static final class_4581 flipXNormal;
	static {
		flipX = class_1159.method_24019(-1,1,1);
		flipXNormal = new class_4581(flipX);
	}

	// FIXME CANVAS COMPAT
	@ModifyVariable(method = "render", at = @At("HEAD"), argsOnly = true)
	private class_1087 vl$handleModel(class_1087 model, class_1799 itemStack, class_809.class_811 transformType, boolean leftHand, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model1) {
		if (model instanceof TransformTypeDependentItemBakedModel handler) {
			class_4587 stack = new class_4587();
			class_1087 bakedModel = handler.handlePerspective(transformType, stack);
			if (!stack.method_22911())
			{
				// Apply the transformation to the real matrix stack, flipping for left hand
				class_1159 tMat = stack.method_23760().method_23761();
				class_4581 nMat = stack.method_23760().method_23762();
				if (leftHand)
				{
					((Matrix4fExtensions)(Object)tMat).multiplyBackward(flipX);
					tMat.method_22672(flipX);
					((Matrix3fExtensions)(Object)nMat).multiplyBackward(flipXNormal);
					nMat.method_22855(flipXNormal);
				}
				matrixStack.method_23760().method_23761().method_22672(tMat);
				matrixStack.method_23760().method_23762().method_22855(nMat);
			}
			return bakedModel;
		}
		return model;
	}

	@Unique
	private void drawItemLayered(LayeredBakedModel modelIn, class_1799 itemStackIn, class_4587 matrixStackIn,
								 class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, boolean fabulous) {
		for(com.mojang.datafixers.util.Pair<class_1087,class_1921> layerModel : modelIn.getLayerModels(itemStackIn, fabulous))
		{
			class_1087 layer = layerModel.getFirst();
			class_1921 rendertype = layerModel.getSecond();
//			net.minecraftforge.client.ForgeHooksClient.setRenderType(rendertype); // neded for compatibility with MultiLayerModels
			class_4588 ivertexbuilder;
			if (fabulous)
			{
				ivertexbuilder = class_918.method_29711(bufferIn, rendertype, true, itemStackIn.method_7958());
			} else {
				ivertexbuilder = class_918.method_23181(bufferIn, rendertype, true, itemStackIn.method_7958());
			}
			this.renderModelLists(layer, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
		}
//		net.minecraftforge.client.ForgeHooksClient.setRenderType(null);
	}

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/block/model/ItemTransform;apply(ZLcom/mojang/blaze3d/vertex/PoseStack;)V", shift = At.Shift.BEFORE), cancellable = true)
	public void vl$layeredItemModel(class_1799 itemStack, class_809.class_811 transformType, boolean leftHand, class_4587 matrixStack, class_4597 buffer, int combinedLight, int combinedOverlay, class_1087 model, CallbackInfo ci) {

	}
}