package io.github.vampirestudios.vampirelib.mixins.client;

import net.minecraft.class_281;
import net.minecraft.class_2960;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5944.class)
public class ShaderInstanceMixin {

    @Shadow
    @Final
    private String name;

    @Unique
    private static String captureLocation;
    @Unique
    private static class_281.class_282 captureType;

    @ModifyVariable(method = "<init>", at = @At(value = "NEW", target = "net/minecraft/resources/ResourceLocation", ordinal = 0, shift = At.Shift.BEFORE), index = 2, argsOnly = true)
    public String modifyLocationString(String value) {
        return "";
    }

    @ModifyVariable(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/packs/resources/ResourceProvider;openAsReader(Lnet/minecraft/resources/ResourceLocation;)Ljava/io/BufferedReader;", shift = At.Shift.BEFORE), index = 4)
    public class_2960 modifyLocation(class_2960 location) {
        class_2960 id = new class_2960(this.name);
        return new class_2960(id.method_12836(), "shaders/core/" + id.method_12832() + ".json");
    }

    @Inject(method = "getOrCreate", at = @At("HEAD"))
    private static void captureGetOrCreate(class_5912 resourceProvider, class_281.class_282 type, String string, CallbackInfoReturnable<class_281> cir) {
        captureLocation = string;
        captureType = type;
    }

    @Inject(method = "getOrCreate", at = @At("TAIL"))
    private static void deleteGetOrCreate(class_5912 resourceProvider, class_281.class_282 type, String string, CallbackInfoReturnable<class_281> cir) {
        captureLocation = null;
        captureType = null;
    }

    @ModifyVariable(method = "getOrCreate", at = @At(value = "NEW", target = "net/minecraft/resources/ResourceLocation", ordinal = 0, shift = At.Shift.BEFORE), ordinal = 1)
    private static String modifyStaticLocation(String value) {
        class_2960 id = new class_2960(captureLocation);
        return id.method_12836() + ":shaders/core/" + id.method_12832() + captureType.method_1284();
    }
}