package io.github.vampirestudios.vampirelib.mixins.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.stream.Stream;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.fabric.impl.client.texture.FabricSprite;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import io.github.vampirestudios.vampirelib.VampireLib;
import io.github.vampirestudios.vampirelib.callbacks.client.TextureStitchCallback;

@Mixin(class_1059.class)
public class TextureAtlasMixin {
	private static final int vl_EMISSIVE_ALPHA = 254 << 24;

	@Inject(method = "load(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Info;IIIII)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", at = @At("HEAD"), cancellable = true)
	private void vl_loadSprites(class_3300 container, class_1058.class_4727 info, int atlasWidth, int atlasHeight, int maxLevel, int x, int y, CallbackInfoReturnable<class_1058> cir) {
		if (!FabricLoader.getInstance().isModLoaded("optifabric") && !FabricLoader.getInstance().isModLoaded("bclib")) {
			class_2960 location = info.method_24121();
			class_2960 emissiveLocation = new class_2960(location.method_12836(), "textures/" + location.method_12832() + "_e.png");
			if (container.method_14486(emissiveLocation).isPresent()) {
				class_1011 sprite = null;
				class_1011 emission = null;
				try {
					class_2960 spriteLocation = new class_2960(location.method_12836(), "textures/" + location.method_12832() + ".png");
					InputStream resource = container.open(spriteLocation);
					sprite = class_1011.method_4309(resource);

					resource = container.open(emissiveLocation);
					emission = class_1011.method_4309(resource);
				} catch (IOException e) {
					VampireLib.INSTANCE.getLogger().info(e.getMessage());
				}
				if (sprite != null && emission != null) {
					int width = Math.min(sprite.method_4307(), emission.method_4307());
					int height = Math.min(sprite.method_4323(), emission.method_4323());
					for (int posX = 0; posX < width; posX++) {
						for (int posY = 0; posY < height; posY++) {
							int argb = emission.method_4315(posX, posY);
							int alpha = (argb >> 24) & 255;
							if (alpha > 127) {
								int r = (argb >> 16) & 255;
								int g = (argb >> 8) & 255;
								int b = argb & 255;
								if (r > 0 || g > 0 || b > 0) {
									argb = (argb & 0x00FFFFFF) | vl_EMISSIVE_ALPHA;
									sprite.method_4305(posX, posY, argb);
								}
							}
						}
					}
					class_1059 self = (class_1059) (Object) this;
					FabricSprite result = new FabricSprite(self, info, maxLevel, atlasWidth, atlasHeight, x, y, sprite);
					cir.setReturnValue(result);
				}
			}
		}
	}

	@Inject(method = "prepareToStitch",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", ordinal = 0,
			shift = At.Shift.AFTER), locals = LocalCapture.CAPTURE_FAILHARD)
	private void vl$preStitch(class_3300 resourceManager, Stream<class_2960> stream, class_3695 profilerFiller, int i, CallbackInfoReturnable<class_1059.class_4007> cir, Set<class_2960> set) {
		TextureStitchCallback.PRE.invoker().stitch((class_1059) (Object) this, set::add);
	}

	@Inject(method = "reload", at = @At("RETURN"))
	private void vl$postStitch(class_1059.class_4007 preparations, CallbackInfo ci) {
		TextureStitchCallback.POST.invoker().stitch((class_1059) (Object) this);
	}
}
