/*
 *  GNU GENERAL PUBLIC LICENSE
 *                        Version 3, 29 June 2007
 *
 *  Copyright (C) 2021 Vampire Studios
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *                             Preamble
 *
 *   The GNU General Public License is a free, copyleft license for
 * software and other kinds of works.
 *
 *   The licenses for most software and other practical works are designed
 * to take away your freedom to share and change the works.  By contrast,
 * the GNU General Public License is intended to guarantee your freedom to
 * share and change all versions of a program--to make sure it remains free
 * software for all its users.  We, the Free Software Foundation, use the
 * GNU General Public License for most of our software; it applies also to
 * any other work released this way by its authors.  You can apply it to
 * your programs, too.
 *
 *   When we speak of free software, we are referring to freedom, not
 * price.  Our General Public Licenses are designed to make sure that you
 * have the freedom to distribute copies of free software (and charge for
 * them if you wish), that you receive source code or can get it if you
 * want it, that you can change the software or use pieces of it in new
 * free programs, and that you know you can do these things.
 *
 *   To protect your rights, we need to prevent others from denying you
 * these rights or asking you to surrender the rights.  Therefore, you have
 * certain responsibilities if you distribute copies of the software, or if
 * you modify it: responsibilities to respect the freedom of others.
 *
 *   For example, if you distribute copies of such a program, whether
 * gratis or for a fee, you must pass on to the recipients the same
 * freedoms that you received.  You must make sure that they, too, receive
 * or can get the source code.  And you must show them these terms so they
 * know their rights.
 *
 *   Developers that use the GNU GPL protect your rights with two steps:
 * (1) assert copyright on the software, and (2) offer you this License
 * giving you legal permission to copy, distribute and/or modify it.
 *
 *   For the developers' and authors' protection, the GPL clearly explains
 * that there is no warranty for this free software.  For both users' and
 * authors' sake, the GPL requires that modified versions be marked as
 * changed, so that their problems will not be attributed erroneously to
 * authors of previous versions.
 *
 *   Some devices are designed to deny users access to install or run
 * modified versions of the software inside them, although the manufacturer
 * can do so.  This is fundamentally incompatible with the aim of
 * protecting users' freedom to change the software.  The systematic
 * pattern of such abuse occurs in the area of products for individuals to
 * use, which is precisely where it is most unacceptable.  Therefore, we
 * have designed this version of the GPL to prohibit the practice for those
 * products.  If such problems arise substantially in other domains, we
 * stand ready to extend this provision to those domains in future versions
 * of the GPL, as needed to protect the freedom of users.
 *
 *   Finally, every program is threatened constantly by software patents.
 * States should not allow patents to restrict development and use of
 * software on general-purpose computers, but in those that do, we wish to
 * avoid the special danger that patents applied to a free program could
 * make it effectively proprietary.  To prevent this, the GPL assures that
 * patents cannot be used to render the program non-free.
 *
 *   The precise terms and conditions for copying, distribution and
 * modification follow.
 *
 *                        TERMS AND CONDITIONS
 *
 *   0. Definitions.
 *
 *   "This License" refers to version 3 of the GNU General Public License.
 *
 *   "Copyright" also means copyright-like laws that apply to other kinds of
 * works, such as semiconductor masks.
 *
 *   "The Program" refers to any copyrightable work licensed under this
 * License.  Each licensee is addressed as "you".  "Licensees" and
 * "recipients" may be individuals or organizations.
 *
 *   To "modify" a work means to copy from or adapt all or part of the work
 * in a fashion requiring copyright permission, other than the making of an
 * exact copy.  The resulting work is called a "modified version" of the
 * earlier work or a work "based on" the earlier work.
 *
 *   A "covered work" means either the unmodified Program or a work based
 * on the Program.
 *
 *   To "propagate" a work means to do anything with it that, without
 * permission, would make you directly or secondarily liable for
 * infringement under applicable copyright law, except executing it on a
 * computer or modifying a private copy.  Propagation includes copying,
 * distribution (with or without modification), making available to the
 * public, and in some countries other activities as well.
 *
 *   To "convey" a work means any kind of propagation that enables other
 * parties to make or receive copies.  Mere interaction with a user through
 * a computer network, with no transfer of a copy, is not conveying.
 *
 *   An interactive user interface displays "Appropriate Legal Notices"
 * to the extent that it includes a convenient and prominently visible
 * feature that (1) displays an appropriate copyright notice, and (2)
 * tells the user that there is no warranty for the work (except to the
 * extent that warranties are provided), that licensees may convey the
 * work under this License, and how to view a copy of this License.  If
 * the interface presents a list of user commands or options, such as a
 * menu, a prominent item in the list meets this criterion.
 *
 *   1. Source Code.
 *
 *   The "source code" for a work means the preferred form of the work
 * for making modifications to it.  "Object code" means any non-source
 * form of a work.
 *
 *   A "Standard Interface" means an interface that either is an official
 * standard defined by a recognized standards body, or, in the case of
 * interfaces specified for a particular programming language, one that
 * is widely used among developers working in that language.
 *
 *   The "System Libraries" of an executable work include anything, other
 * than the work as a whole, that (a) is included in the normal form of
 * packaging a Major Component, but which is not part of that Major
 * Component, and (b) serves only to enable use of the work with that
 * Major Component, or to implement a Standard Interface for which an
 * implementation is available to the public in source code form.  A
 * "Major Component", in this context, means a major essential component
 * (kernel, window system, and so on) of the specific operating system
 * (if any) on which the executable work runs, or a compiler used to
 * produce the work, or an object code interpreter used to run it.
 *
 *   The "Corresponding Source" for a work in object code form means all
 * the source code needed to generate, install, and (for an executable
 * work) run the object code and to modify the work, including scripts to
 * control those activities.  However, it does not include the work's
 * System Libraries, or general-purpose tools or generally available free
 * programs which are used unmodified in performing those activities but
 * which are not part of the work.  For example, Corresponding Source
 * includes interface definition files associated with source files for
 * the work, and the source code for shared libraries and dynamically
 * linked subprograms that the work is specifically designed to require,
 * such as by intimate data communication or control flow between those
 * subprograms and other parts of the work.
 *
 *   The Corresponding Source need not include anything that users
 * can regenerate automatically from other parts of the Corresponding
 * Source.
 *
 *   The Corresponding Source for a work in source code form is that
 * same work.
 *
 *   2. Basic Permissions.
 *
 *   All rights granted under this License are granted for the term of
 * copyright on the Program, and are irrevocable provided the stated
 * conditions are met.  This License explicitly affirms your unlimited
 * permission to run the unmodified Program.  The output from running a
 * covered work is covered by this License only if the output, given its
 * content, constitutes a covered work.  This License acknowledges your
 * rights of fair use or other equivalent, as provided by copyright law.
 *
 *   You may make, run and propagate covered works that you do not
 * convey, without conditions so long as your license otherwise remains
 * in force.  You may convey covered works to others for the sole purpose
 * of having them make modifications exclusively for you, or provide you
 * with facilities for running those works, provided that you comply with
 * the terms of this License in conveying all material for which you do
 * not control copyright.  Those thus making or running the covered works
 * for you must do so exclusively on your behalf, under your direction
 * and control, on terms that prohibit them from making any copies of
 * your copyrighted material outside their relationship with you.
 *
 *   Conveying under any other circumstances is permitted solely under
 * the conditions stated below.  Sublicensing is not allowed; section 10
 * makes it unnecessary.
 *
 *   3. Protecting Users' Legal Rights From Anti-Circumvention Law.
 *
 *   No covered work shall be deemed part of an effective technological
 * measure under any applicable law fulfilling obligations under article
 * 11 of the WIPO copyright treaty adopted on 20 December 1996, or
 * similar laws prohibiting or restricting circumvention of such
 * measures.
 *
 *   When you convey a covered work, you waive any legal power to forbid
 * circumvention of technological measures to the extent such circumvention
 * is effected by exercising rights under this License with respect to
 * the covered work, and you disclaim any intention to limit operation or
 * modification of the work as a means of enforcing, against the work's
 * users, your or third parties' legal rights to forbid circumvention of
 * technological measures.
 *
 *   4. Conveying Verbatim Copies.
 *
 *   You may convey verbatim copies of the Program's source code as you
 * receive it, in any medium, provided that you conspicuously and
 * appropriately publish on each copy an appropriate copyright notice;
 * keep intact all notices stating that this License and any
 * non-permissive terms added in accord with section 7 apply to the code;
 * keep intact all notices of the absence of any warranty; and give all
 * recipients a copy of this License along with the Program.
 *
 *   You may charge any price or no price for each copy that you convey,
 * and you may offer support or warranty protection for a fee.
 *
 *   5. Conveying Modified Source Versions.
 *
 *   You may convey a work based on the Program, or the modifications to
 * produce it from the Program, in the form of source code under the
 * terms of section 4, provided that you also meet all of these conditions:
 *
 *     a) The work must carry prominent notices stating that you modified
 *     it, and giving a relevant date.
 *
 *     b) The work must carry prominent notices stating that it is
 *     released under this License and any conditions added under section
 *     7.  This requirement modifies the requirement in section 4 to
 *     "keep intact all notices".
 *
 *     c) You must license the entire work, as a whole, under this
 *     License to anyone who comes into possession of a copy.  This
 *     License will therefore apply, along with any applicable section 7
 *     additional terms, to the whole of the work, and all its parts,
 *     regardless of how they are packaged.  This License gives no
 *     permission to license the work in any other way, but it does not
 *     invalidate such permission if you have separately received it.
 *
 *     d) If the work has interactive user interfaces, each must display
 *     Appropriate Legal Notices; however, if the Program has interactive
 *     interfaces that do not display Appropriate Legal Notices, your
 *     work need not make them do so.
 *
 *   A compilation of a covered work with other separate and independent
 * works, which are not by their nature extensions of the covered work,
 * and which are not combined with it such as to form a larger program,
 * in or on a volume of a storage or distribution medium, is called an
 * "aggregate" if the compilation and its resulting copyright are not
 * used to limit the access or legal rights of the compilation's users
 * beyond what the individual works permit.  Inclusion of a covered work
 * in an aggregate does not cause this License to apply to the other
 * parts of the aggregate.
 *
 *   6. Conveying Non-Source Forms.
 *
 *   You may convey a covered work in object code form under the terms
 * of sections 4 and 5, provided that you also convey the
 * machine-readable Corresponding Source under the terms of this License,
 * in one of these ways:
 *
 *     a) Convey the object code in, or embodied in, a physical product
 *     (including a physical distribution medium), accompanied by the
 *     Corresponding Source fixed on a durable physical medium
 *     customarily used for software interchange.
 *
 *     b) Convey the object code in, or embodied in, a physical product
 *     (including a physical distribution medium), accompanied by a
 *     written offer, valid for at least three years and valid for as
 *     long as you offer spare parts or customer support for that product
 *     model, to give anyone who possesses the object code either (1) a
 *     copy of the Corresponding Source for all the software in the
 *     product that is covered by this License, on a durable physical
 *     medium customarily used for software interchange, for a price no
 *     more than your reasonable cost of physically performing this
 *     conveying of source, or (2) access to copy the
 *     Corresponding Source from a network server at no charge.
 *
 *     c) Convey individual copies of the object code with a copy of the
 *     written offer to provide the Corresponding Source.  This
 *     alternative is allowed only occasionally and noncommercially, and
 *     only if you received the object code with such an offer, in accord
 *     with subsection 6b.
 *
 *     d) Convey the object code by offering access from a designated
 *     place (gratis or for a charge), and offer equivalent access to the
 *     Corresponding Source in the same way through the same place at no
 *     further charge.  You need not require recipients to copy the
 *     Corresponding Source along with the object code.  If the place to
 *     copy the object code is a network server, the Corresponding Source
 *     may be on a different server (operated by you or a third party)
 *     that supports equivalent copying facilities, provided you maintain
 *     clear directions next to the object code saying where to find the
 *     Corresponding Source.  Regardless of what server hosts the
 *     Corresponding Source, you remain obligated to ensure that it is
 *     available for as long as needed to satisfy these requirements.
 *
 *     e) Convey the object code using peer-to-peer transmission, provided
 *     you inform other peers where the object code and Corresponding
 *     Source of the work are being offered to the general public at no
 *     charge under subsection 6d.
 *
 *   A separable portion of the object code, whose source code is excluded
 * from the Corresponding Source as a System Library, need not be
 * included in conveying the object code work.
 *
 *   A "User Product" is either (1) a "consumer product", which means any
 * tangible personal property which is normally used for personal, family,
 * or household purposes, or (2) anything designed or sold for incorporation
 * into a dwelling.  In determining whether a product is a consumer product,
 * doubtful cases shall be resolved in favor of coverage.  For a particular
 * product received by a particular user, "normally used" refers to a
 * typical or common use of that class of product, regardless of the status
 * of the particular user or of the way in which the particular user
 * actually uses, or expects or is expected to use, the product.  A product
 * is a consumer product regardless of whether the product has substantial
 * commercial, industrial or non-consumer uses, unless such uses represent
 * the only significant mode of use of the product.
 *
 *   "Installation Information" for a User Product means any methods,
 * procedures, authorization keys, or other information required to install
 * and execute modified versions of a covered work in that User Product from
 * a modified version of its Corresponding Source.  The information must
 * suffice to ensure that the continued functioning of the modified object
 * code is in no case prevented or interfered with solely because
 * modification has been made.
 *
 *   If you convey an object code work under this section in, or with, or
 * specifically for use in, a User Product, and the conveying occurs as
 * part of a transaction in which the right of possession and use of the
 * User Product is transferred to the recipient in perpetuity or for a
 * fixed term (regardless of how the transaction is characterized), the
 * Corresponding Source conveyed under this section must be accompanied
 * by the Installation Information.  But this requirement does not apply
 * if neither you nor any third party retains the ability to install
 * modified object code on the User Product (for example, the work has
 * been installed in ROM).
 *
 *   The requirement to provide Installation Information does not include a
 * requirement to continue to provide support service, warranty, or updates
 * for a work that has been modified or installed by the recipient, or for
 * the User Product in which it has been modified or installed.  Access to a
 * network may be denied when the modification itself materially and
 * adversely affects the operation of the network or violates the rules and
 * protocols for communication across the network.
 *
 *   Corresponding Source conveyed, and Installation Information provided,
 * in accord with this section must be in a format that is publicly
 * documented (and with an implementation available to the public in
 * source code form), and must require no special password or key for
 * unpacking, reading or copying.
 *
 *   7. Additional Terms.
 *
 *   "Additional permissions" are terms that supplement the terms of this
 * License by making exceptions from one or more of its conditions.
 * Additional permissions that are applicable to the entire Program shall
 * be treated as though they were included in this License, to the extent
 * that they are valid under applicable law.  If additional permissions
 * apply only to part of the Program, that part may be used separately
 * under those permissions, but the entire Program remains governed by
 * this License without regard to the additional permissions.
 *
 *   When you convey a copy of a covered work, you may at your option
 * remove any additional permissions from that copy, or from any part of
 * it.  (Additional permissions may be written to require their own
 * removal in certain cases when you modify the work.)  You may place
 * additional permissions on material, added by you to a covered work,
 * for which you have or can give appropriate copyright permission.
 *
 *   Notwithstanding any other provision of this License, for material you
 * add to a covered work, you may (if authorized by the copyright holders of
 * that material) supplement the terms of this License with terms:
 *
 *     a) Disclaiming warranty or limiting liability differently from the
 *     terms of sections 15 and 16 of this License; or
 *
 *     b) Requiring preservation of specified reasonable legal notices or
 *     author attributions in that material or in the Appropriate Legal
 *     Notices displayed by works containing it; or
 *
 *     c) Prohibiting misrepresentation of the origin of that material, or
 *     requiring that modified versions of such material be marked in
 *     reasonable ways as different from the original version; or
 *
 *     d) Limiting the use for publicity purposes of names of licensors or
 *     authors of the material; or
 *
 *     e) Declining to grant rights under trademark law for use of some
 *     trade names, trademarks, or service marks; or
 *
 *     f) Requiring indemnification of licensors and authors of that
 *     material by anyone who conveys the material (or modified versions of
 *     it) with contractual assumptions of liability to the recipient, for
 *     any liability that these contractual assumptions directly impose on
 *     those licensors and authors.
 *
 *   All other non-permissive additional terms are considered "further
 * restrictions" within the meaning of section 10.  If the Program as you
 * received it, or any part of it, contains a notice stating that it is
 * governed by this License along with a term that is a further
 * restriction, you may remove that term.  If a license document contains
 * a further restriction but permits relicensing or conveying under this
 * License, you may add to a covered work material governed by the terms
 * of that license document, provided that the further restriction does
 * not survive such relicensing or conveying.
 *
 *   If you add terms to a covered work in accord with this section, you
 * must place, in the relevant source files, a statement of the
 * additional terms that apply to those files, or a notice indicating
 * where to find the applicable terms.
 *
 *   Additional terms, permissive or non-permissive, may be stated in the
 * form of a separately written license, or stated as exceptions;
 * the above requirements apply either way.
 *
 *   8. Termination.
 *
 *   You may not propagate or modify a covered work except as expressly
 * provided under this License.  Any attempt otherwise to propagate or
 * modify it is void, and will automatically terminate your rights under
 * this License (including any patent licenses granted under the third
 * paragraph of section 11).
 *
 *   However, if you cease all violation of this License, then your
 * license from a particular copyright holder is reinstated (a)
 * provisionally, unless and until the copyright holder explicitly and
 * finally terminates your license, and (b) permanently, if the copyright
 * holder fails to notify you of the violation by some reasonable means
 * prior to 60 days after the cessation.
 *
 *   Moreover, your license from a particular copyright holder is
 * reinstated permanently if the copyright holder notifies you of the
 * violation by some reasonable means, this is the first time you have
 * received notice of violation of this License (for any work) from that
 * copyright holder, and you cure the violation prior to 30 days after
 * your receipt of the notice.
 *
 *   Termination of your rights under this section does not terminate the
 * licenses of parties who have received copies or rights from you under
 * this License.  If your rights have been terminated and not permanently
 * reinstated, you do not qualify to receive new licenses for the same
 * material under section 10.
 *
 *   9. Acceptance Not Required for Having Copies.
 *
 *   You are not required to accept this License in order to receive or
 * run a copy of the Program.  Ancillary propagation of a covered work
 * occurring solely as a consequence of using peer-to-peer transmission
 * to receive a copy likewise does not require acceptance.  However,
 * nothing other than this License grants you permission to propagate or
 * modify any covered work.  These actions infringe copyright if you do
 * not accept this License.  Therefore, by modifying or propagating a
 * covered work, you indicate your acceptance of this License to do so.
 *
 *   10. Automatic Licensing of Downstream Recipients.
 *
 *   Each time you convey a covered work, the recipient automatically
 * receives a license from the original licensors, to run, modify and
 * propagate that work, subject to this License.  You are not responsible
 * for enforcing compliance by third parties with this License.
 *
 *   An "entity transaction" is a transaction transferring control of an
 * organization, or substantially all assets of one, or subdividing an
 * organization, or merging organizations.  If propagation of a covered
 * work results from an entity transaction, each party to that
 * transaction who receives a copy of the work also receives whatever
 * licenses to the work the party's predecessor in interest had or could
 * give under the previous paragraph, plus a right to possession of the
 * Corresponding Source of the work from the predecessor in interest, if
 * the predecessor has it or can get it with reasonable efforts.
 *
 *   You may not impose any further restrictions on the exercise of the
 * rights granted or affirmed under this License.  For example, you may
 * not impose a license fee, royalty, or other charge for exercise of
 * rights granted under this License, and you may not initiate litigation
 * (including a cross-claim or counterclaim in a lawsuit) alleging that
 * any patent claim is infringed by making, using, selling, offering for
 * sale, or importing the Program or any portion of it.
 *
 *   11. Patents.
 *
 *   A "contributor" is a copyright holder who authorizes use under this
 * License of the Program or a work on which the Program is based.  The
 * work thus licensed is called the contributor's "contributor version".
 *
 *   A contributor's "essential patent claims" are all patent claims
 * owned or controlled by the contributor, whether already acquired or
 * hereafter acquired, that would be infringed by some manner, permitted
 * by this License, of making, using, or selling its contributor version,
 * but do not include claims that would be infringed only as a
 * consequence of further modification of the contributor version.  For
 * purposes of this definition, "control" includes the right to grant
 * patent sublicenses in a manner consistent with the requirements of
 * this License.
 *
 *   Each contributor grants you a non-exclusive, worldwide, royalty-free
 * patent license under the contributor's essential patent claims, to
 * make, use, sell, offer for sale, import and otherwise run, modify and
 * propagate the contents of its contributor version.
 *
 *   In the following three paragraphs, a "patent license" is any express
 * agreement or commitment, however denominated, not to enforce a patent
 * (such as an express permission to practice a patent or covenant not to
 * sue for patent infringement).  To "grant" such a patent license to a
 * party means to make such an agreement or commitment not to enforce a
 * patent against the party.
 *
 *   If you convey a covered work, knowingly relying on a patent license,
 * and the Corresponding Source of the work is not available for anyone
 * to copy, free of charge and under the terms of this License, through a
 * publicly available network server or other readily accessible means,
 * then you must either (1) cause the Corresponding Source to be so
 * available, or (2) arrange to deprive yourself of the benefit of the
 * patent license for this particular work, or (3) arrange, in a manner
 * consistent with the requirements of this License, to extend the patent
 * license to downstream recipients.  "Knowingly relying" means you have
 * actual knowledge that, but for the patent license, your conveying the
 * covered work in a country, or your recipient's use of the covered work
 * in a country, would infringe one or more identifiable patents in that
 * country that you have reason to believe are valid.
 *
 *   If, pursuant to or in connection with a single transaction or
 * arrangement, you convey, or propagate by procuring conveyance of, a
 * covered work, and grant a patent license to some of the parties
 * receiving the covered work authorizing them to use, propagate, modify
 * or convey a specific copy of the covered work, then the patent license
 * you grant is automatically extended to all recipients of the covered
 * work and works based on it.
 *
 *   A patent license is "discriminatory" if it does not include within
 * the scope of its coverage, prohibits the exercise of, or is
 * conditioned on the non-exercise of one or more of the rights that are
 * specifically granted under this License.  You may not convey a covered
 * work if you are a party to an arrangement with a third party that is
 * in the business of distributing software, under which you make payment
 * to the third party based on the extent of your activity of conveying
 * the work, and under which the third party grants, to any of the
 * parties who would receive the covered work from you, a discriminatory
 * patent license (a) in connection with copies of the covered work
 * conveyed by you (or copies made from those copies), or (b) primarily
 * for and in connection with specific products or compilations that
 * contain the covered work, unless you entered into that arrangement,
 * or that patent license was granted, prior to 28 March 2007.
 *
 *   Nothing in this License shall be construed as excluding or limiting
 * any implied license or other defenses to infringement that may
 * otherwise be available to you under applicable patent law.
 *
 *   12. No Surrender of Others' Freedom.
 *
 *   If conditions are imposed on you (whether by court order, agreement or
 * otherwise) that contradict the conditions of this License, they do not
 * excuse you from the conditions of this License.  If you cannot convey a
 * covered work so as to satisfy simultaneously your obligations under this
 * License and any other pertinent obligations, then as a consequence you may
 * not convey it at all.  For example, if you agree to terms that obligate you
 * to collect a royalty for further conveying from those to whom you convey
 * the Program, the only way you could satisfy both those terms and this
 * License would be to refrain entirely from conveying the Program.
 *
 *   13. Use with the GNU Affero General Public License.
 *
 *   Notwithstanding any other provision of this License, you have
 * permission to link or combine any covered work with a work licensed
 * under version 3 of the GNU Affero General Public License into a single
 * combined work, and to convey the resulting work.  The terms of this
 * License will continue to apply to the part which is the covered work,
 * but the special requirements of the GNU Affero General Public License,
 * section 13, concerning interaction through a network will apply to the
 * combination as such.
 *
 *   14. Revised Versions of this License.
 *
 *   The Free Software Foundation may publish revised and/or new versions of
 * the GNU General Public License from time to time.  Such new versions will
 * be similar in spirit to the present version, but may differ in detail to
 * address new problems or concerns.
 *
 *   Each version is given a distinguishing version number.  If the
 * Program specifies that a certain numbered version of the GNU General
 * Public License "or any later version" applies to it, you have the
 * option of following the terms and conditions either of that numbered
 * version or of any later version published by the Free Software
 * Foundation.  If the Program does not specify a version number of the
 * GNU General Public License, you may choose any version ever published
 * by the Free Software Foundation.
 *
 *   If the Program specifies that a proxy can decide which future
 * versions of the GNU General Public License can be used, that proxy's
 * public statement of acceptance of a version permanently authorizes you
 * to choose that version for the Program.
 *
 *   Later license versions may give you additional or different
 * permissions.  However, no additional obligations are imposed on any
 * author or copyright holder as a result of your choosing to follow a
 * later version.
 *
 *   15. Disclaimer of Warranty.
 *
 *   THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY
 * APPLICABLE LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 * HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY
 * OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
 * IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
 * ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
 *
 *   16. Limitation of Liability.
 *
 *   IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
 * WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES AND/OR CONVEYS
 * THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY
 * GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE
 * USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 * DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD
 * PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),
 * EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 *
 *   17. Interpretation of Sections 15 and 16.
 *
 *   If the disclaimer of warranty and limitation of liability provided
 * above cannot be given local legal effect according to their terms,
 * reviewing courts shall apply local law that most closely approximates
 * an absolute waiver of all civil liability in connection with the
 * Program, unless a warranty or assumption of liability accompanies a
 * copy of the Program in return for a fee.
 *
 *                      END OF TERMS AND CONDITIONS
 *
 *             How to Apply These Terms to Your New Programs
 *
 *   If you develop a new program, and you want it to be of the greatest
 * possible use to the public, the best way to achieve this is to make it
 * free software which everyone can redistribute and change under these terms.
 *
 *   To do so, attach the following notices to the program.  It is safest
 * to attach them to the start of each source file to most effectively
 * state the exclusion of warranty; and each file should have at least
 * the "copyright" line and a pointer to where the full notice is found.
 *
 *     <one line to give the program's name and a brief idea of what it does.>
 *     Copyright (C) <year>  <name of author>
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Also add information on how to contact you by electronic and paper mail.
 *
 *   If the program does terminal interaction, make it output a short
 * notice like this when it starts in an interactive mode:
 *
 *     <program>  Copyright (C) <year>  <name of author>
 *     This program comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
 *     This is free software, and you are welcome to redistribute it
 *     under certain conditions; type `show c' for details.
 *
 * The hypothetical commands `show w' and `show c' should show the appropriate
 * parts of the General Public License.  Of course, your program's commands
 * might be different; for a GUI interface, you would use an "about box".
 *
 *   You should also get your employer (if you work as a programmer) or school,
 * if any, to sign a "copyright disclaimer" for the program, if necessary.
 * For more information on this, and how to apply and follow the GNU GPL, see
 * <https://www.gnu.org/licenses/>.
 *
 *   The GNU General Public License does not permit incorporating your program
 * into proprietary programs.  If your program is a subroutine library, you
 * may consider it more useful to permit linking proprietary applications with
 * the library.  If this is what you want to do, use the GNU Lesser General
 * Public License instead of this License.  But first, please read
 * <https://www.gnu.org/licenses/why-not-lgpl.html>.
 */

package io.github.vampirestudios.vampirelib.utils.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import com.terraformersmc.terraform.boat.api.TerraformBoatTypeRegistry;
import com.terraformersmc.terraform.boat.api.client.TerraformBoatClientHelper;
import com.terraformersmc.terraform.boat.api.item.TerraformBoatItemHelper;
import com.terraformersmc.terraform.sign.block.TerraformWallSignBlock;
import org.apache.commons.lang3.text.WordUtils;
import record;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.fabric.impl.blockrenderlayer.BlockRenderLayerMapImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1822;
import net.minecraft.class_1856;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2430;
import net.minecraft.class_2440;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2591;
import net.minecraft.class_2647;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3962;
import net.minecraft.class_44;
import net.minecraft.class_4780;
import net.minecraft.class_4910;
import net.minecraft.class_4910.class_4914;
import net.minecraft.class_4925;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import io.github.vampirestudios.vampirelib.api.CustomTagProviders;
import io.github.vampirestudios.vampirelib.api.FabricLanguageProvider;
import io.github.vampirestudios.vampirelib.blocks.BaseBeehiveBlock;
import io.github.vampirestudios.vampirelib.blocks.BaseBlock;
import io.github.vampirestudios.vampirelib.blocks.BaseLogAndWoodBlock;
import io.github.vampirestudios.vampirelib.blocks.ButtonBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.CustomLadderBlock;
import io.github.vampirestudios.vampirelib.blocks.DoorBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.ExpandedTerraformSignBlock;
import io.github.vampirestudios.vampirelib.blocks.FenceBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.FenceGateBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.FlowerPotBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.FungusBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.LeafCarpetBlock;
import io.github.vampirestudios.vampirelib.blocks.LeafPileBlock;
import io.github.vampirestudios.vampirelib.blocks.LeavesBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.PressurePlateBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.SaplingBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.SlabBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.StairsBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.TrapdoorBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.WartBlockBaseBlock;
import io.github.vampirestudios.vampirelib.blocks.WaterloggedLeafCarpetBlock;
import io.github.vampirestudios.vampirelib.blocks.WaterloggedLeafPileBlock;
import io.github.vampirestudios.vampirelib.blocks.entity.IBlockEntityType;
import io.github.vampirestudios.vampirelib.client.VampireLibClient;
import io.github.vampirestudios.vampirelib.init.VTags;
import io.github.vampirestudios.vampirelib.utils.Utils;

import static net.minecraft.class_2430.method_10386;
import static net.minecraft.class_4910.method_25609;
import static net.minecraft.class_4910.method_25599;
import static net.minecraft.class_4910.method_25644;
import static net.minecraft.class_4910.method_25662;
import static net.minecraft.class_2446.method_35914;

import RegistryHelper;

public class WoodRegistry {

    private final class_2960 name;
    private final class_2647 saplingGenerator;
    private final class_2975<class_4780, ?> fungusGenerator;
    private class_2248 log;
    private class_2248 wood;
    private class_2248 strippedLog;
    private class_2248 strippedWood;
    private class_2248 stairs;
    private class_2248 slab;
    private class_2248 planks;
    private class_2248 leaves;
    private class_2248 sapling;
    private class_2248 pottedSapling;
    private class_2248 fence;
    private class_2248 fenceGate;
    private class_2248 bookshelf;
    private class_2248 door;
    private class_2248 trapdoor;
    private class_2248 button;
    private class_2248 pressurePlate;
    private class_2248 sign;
    private class_2248 wallSign;
    private class_2248 ladder;
    private class_2248 beehive;
    private class_2248 leafPile;
    private class_2248 leafCarpet;

    private class_1792 signItem;
    private class_1792 boatItem;
    private class_1792 chestBoatItem;
    private TerraformBoatType boatType;

    public class_6862<class_2248> logsTag;
    public class_6862<class_1792> logsItemTag;

    private boolean flammable = true;
    private boolean mushroomLike = false;

	private final List<String> availableLeaves = new ArrayList<>();
	private final List<String> availableSaplings = new ArrayList<>();
	private final List<String> availablePottedSaplings = new ArrayList<>();
    private final List<String> availableLeafPiles = new ArrayList<>();
    private final List<String> availableLeafCarpets = new ArrayList<>();

    private WoodRegistry(class_2960 name) {
        this(name, null, null);
    }

    private WoodRegistry(class_2960 name, class_2647 saplingGenerator) {
        this(name, saplingGenerator, null);
    }

    private WoodRegistry(class_2960 name, class_2975<class_4780, ?> fungusGenerator) {
        this(name, null, fungusGenerator);
    }

    private WoodRegistry(class_2960 name, class_2647 saplingGenerator, class_2975<class_4780, ?> fungusGenerator) {
        this.name = name;
        this.saplingGenerator = saplingGenerator;
        this.fungusGenerator = fungusGenerator;
        if (log != null) this.logsTag = class_6862.method_40092(class_2378.field_25105, Utils.appendToPath(name, "_logs"));
        if (log != null) this.logsItemTag = class_6862.method_40092(class_2378.field_25108, Utils.appendToPath(name, "_logs"));
    }

    public static WoodRegistry.Builder of(class_2960 name) {
        return new WoodRegistry.Builder().of(name);
    }

    public static WoodRegistry.Builder of(class_2960 name, class_2248 planks) {
        return new WoodRegistry.Builder().of(name, planks);
    }

    public static WoodRegistry.Builder of(class_2960 name, class_2647 saplingGenerator) {
        return new WoodRegistry.Builder().of(name, saplingGenerator);
    }

    public static WoodRegistry.Builder of(class_2960 name, class_2975<class_4780, ?> fungusGenerator) {
        return new WoodRegistry.Builder().of(name, fungusGenerator);
    }

	public class_2960 name() {
		return name;
	}

	public List<String> availableLeaves() {
		return availableLeaves;
	}

	public List<String> availableSaplings() {
		return availableSaplings;
	}

	public class_2248 log() {
        return log;
    }

    public class_2248 wood() {
        return wood;
    }

    public class_2248 strippedLog() {
        return strippedLog;
    }

    public class_2248 strippedWood() {
        return strippedWood;
    }

    public class_2248 stairs() {
        return stairs;
    }

    public class_2248 slab() {
        return slab;
    }

    public class_2248 planks() {
        return planks;
    }

    public class_2248 leaves() {
        return leaves;
    }

    public class_2248 sapling() {
        return sapling;
    }

    public class_2248 pottedSapling() {
        return pottedSapling;
    }

    public class_2248 fence() {
        return fence;
    }

    public class_2248 fenceGate() {
        return fenceGate;
    }

    public class_2248 bookshelf() {
        return bookshelf;
    }

    public class_2248 door() {
        return door;
    }

    public class_2248 trapdoor() {
        return trapdoor;
    }

    public class_2248 button() {
        return button;
    }

    public class_2248 pressurePlate() {
        return pressurePlate;
    }

    public class_2248 ladder() {
        return ladder;
    }

    public class_2248 beehive() {
        return beehive;
    }

    public class_2248 leafPile() {
        return leafPile;
    }

    public class_2248 leafCarpet() {
        return leafCarpet;
    }

    public class_2248 sign() {
        return sign;
    }

    public class_2248 wallSign() {
        return wallSign;
    }

    public class_2647 saplingGenerator() {
        return saplingGenerator;
    }

    public class_2975<class_4780, ?> fungusGenerator() {
        return fungusGenerator;
    }

    public class_6862<class_2248> logsTag() {
        return logsTag;
    }

    public class_6862<class_1792> logsItemTag() {
        return logsItemTag;
    }

    public class_1792 signItem() {
        return signItem;
    }

    public class_1792 boatItem() {
        return boatItem;
    }

    public class_1792 chestBoatItem() {
        return chestBoatItem;
    }

    public void generateBlockTags(CustomTagProviders.CustomBlockTagProvider blockTags) {
        if (log != null) blockTags.tagCustom(logsTag).method_26793(log);
        if (strippedLog != null) blockTags.tagCustom(logsTag).method_26793(strippedLog);
        if (wood != null) blockTags.tagCustom(logsTag).method_26793(wood);
        if (strippedWood != null) blockTags.tagCustom(logsTag).method_26793(strippedWood);

        if (logsTag != null) blockTags.tagCustom(class_3481.field_15475).method_26792(logsTag);

        if (planks != null) blockTags.tagCustom(class_3481.field_15471).method_26793(planks);
		if (!availableLeaves.isEmpty() && !mushroomLike) {
			availableLeaves.forEach(s -> {
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				blockTags.tagCustom(class_3481.field_15503).method_26793(block);
			});
		}
		if (!availableLeaves.isEmpty() && mushroomLike) {
			availableLeaves.forEach(s -> {
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				blockTags.tagCustom(class_3481.field_21954).method_26793(block);
			});
		}
        if (leaves != null && !mushroomLike) blockTags.tagCustom(class_3481.field_15503).method_26793(leaves);
        if (leaves != null && mushroomLike) blockTags.tagCustom(class_3481.field_21954).method_26793(leaves);
        if (ladder != null) blockTags.tagCustom(class_3481.field_22414).method_26793(ladder);
        if (trapdoor != null) blockTags.tagCustom(class_3481.field_15491).method_26793(trapdoor);
        if (button != null) blockTags.tagCustom(class_3481.field_15499).method_26793(button);
        if (door != null) blockTags.tagCustom(class_3481.field_15494).method_26793(door);
        if (sapling != null) blockTags.tagCustom(class_3481.field_15462).method_26793(sapling);
        if (sign != null) blockTags.tagCustom(class_3481.field_15472).method_26793(sign);
        if (wallSign != null) blockTags.tagCustom(class_3481.field_15492).method_26793(wallSign);
		if (!availableSaplings.isEmpty()) {
			availableSaplings.forEach(s ->  {
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				blockTags.tagCustom(class_3481.field_15462).method_26793(block);
			});
		}
        if (pottedSapling != null) blockTags.tagCustom(class_3481.field_15470).method_26793(pottedSapling);
		if (!availablePottedSaplings.isEmpty()) {
			availablePottedSaplings.forEach(s ->  {
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				blockTags.tagCustom(class_3481.field_15470).method_26793(block);
			});
		}
        if (fence != null) blockTags.tagCustom(class_3481.field_17619).method_26793(fence);
        if (fenceGate != null) blockTags.tagCustom(class_3481.field_25147).method_26793(fenceGate);
        if (pressurePlate != null) blockTags.tagCustom(class_3481.field_24076).method_26793(pressurePlate);
        if (slab != null) blockTags.tagCustom(class_3481.field_15468).method_26793(slab);
        if (stairs != null) blockTags.tagCustom(class_3481.field_15502).method_26793(stairs);
        if (flammable) {
            if (logsTag != null) blockTags.tagCustom(class_3481.field_23210).method_26792(logsTag);
        } else {
			CustomTagProviders<class_2248>.CustomFabricTagBuilder<class_2248> nonFlammableWoodTag = blockTags.tagCustom(class_3481.field_23208);
            if (ladder != null) nonFlammableWoodTag.method_26793(ladder);
            if (trapdoor != null) nonFlammableWoodTag.method_26793(trapdoor);
            if (button != null) nonFlammableWoodTag.method_26793(button);
            if (door != null) nonFlammableWoodTag.method_26793(door);
            if (fence != null) nonFlammableWoodTag.method_26793(fence);
            if (fenceGate != null) nonFlammableWoodTag.method_26793(fenceGate);
            if (pressurePlate != null) nonFlammableWoodTag.method_26793(pressurePlate);
            if (slab != null) nonFlammableWoodTag.method_26793(slab);
            if (stairs != null) nonFlammableWoodTag.method_26793(stairs);
            if (bookshelf != null) nonFlammableWoodTag.method_26793(bookshelf);
        }

        if (!availableLeafCarpets.isEmpty() && mushroomLike) {
            availableLeafCarpets.forEach(s -> {
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                blockTags.tagCustom(VTags.Blocks.WART_CARPETS).method_26793(block);
            });
        }
        if (!availableLeafCarpets.isEmpty() && !mushroomLike) {
            availableLeafCarpets.forEach(s -> {
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                blockTags.tagCustom(VTags.Blocks.LEAF_CARPETS).method_26793(block);
            });
        }
        if (leafCarpet != null && mushroomLike) blockTags.method_10512(VTags.Blocks.WART_CARPETS).method_26793(leafCarpet);
        if (leafCarpet != null && !mushroomLike) blockTags.method_10512(VTags.Blocks.LEAF_CARPETS).method_26793(leafCarpet);

        if (!availableLeafPiles.isEmpty() && mushroomLike) {
            availableLeafPiles.forEach(s -> {
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                blockTags.tagCustom(VTags.Blocks.WART_PILES).method_26793(block);
            });
        }
        if (!availableLeafPiles.isEmpty() && !mushroomLike) {
            availableLeafPiles.forEach(s -> {
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                blockTags.tagCustom(VTags.Blocks.LEAF_PILES).method_26793(block);
            });
        }
        if (leafPile != null && mushroomLike) blockTags.method_10512(VTags.Blocks.WART_PILES).method_26793(leafPile);
        if (leafPile != null && !mushroomLike) blockTags.method_10512(VTags.Blocks.LEAF_PILES).method_26793(leafPile);
    }

    public void generateItemTags(CustomTagProviders.CustomItemTagProvider itemsTag) {
        if (logsTag != null && logsItemTag != null) itemsTag.copy(logsTag, logsItemTag);
        itemsTag.copy(class_3481.field_15475, class_3489.field_15539);
        itemsTag.copy(class_3481.field_23210, class_3489.field_23212);
        itemsTag.copy(class_3481.field_15471, class_3489.field_15537);
        itemsTag.copy(class_3481.field_15503, class_3489.field_15558);
        itemsTag.copy(class_3481.field_15491, class_3489.field_15550);
        itemsTag.copy(class_3481.field_15499, class_3489.field_15555);
        itemsTag.copy(class_3481.field_15494, class_3489.field_15552);
        itemsTag.copy(class_3481.field_15462, class_3489.field_15528);
        itemsTag.copy(class_3481.field_17619, class_3489.field_17620);
        itemsTag.copy(class_3481.field_15468, class_3489.field_15534);
        itemsTag.copy(class_3481.field_15502, class_3489.field_15557);
        itemsTag.copy(class_3481.field_23208, class_3489.field_23211);
        itemsTag.copy(class_3481.field_15472, class_3489.field_15533);
        if (boatItem != null) itemsTag.tagCustom(class_3489.field_15536).method_26793(boatItem);
        if (chestBoatItem != null) itemsTag.tagCustom(class_3489.field_38080).method_26793(chestBoatItem);
    }

    @Environment(EnvType.CLIENT)
    public void generateModels(class_4910 blockStateModelGenerator) {
        this.generateModels(blockStateModelGenerator, false);
    }

    @Environment(EnvType.CLIENT)
    public void generateModels(class_4910 blockStateModelGenerator, boolean customPottedTexture) {
		class_4944 logMapping = new class_4944()
			.method_25868(class_4945.field_23018, new class_2960(name.method_12836(), String.format("wood_sets/%s/%s", name.method_12832(), mushroomLike ? "stem" : "log")))
			.method_25868(class_4945.field_23013, new class_2960(name.method_12836(), String.format("wood_sets/%s/%s_top", name.method_12832(), mushroomLike ? "stem" : "log")));
		class_4944 strippedLogMapping = new class_4944()
            .method_25868(class_4945.field_23018, new class_2960(name.method_12836(), String.format("wood_sets/%s/stripped_%s", name.method_12832(), mushroomLike ? "stem" : "log")))
            .method_25868(class_4945.field_23013, new class_2960(name.method_12836(), String.format("wood_sets/%s/stripped_%s_top", name.method_12832(), mushroomLike ? "stem" : "log")));

		class_4944 leavesMapping = class_4944.method_25875(new class_2960(name.method_12836(), String.format("wood_sets/%s/%s", name.method_12832(),
            mushroomLike ? "wart_block" : "leaves")));

		class_4944 saplingMapping = class_4944.method_25880(new class_2960(name.method_12836(), String.format("wood_sets/%s/%s", name.method_12832(),
            mushroomLike ? "fungi" : "sapling")));
		class_4944 saplingPlantMapping = class_4944.method_25884(new class_2960(name.method_12836(),
            customPottedTexture ? String.format("wood_sets/%s/potted_%s", name.method_12832(), mushroomLike ? "fungi" : "sapling") :
            String.format("wood_sets/%s/%s", name.method_12832(), mushroomLike ? "fungi" : "sapling")));

		class_4944 planksMapping = class_4944.method_25875(new class_2960(name.method_12836(), String.format("wood_sets/%s/planks", name.method_12832())));

        class_4944 signMapping = class_4944.method_25875(new class_2960(name.method_12836(), String.format("wood_sets/%s/sign", name.method_12832())));

		class_4944 doorMapping = new class_4944()
			.method_25868(class_4945.field_23015, new class_2960(name.method_12836(), String.format("wood_sets/%s/door_top", name.method_12832())))
			.method_25868(class_4945.field_23014, new class_2960(name.method_12836(), String.format("wood_sets/%s/door_bottom", name.method_12832())));

		class_4944 trapdoorMapping = class_4944.method_25869(new class_2960(name.method_12836(), String.format("wood_sets/%s/trapdoor", name.method_12832())));

		class_4944 bookshelfMapping = class_4944.method_25870(
            new class_2960(name.method_12836(), String.format("wood_sets/%s/bookshelf", name.method_12832())),
			new class_2960(name.method_12836(), String.format("wood_sets/%s/planks", name.method_12832()))
        );

        if (log != null) {
            blockStateModelGenerator.new class_4914(logMapping).method_25730(log);
            blockStateModelGenerator.method_25623(log, class_4941.method_25842(log));
        }
        if (wood != null) {
            blockStateModelGenerator.new class_4914(logMapping).method_25728(wood);
            blockStateModelGenerator.method_25623(wood, class_4941.method_25842(wood));
        }
        if (strippedLog != null) {
            blockStateModelGenerator.new class_4914(strippedLogMapping).method_25730(strippedLog);
            blockStateModelGenerator.method_25623(strippedLog, class_4941.method_25842(strippedLog));
        }
        if (strippedWood != null) {
            blockStateModelGenerator.new class_4914(strippedLogMapping).method_25728(strippedWood);
            blockStateModelGenerator.method_25623(strippedWood, class_4941.method_25842(strippedWood));
        }
		if (!availableLeaves.isEmpty()) {
			availableLeaves.forEach(s ->  {
                class_4944 leaves2Mapping = class_4944.method_25875(new class_2960(name.method_12836(), String.format("wood_sets/%s/%s", name.method_12832(), s)));
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				blockStateModelGenerator.method_25622(block, class_4946.method_25918(block1 -> leaves2Mapping, mushroomLike ? class_4943.field_22972 : class_4943.field_22911));
				class_2960 resourceLocation = class_4941.method_25842(block);
				blockStateModelGenerator.method_25623(block, resourceLocation);
			});
		} else {
            if (leaves != null) {
                blockStateModelGenerator.method_25622(leaves, class_4946.method_25918(block -> leavesMapping, mushroomLike ? class_4943.field_22972 : class_4943.field_22911));
                class_2960 resourceLocation = class_4941.method_25842(leaves);
                blockStateModelGenerator.method_25623(leaves, resourceLocation);
            }
        }
        if (door != null) {
            class_2960 resourceLocation = class_4943.field_38016.method_25846(door, doorMapping, blockStateModelGenerator.field_22831);
            class_2960 resourceLocation2 = class_4943.field_38017.method_25846(door, doorMapping, blockStateModelGenerator.field_22831);
            class_2960 resourceLocation3 = class_4943.field_38020.method_25846(door, doorMapping, blockStateModelGenerator.field_22831);
            class_2960 resourceLocation4 = class_4943.field_38021.method_25846(door, doorMapping, blockStateModelGenerator.field_22831);
            class_2960 resourceLocation5 = class_4943.field_38018.method_25846(door, doorMapping, blockStateModelGenerator.field_22831);
            class_2960 resourceLocation6 = class_4943.field_38019.method_25846(door, doorMapping, blockStateModelGenerator.field_22831);
            class_2960 resourceLocation7 = class_4943.field_38022.method_25846(door, doorMapping, blockStateModelGenerator.field_22831);
            class_2960 resourceLocation8 = class_4943.field_38023.method_25846(door, doorMapping, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(method_25609(door, resourceLocation, resourceLocation2, resourceLocation5, resourceLocation6,
                resourceLocation3, resourceLocation4, resourceLocation7, resourceLocation8));
            class_4943.field_22938.method_25852(class_4941.method_25840(door.method_8389()),
                class_4944.method_25895(new class_2960(
                    name.method_12836(),
                    String.format("wood_sets/%s/door", name.method_12832())
                )), blockStateModelGenerator.field_22831);
        }
        if (trapdoor != null) {
            class_2960 resourceLocation = class_4943.field_22915.method_25846(trapdoor, trapdoorMapping, blockStateModelGenerator.field_22831);
            class_2960 resourceLocation2 = class_4943.field_22916.method_25846(trapdoor, trapdoorMapping, blockStateModelGenerator.field_22831);
            class_2960 resourceLocation3 = class_4943.field_22917.method_25846(trapdoor, trapdoorMapping, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(method_25662(trapdoor, resourceLocation, resourceLocation2, resourceLocation3));
            blockStateModelGenerator.method_25623(trapdoor, resourceLocation2);
        }
		if (planks != null) {
            blockStateModelGenerator.method_25622(planks, class_4946.method_25918(block -> planksMapping, class_4943.field_22972));
            class_2960 resourceLocation = class_4941.method_25842(planks);
            blockStateModelGenerator.method_25623(planks, resourceLocation);
        }
        if (ladder != null) {
            blockStateModelGenerator.field_22830.accept(class_4925.method_25770(ladder, net.minecraft.class_4935.method_25824()
                .method_25828(class_4936.field_22887, class_4941.method_25842(ladder))).method_25775(method_25599()));
            class_4943.field_22938.method_25852(class_4941.method_25840(ladder.method_8389()),
                class_4944.method_25895(new class_2960(
                    name.method_12836(),
                    String.format("wood_sets/%s/ladder", name.method_12832())
                )), blockStateModelGenerator.field_22831);
        }
        if (!availableSaplings.isEmpty()) {
            availableSaplings.forEach(s ->  {
                class_4944 sapling2Mapping = class_4944.method_25880(new class_2960(name.method_12836(), String.format("wood_sets/%s/%s", name.method_12832(),
                    mushroomLike ? "fungi" : "sapling")));
                class_2960 resourceLocation = class_4910.class_4913.field_22840.method_25726()
                    .method_25846(sapling, sapling2Mapping, blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(method_25644(sapling, resourceLocation));
                class_4943.field_22938.method_25852(class_4941.method_25840(sapling.method_8389()),
                    class_4944.method_25895(new class_2960(
                        name.method_12836(),
                        String.format("wood_sets/%s/%s", name.method_12832(), mushroomLike ? "fungi" : "sapling")
                    )), blockStateModelGenerator.field_22831);
            });
        } else {
            if (sapling != null) {
                class_2960 resourceLocation = class_4910.class_4913.field_22840.method_25726()
                    .method_25846(sapling, saplingMapping, blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(method_25644(sapling, resourceLocation));
                class_4943.field_22938.method_25852(class_4941.method_25840(sapling.method_8389()),
                    class_4944.method_25895(new class_2960(
                        name.method_12836(),
                        String.format("wood_sets/%s/%s", name.method_12832(), mushroomLike ? "fungi" : "sapling")
                    )), blockStateModelGenerator.field_22831);
            }
        }
        if (!availablePottedSaplings.isEmpty()) {
            availablePottedSaplings.forEach(s ->  {
                class_4944 sapling2PlantMapping = class_4944.method_25884(new class_2960(name.method_12836(),
                    customPottedTexture ? String.format("wood_sets/%s/potted_%s", name.method_12832(), mushroomLike ? "fungi" : "sapling") :
                        String.format("wood_sets/%s/%s", name.method_12832(), mushroomLike ? "fungi" : "sapling")));
                class_2960 resourceLocation = class_4910.class_4913.field_22840.method_25727().method_25846(pottedSapling, sapling2PlantMapping,
                    blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(method_25644(pottedSapling, resourceLocation));
            });
        } else {
            if (pottedSapling != null) {
                class_2960 resourceLocation = class_4910.class_4913.field_22840.method_25727().method_25846(pottedSapling, saplingPlantMapping, blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(method_25644(pottedSapling, resourceLocation));
            }
        }

        if (bookshelf != null) {
            class_2960 resourceLocation = class_4943.field_22974.method_25846(bookshelf, bookshelfMapping, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(method_25644(bookshelf, resourceLocation));
            class_2960 resourceLocationItem = class_4941.method_25842(bookshelf);
            blockStateModelGenerator.method_25623(bookshelf, resourceLocationItem);
        }
        if (fence != null) {
			class_2960 resourceLocation = class_4943.field_22988.method_25846(fence, planksMapping, blockStateModelGenerator.field_22831);
			class_2960 resourceLocation2 = class_4943.field_22989.method_25846(fence, planksMapping, blockStateModelGenerator.field_22831);
			blockStateModelGenerator.field_22830.accept(class_4910.method_25661(fence, resourceLocation, resourceLocation2));
			class_2960 resourceLocation3 = class_4943.field_22990.method_25846(fence, planksMapping, blockStateModelGenerator.field_22831);
			blockStateModelGenerator.method_25623(fence, resourceLocation3);
		}
		if (fenceGate != null) {
			class_2960 resourceLocation = class_4943.field_22996.method_25846(fenceGate, planksMapping, blockStateModelGenerator.field_22831);
			class_2960 resourceLocation2 = class_4943.field_22995.method_25846(fenceGate, planksMapping, blockStateModelGenerator.field_22831);
			class_2960 resourceLocation3 = class_4943.field_22905.method_25846(fenceGate, planksMapping, blockStateModelGenerator.field_22831);
			class_2960 resourceLocation4 = class_4943.field_22904.method_25846(fenceGate, planksMapping, blockStateModelGenerator.field_22831);
			blockStateModelGenerator.field_22830.accept(class_4910.method_25626(fenceGate, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4));
            blockStateModelGenerator.method_25623(fenceGate, resourceLocation2);
		}
		if (pressurePlate != null) {
			class_2960 resourceLocation = class_4943.field_22906.method_25846(pressurePlate, planksMapping, blockStateModelGenerator.field_22831);
			class_2960 resourceLocation2 = class_4943.field_22907.method_25846(pressurePlate, planksMapping, blockStateModelGenerator.field_22831);
			blockStateModelGenerator.field_22830.accept(class_4910.method_25673(pressurePlate, resourceLocation, resourceLocation2));
            blockStateModelGenerator.method_25623(pressurePlate, resourceLocation);
		}
		if (slab != null) {
			class_2960 resourceLocation = class_4943.field_22910.method_25846(slab, planksMapping, blockStateModelGenerator.field_22831);
			class_2960 resourceLocation2 = class_4943.field_22909.method_25846(slab, planksMapping, blockStateModelGenerator.field_22831);
			blockStateModelGenerator.field_22830.accept(class_4910.method_25668(slab, resourceLocation2, resourceLocation, class_4941.method_25842(planks)));
            blockStateModelGenerator.method_25623(slab, resourceLocation2);
		}
        if (sign != null && wallSign != null && signItem != null) {
            class_2960 resourceLocation = class_4943.field_22908.method_25846(sign, signMapping, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.field_22830.accept(class_4910.method_25644(sign, resourceLocation));
            blockStateModelGenerator.field_22830.accept(class_4910.method_25644(wallSign, resourceLocation));
            class_4943.field_22938.method_25852(class_4941.method_25840(sign.method_8389()),
                class_4944.method_25895(new class_2960(
                    name.method_12836(),
                    String.format("wood_sets/%s/sign_item", name.method_12832())
                )), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.method_25540(wallSign);
        }
        if (boatItem != null) {
            class_4943.field_22938.method_25852(class_4941.method_25840(boatItem),
                class_4944.method_25895(new class_2960(
                    name.method_12836(),
                    String.format("wood_sets/%s/boat_item", name.method_12832())
                )), blockStateModelGenerator.field_22831);
        }
        if (chestBoatItem != null) {
            class_4943.field_22938.method_25852(class_4941.method_25840(chestBoatItem),
                class_4944.method_25895(new class_2960(
                    name.method_12836(),
                    String.format("wood_sets/%s/chest_boat_item", name.method_12832())
                )), blockStateModelGenerator.field_22831);
        }
		if (stairs != null) {
			class_2960 resourceLocation = class_4943.field_22913.method_25846(stairs, planksMapping, blockStateModelGenerator.field_22831);
			class_2960 resourceLocation2 = class_4943.field_22912.method_25846(stairs, planksMapping, blockStateModelGenerator.field_22831);
			class_2960 resourceLocation3 = class_4943.field_22914.method_25846(stairs, planksMapping, blockStateModelGenerator.field_22831);
			blockStateModelGenerator.field_22830.accept(class_4910.method_25646(stairs, resourceLocation, resourceLocation2, resourceLocation3));
			blockStateModelGenerator.method_25623(stairs, resourceLocation2);
		}
		if (button != null) {
			class_2960 resourceLocation = class_4943.field_22981.method_25846(button, planksMapping, blockStateModelGenerator.field_22831);
			class_2960 resourceLocation2 = class_4943.field_22982.method_25846(button, planksMapping, blockStateModelGenerator.field_22831);
			blockStateModelGenerator.field_22830.accept(class_4910.method_25654(button, resourceLocation, resourceLocation2));
			class_2960 resourceLocation3 = class_4943.field_22983.method_25846(button, planksMapping, blockStateModelGenerator.field_22831);
			blockStateModelGenerator.method_25623(button, resourceLocation3);
		}
        if (!availableLeafCarpets.isEmpty()) {
            availableLeafCarpets.forEach(s ->  {
                class_4944 leaves2Mapping = class_4944.method_25875(new class_2960(name.method_12836(), String.format("wood_sets/%s/%s", name.method_12832(), s)));
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                class_2960 resourceLocation = new class_4942(Optional.of(new class_2960("vampirelib:block/template_leaf_carpet")),
                    Optional.empty(), class_4945.field_23010).method_25846(block, leaves2Mapping, blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(class_4910.method_25644(block, resourceLocation));
                blockStateModelGenerator.method_25623(block, resourceLocation);
            });
        } else {
            if (leafCarpet != null) {
                class_2960 resourceLocation = new class_4942(Optional.of(new class_2960("vampirelib:block/template_leaf_carpet")),
                    Optional.empty(), class_4945.field_23010).method_25846(leafCarpet, leavesMapping, blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(class_4910.method_25644(leafCarpet, resourceLocation));
                blockStateModelGenerator.method_25623(leafCarpet, resourceLocation);
            }
        }
        if (!availableLeafPiles.isEmpty()) {
            availableLeafPiles.forEach(s ->  {
                class_4944 leaves2Mapping = class_4944.method_25875(new class_2960(name.method_12836(), String.format("wood_sets/%s/%s", name.method_12832(), s)));
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                class_2960 resourceLocation = new class_4942(Optional.of(new class_2960("vampirelib:block/template_leaf_pile")),
                    Optional.empty(), class_4945.field_23010).method_25846(block, leaves2Mapping, blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(class_4910.method_25644(block, resourceLocation));
                blockStateModelGenerator.method_25623(block, resourceLocation);
            });
        } else {
            if (leafPile != null) {
                class_2960 resourceLocation = new class_4942(Optional.of(new class_2960("vampirelib:block/template_leaf_pile")),
                    Optional.empty(), class_4945.field_23010).method_25846(leafPile, leavesMapping, blockStateModelGenerator.field_22831);
                blockStateModelGenerator.field_22830.accept(class_4910.method_25644(leafPile, resourceLocation));
                blockStateModelGenerator.method_25623(leafPile, resourceLocation);
            }
        }
    }

    @Environment(EnvType.CLIENT)
    public void generateLang(FabricLanguageProvider languageProvider) {
        String translatedName = WordUtils.capitalizeFully(name.method_12832().replace("_", " "));
        if (log != null) languageProvider.addBlock(log, translatedName + (mushroomLike ? " Stem" : " Log"));
        if (strippedLog != null) languageProvider.addBlock(strippedLog, "Stripped " + translatedName + (mushroomLike ? " Stem" : " Log"));
        if (wood != null) languageProvider.addBlock(wood, translatedName + (mushroomLike ? " Hyphae" : " Wood"));
        if (strippedWood != null) languageProvider.addBlock(strippedWood, "Stripped " + translatedName + (mushroomLike ? " Hyphae" : " Wood"));
        if (planks != null) languageProvider.addBlock(planks, translatedName + " Planks");
		if (!availableSaplings.isEmpty()) {
			availableSaplings.forEach(s ->  {
				String translatedName1 = WordUtils.capitalizeFully(s.replace("_", " "));
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				languageProvider.addBlock(block, translatedName1 + (mushroomLike ? " Fungi" : " Sapling"));
			});
		} else {
            if (sapling != null) languageProvider.addBlock(sapling, translatedName + (mushroomLike ? " Fungi" : " Sapling"));
        }
		if (!availablePottedSaplings.isEmpty()) {
			availablePottedSaplings.forEach(s ->  {
				String translatedName1 = WordUtils.capitalizeFully(s.replace("_", " "));
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				languageProvider.addBlock(block, "Potted " + translatedName1 + (mushroomLike ? " Fungi" : " Sapling"));
			});
		} else {
            if (pottedSapling != null) languageProvider.addBlock(pottedSapling, "Potted " + translatedName + (mushroomLike ? " Fungi" : " Sapling"));
        }
        if (trapdoor != null) languageProvider.addBlock(trapdoor, translatedName + " Trapdoor");
        if (door != null) languageProvider.addBlock(door, translatedName + " Door");
		if (!availableLeaves.isEmpty()) {
			availableLeaves.forEach(s ->  {
				String translatedName1 = WordUtils.capitalizeFully(s.replace("_", " "));
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				languageProvider.addBlock(block, translatedName1);
			});
		} else {
            if (leaves != null) languageProvider.addBlock(leaves, translatedName + (mushroomLike ? " Wart Block" : " Leaves"));
        }
        if (fence != null) languageProvider.addBlock(fence, translatedName + " Fence");
        if (fenceGate != null) languageProvider.addBlock(fenceGate, translatedName + " Fence Gate");
        if (button != null) languageProvider.addBlock(button, translatedName + " Button");
        if (pressurePlate != null) languageProvider.addBlock(pressurePlate, translatedName + " Pressure Plate");
        if (slab != null) languageProvider.addBlock(slab, translatedName + " Slab");
        if (stairs != null) languageProvider.addBlock(stairs, translatedName + " Stairs");
        if (bookshelf != null) languageProvider.addBlock(bookshelf, translatedName + " Bookshelf");
        if (signItem != null) languageProvider.addBlock(sign, translatedName + " Sign");
        if (boatItem != null) languageProvider.addItem(boatItem, translatedName + " Boat");
        if (chestBoatItem != null) languageProvider.addItem(chestBoatItem, translatedName + " Boat with Chest");
        if (!availableLeafCarpets.isEmpty()) {
            availableLeafCarpets.forEach(s ->  {
                String translatedName1 = WordUtils.capitalizeFully(s.replace("_", " "));
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                languageProvider.addBlock(block, translatedName1);
            });
        } else {
            if (leafCarpet != null) languageProvider.addBlock(leafCarpet, translatedName + (mushroomLike ? " Wart Carpet" : " Leaf Carpet"));
        }
        if (!availableLeafPiles.isEmpty()) {
            availableLeafPiles.forEach(s ->  {
                String translatedName1 = WordUtils.capitalizeFully(s.replace("_", " "));
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                languageProvider.addBlock(block, translatedName1);
            });
        } else {
            if (leafPile != null) languageProvider.addBlock(leafPile, translatedName + (mushroomLike ? " Wart Pile" : " Leaf Pile"));
        }
    }

    public void generateLoot(FabricBlockLootTableProvider lootTablesProvider) {
        if (log != null) lootTablesProvider.method_16329(log);
        if (strippedLog != null) lootTablesProvider.method_16329(strippedLog);
        if (wood != null) lootTablesProvider.method_16329(wood);
        if (strippedWood != null) lootTablesProvider.method_16329(strippedWood);
        if (planks != null) lootTablesProvider.method_16329(planks);
		if (!availableLeaves.isEmpty() && !mushroomLike) {
			availableLeaves.forEach(s ->  {
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				if (!availableSaplings.isEmpty() && availableSaplings.contains(s.replace("_leaves", "_sapling"))) {
					class_2248 sapling = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s.replace("_leaves", "_sapling")));
					lootTablesProvider.method_16293(block, block1 -> class_2430.method_10390(block1, sapling, 0.05F, 0.0625F, 0.083333336F, 0.1F));
				} else {
					if (sapling != null) lootTablesProvider.method_16293(block, block1 -> class_2430.method_10390(block1, sapling, 0.05F, 0.0625F, 0.083333336F, 0.1F));
					else lootTablesProvider.method_16329(block);
				}
			});
		} else {
            if (leaves != null && !mushroomLike) {
                if (sapling != null) lootTablesProvider.method_16293(leaves, block1 -> class_2430.method_10390(block1, sapling, 0.05F, 0.0625F, 0.083333336F, 0.1F));
                else lootTablesProvider.method_16329(leaves);
            }
        }
		if (!availableLeaves.isEmpty() && mushroomLike) {
			availableLeaves.forEach(s ->  {
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				lootTablesProvider.method_16329(block);
			});
		} else {
            if (leaves != null && mushroomLike) lootTablesProvider.method_16329(leaves);
        }
        if (ladder != null) lootTablesProvider.method_16329(ladder);
        if (trapdoor != null) lootTablesProvider.method_16329(trapdoor);
        if (button != null) lootTablesProvider.method_16329(button);
        if (door != null) lootTablesProvider.method_16293(door, class_2430::method_24817);
        if (sapling != null) lootTablesProvider.method_16329(sapling);
		if (!availableSaplings.isEmpty()) {
			availableSaplings.forEach(s ->  {
				class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
				lootTablesProvider.method_16329(block);
			});
		}
        if (fence != null) lootTablesProvider.method_16329(fence);
        if (fenceGate != null) lootTablesProvider.method_16329(fenceGate);
        if (pressurePlate != null) lootTablesProvider.method_16329(pressurePlate);
        if (slab != null) lootTablesProvider.method_16293(slab, class_2430::method_10383);
        if (stairs != null) lootTablesProvider.method_16329(stairs);
        if (sign != null) lootTablesProvider.method_16329(sign);
        if (bookshelf != null) lootTablesProvider.method_16293(bookshelf, block -> method_10386(block, class_1802.field_8529, class_44.method_32448(3.0F)));
        if (leafCarpet != null) lootTablesProvider.method_16329(leafCarpet);
        if (!availableLeafCarpets.isEmpty()) {
            availableLeafCarpets.forEach(s ->  {
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                lootTablesProvider.method_16329(block);
            });
        }
        if (leafPile != null) lootTablesProvider.method_16329(leafPile);
        if (!availableLeafPiles.isEmpty()) {
            availableLeafPiles.forEach(s ->  {
                class_2248 block = class_2378.field_11146.method_10223(new class_2960(name.method_12836(), s));
                lootTablesProvider.method_16329(block);
            });
        }
    }

    public void generateRecipes(Consumer<class_2444> exporter) {
        if (planks != null && logsItemTag != null) class_2446.method_24477(exporter, planks, logsItemTag);
        if (wood != null && log != null) class_2446.method_24476(exporter, wood, log);
        if (strippedWood != null && strippedLog != null) class_2446.method_24476(exporter, strippedWood, strippedLog);
        if (trapdoor != null && planks != null) class_2446.method_33553(trapdoor, class_1856.method_8091(planks));
        if (door != null && planks != null) class_2446.method_33544(door, class_1856.method_8091(planks));
        if (fence != null && planks != null) class_2446.method_33546(fence, class_1856.method_8091(planks));
        if (fenceGate != null && planks != null) class_2446.method_33548(fenceGate, class_1856.method_8091(planks));
        if (slab != null && planks != null) class_2446.method_32814(exporter, slab, planks);
        if (stairs != null && planks != null) class_2446.method_32808(stairs, class_1856.method_8091(planks));
        if (pressurePlate != null && planks != null) class_2446.method_32813(exporter, pressurePlate, planks);
        if (button != null && planks != null) class_2446.method_33542(button, class_1856.method_8091(planks));
        if (boatItem != null && planks != null) class_2446.method_24478(exporter, boatItem, planks);
        if (chestBoatItem != null && boatItem != null) class_2450.method_10447(chestBoatItem)
            .method_10454(class_2246.field_10034)
            .method_10454(boatItem)
            .method_10442("has_boat", method_10420(class_3489.field_15536))
            .method_10431(exporter);
        if (signItem != null && planks != null) class_2446.method_33555(signItem, class_1856.method_8091(planks));
        if (bookshelf != null && planks != null) class_2447.method_10437(bookshelf).method_10434('#', planks).method_10434('X', class_1802.field_8529).method_10439("###").method_10439("XXX").method_10439("###").method_10429("has_book", method_10426(class_1802.field_8529)).method_10431(exporter);
        if (leaves != null && leafCarpet != null) class_2447.method_10437(leafCarpet)
            .method_10439("LLL")
            .method_10434('L', leaves)
            .method_10429("has_leaves", method_10426(leaves))
            .method_10431(exporter);
        if (leaves != null && leafPile != null) class_2447.method_10437(leafPile)
            .method_10439("LL")
            .method_10434('L', leaves)
            .method_10429("has_leaves", method_10426(leaves))
            .method_10431(exporter);
    }

    public static class Builder {
        public class_2960 name;
        private WoodRegistry woodRegistry;
        private RegistryHelper registryHelper;
        private boolean preRegisteredPlanks = false;

        public Builder of(class_2960 name) {
            this.name = name;
            woodRegistry = new WoodRegistry(name);
            registryHelper = RegistryHelper.createRegistryHelper(name.method_12836());
            return this;
        }

		public Builder of(class_2960 name, class_2647 saplingGenerator) {
			this.name = name;
			woodRegistry = new WoodRegistry(name, saplingGenerator);
			registryHelper = RegistryHelper.createRegistryHelper(name.method_12836());
			return this;
		}

		public Builder of(class_2960 name, class_2975<class_4780, ?> fungusGenerator) {
			this.name = name;
			woodRegistry = new WoodRegistry(name, fungusGenerator);
			registryHelper = RegistryHelper.createRegistryHelper(name.method_12836());
			return this;
		}

        public Builder of(class_2960 name, class_2248 planks) {
            this.name = name;
            woodRegistry = new WoodRegistry(name);
            woodRegistry.planks = planks;
            preRegisteredPlanks = true;
            registryHelper = RegistryHelper.createRegistryHelper(name.method_12836());

            return this;
        }

		public Builder of(class_2960 name, class_2248 planks, class_2647 saplingGenerator) {
			this.name = name;
			woodRegistry = new WoodRegistry(name, saplingGenerator);
			woodRegistry.planks = planks;
			preRegisteredPlanks = true;
			registryHelper = RegistryHelper.createRegistryHelper(name.method_12836());

			return this;
		}

		public Builder of(class_2960 name, class_2248 planks, class_2975<class_4780, ?> fungusGenerator) {
			this.name = name;
			woodRegistry = new WoodRegistry(name, fungusGenerator);
			woodRegistry.planks = planks;
			preRegisteredPlanks = true;
			registryHelper = RegistryHelper.createRegistryHelper(name.method_12836());

			return this;
		}

        public Builder log() {
            String logName = woodRegistry.mushroomLike ? name.method_12832() + "_stem" : this.name.method_12832() + "_log";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22111 : class_2246.field_10010;
            class_4970.class_2251 blockSettings = FabricBlockSettings.copyOf(block);
            woodRegistry.log = registryHelper.blocks().registerBlock(new BaseLogAndWoodBlock(blockSettings, block), logName, class_1761.field_7931);
            return this;
        }

        public Builder wood() {
            String woodName = woodRegistry.mushroomLike ? name.method_12832() + "_hyphae" : name.method_12832() + "_wood";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22503 : class_2246.field_10178;
            class_4970.class_2251 blockSettings = FabricBlockSettings.copyOf(block);
            woodRegistry.wood = registryHelper.blocks().registerBlock(new BaseLogAndWoodBlock(blockSettings, block), woodName, class_1761.field_7931);
            return this;
        }

        public Builder strippedLog() {
            String logName = woodRegistry.mushroomLike ? name.method_12832() + "_stem" : name.method_12832() + "_log";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22112 : class_2246.field_10244;
            class_4970.class_2251 blockSettings = FabricBlockSettings.copyOf(block);
            woodRegistry.strippedLog = registryHelper.blocks().registerBlock(new BaseLogAndWoodBlock(blockSettings, block), "stripped_" + logName, class_1761.field_7931);
            return this;
        }

        public Builder strippedWood() {
            String woodName = woodRegistry.mushroomLike ? name.method_12832() + "_hyphae" : name.method_12832() + "_wood";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22504 : class_2246.field_10374;
            class_4970.class_2251 blockSettings = FabricBlockSettings.copyOf(block);
            woodRegistry.strippedWood = registryHelper.blocks().registerBlock(new BaseLogAndWoodBlock(blockSettings, block), "stripped_" + woodName, class_1761.field_7931);
            return this;
        }

        public Builder stairs() {
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22099 : class_2246.field_10616;
            woodRegistry.stairs = registryHelper.blocks().registerBlock(new StairsBaseBlock(woodRegistry.planks, block),
                name.method_12832() + "_stairs", class_1761.field_7931);
            return this;
        }

        public Builder slab() {
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22129 : class_2246.field_10500;
            woodRegistry.slab = registryHelper.blocks().registerBlock(new SlabBaseBlock(FabricBlockSettings.method_9630(woodRegistry.planks), block),
                name.method_12832() + "_slab", class_1761.field_7931);
            return this;
        }

        public Builder planks() {
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22127 : class_2246.field_10075;
            woodRegistry.planks = registryHelper.blocks().registerBlock(new BaseBlock(block, FabricBlockSettings.copyOf(class_2246.field_10161)),
                name.method_12832() + "_planks", class_1761.field_7931);
            return this;
        }

        public Builder leaves() {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            woodRegistry.leaves = registryHelper.blocks().registerBlock(woodRegistry.mushroomLike ? new WartBlockBaseBlock(block) :
                    new LeavesBaseBlock(block), name.method_12832() + leavesName,
                creativeModeTab);
            return this;
        }

        public Builder leaves(String nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            woodRegistry.leaves = registryHelper.blocks().registerBlock(new LeavesBaseBlock(block), nameIn + leavesName,
                creativeModeTab);
            return this;
        }

        public Builder leaves(String... nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (String name : nameIn) {
                woodRegistry.leaves = registryHelper.blocks().registerBlock(new LeavesBaseBlock(block), name + leavesName,
                    creativeModeTab);
                woodRegistry.availableLeaves.add(name + leavesName);
            }
            return this;
        }

        public Builder coloredLeaves() {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            woodRegistry.leaves = registryHelper.blocks().registerBlock(new LeavesBaseBlock(block), name.method_12832() + leavesName,
                creativeModeTab);
            VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leaves, true));
            return this;
        }

        public Builder coloredLeaves(int color) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            woodRegistry.leaves = registryHelper.blocks().registerBlock(new LeavesBaseBlock(block), name.method_12832() + leavesName,
                creativeModeTab);
            VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leaves, true, color));
            return this;
        }

        public Builder coloredLeaves(String nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            woodRegistry.leaves = registryHelper.blocks().registerBlock(new LeavesBaseBlock(block), nameIn + leavesName,
                creativeModeTab);
            VampireLibClient.ColoredLeaves coloredLeaves = new VampireLibClient.ColoredLeaves(woodRegistry.leaves, true);
            VampireLibClient.COLORED_LEAVES.add(coloredLeaves);
            return this;
        }

        public Builder coloredLeaves(String... nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (String name : nameIn) {
                woodRegistry.leaves = registryHelper.blocks().registerBlock(new LeavesBaseBlock(block), name + leavesName,
                    creativeModeTab);
                VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leaves, true));
				woodRegistry.availableLeaves.add(name + leavesName);
            }
            return this;
        }

        public Builder coloredLeaves(String nameIn, int color) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            woodRegistry.leaves = registryHelper.blocks().registerBlock(new LeavesBaseBlock(block), nameIn + leavesName,
                creativeModeTab);
            VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leaves, true, color));
            return this;
        }

        public Builder coloredLeaves(int color, String... nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (String name : nameIn) {
                woodRegistry.leaves = registryHelper.blocks().registerBlock(new LeavesBaseBlock(block), name + leavesName,
                    creativeModeTab);
                VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leaves, true, color));
				woodRegistry.availableLeaves.add(name + leavesName);
            }
            return this;
        }

        public Builder coloredLeaves(ColoredBlock... coloredLeavesBlocks) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_block" : "_leaves";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (ColoredBlock coloredLeavesBlock : coloredLeavesBlocks) {
                woodRegistry.leaves = registryHelper.blocks().registerBlock(new LeavesBaseBlock(block), coloredLeavesBlock.name + leavesName,
                    creativeModeTab);
                VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leaves, true, coloredLeavesBlock.color));
				woodRegistry.availableLeaves.add(coloredLeavesBlock.name + leavesName);
            }
            return this;
        }

        public Builder sapling() {
            if (!woodRegistry.mushroomLike) woodRegistry.sapling = registryHelper.blocks().registerBlock(new SaplingBaseBlock(woodRegistry.saplingGenerator),
                name.method_12832() + "_sapling", class_1761.field_7928);
            else woodRegistry.sapling = registryHelper.blocks().registerBlock(new FungusBaseBlock(woodRegistry.fungusGenerator),
                name.method_12832() + "_fungus", class_1761.field_7928);
            return this;
        }

        public Builder pottedSapling() {
			woodRegistry.pottedSapling = registryHelper.blocks().registerBlockWithoutItem("potted_" + name.method_12832() + (!woodRegistry.mushroomLike ?
				"_sapling" : "_fungus"), new FlowerPotBaseBlock(woodRegistry.sapling));
            return this;
        }

        public Builder sapling(String nameIn) {
            if (!woodRegistry.mushroomLike) woodRegistry.sapling = registryHelper.blocks().registerBlock(new SaplingBaseBlock(woodRegistry.saplingGenerator),
                nameIn + "_sapling", class_1761.field_7928);
            else woodRegistry.sapling = registryHelper.blocks().registerBlock(new FungusBaseBlock(woodRegistry.fungusGenerator),
                nameIn + "_fungus", class_1761.field_7928);
            return this;
        }

        public Builder pottedSapling(String nameIn) {
			woodRegistry.pottedSapling = registryHelper.blocks().registerBlockWithoutItem("potted_" + nameIn + (!woodRegistry.mushroomLike ?
					"_sapling" : "_fungus"), new FlowerPotBaseBlock(woodRegistry.sapling));
            return this;
        }

        public Builder saplings(String... names) {
            for (String saplingName : names) {
                if (!woodRegistry.mushroomLike) {
                    woodRegistry.sapling = registryHelper.blocks().registerBlock(new SaplingBaseBlock(woodRegistry.saplingGenerator),
                        saplingName + "_sapling", class_1761.field_7928);
                    woodRegistry.availableSaplings.add(saplingName + "_sapling");
                } else {
                    woodRegistry.sapling = registryHelper.blocks().registerBlock(new FungusBaseBlock(woodRegistry.fungusGenerator),
                        saplingName + "_fungus", class_1761.field_7928);
					woodRegistry.availableSaplings.add(saplingName + "_fungus");
                }
            }
            return this;
        }

        public Builder pottedSapling(String... names) {
            for (String saplingName : names) {
                woodRegistry.pottedSapling = registryHelper.blocks().registerBlockWithoutItem("potted_" + saplingName + (!woodRegistry.mushroomLike ? "_sapling" : "_fungus"),
					new FlowerPotBaseBlock(woodRegistry.sapling));
				woodRegistry.availablePottedSaplings.add(saplingName + (!woodRegistry.mushroomLike ? "_sapling" : "_fungus"));
            }
            return this;
        }

        public Builder fence() {
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22133 : class_2246.field_10132;
            woodRegistry.fence = registryHelper.blocks().registerBlock(new FenceBaseBlock(block, class_4970.class_2251.method_9630(woodRegistry.planks)),
                name.method_12832() + "_fence", class_1761.field_7928);
            return this;
        }

        public Builder fenceGate() {
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22097 : class_2246.field_10196;
            woodRegistry.fenceGate = registryHelper.blocks().registerBlock(new FenceGateBaseBlock(block, class_4970.class_2251.method_9630(woodRegistry.planks)),
                name.method_12832() + "_fence_gate", class_1761.field_7914);
            return this;
        }

        public Builder bookshelf() {
            woodRegistry.bookshelf = registryHelper.blocks().registerBlock(new BaseBlock(class_2246.field_10504,
                    class_4970.class_2251.method_9630(woodRegistry.planks)), name.method_12832() + "_bookshelf",
                class_1761.field_7931);
            return this;
        }

        public Builder door() {
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22103 : class_2246.field_10403;
            woodRegistry.door = registryHelper.blocks().registerBlock(new DoorBaseBlock(block, class_4970.class_2251.method_9630(woodRegistry.planks)),
                name.method_12832() + "_door", class_1761.field_7914);
            return this;
        }

        public Builder trapdoor() {
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22095 : class_2246.field_10246;
            woodRegistry.trapdoor = registryHelper.blocks().registerBlock(new TrapdoorBaseBlock(block, class_4970.class_2251.method_9630(woodRegistry.planks)),
                name.method_12832() + "_trapdoor", class_1761.field_7914);
            return this;
        }

        public Builder button() {
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22101 : class_2246.field_10493;
            woodRegistry.button = registryHelper.blocks().registerBlock(new ButtonBaseBlock(true, block, class_4970.class_2251.method_9630(woodRegistry.planks)),
                name.method_12832() + "_button", class_1761.field_7914);
            return this;
        }

        public Builder pressurePlate(class_2440.class_2441 type) {
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22131 : class_2246.field_10470;
            woodRegistry.pressurePlate = registryHelper.blocks().registerBlock(new PressurePlateBaseBlock(block, class_4970.class_2251.method_9630(woodRegistry.planks), type),
                name.method_12832() + "_pressure_plate", class_1761.field_7914);
            return this;
        }

        public Builder ladder() {
            woodRegistry.ladder = registryHelper.blocks().registerBlock(new CustomLadderBlock(),
                name.method_12832() + "_ladder", class_1761.field_7928);
            return this;
        }

        public Builder beehive() {
            woodRegistry.beehive = registryHelper.blocks().registerBlock(new BaseBeehiveBlock(class_4970.class_2251.method_9630(class_2246.field_20422)),
                name.method_12832() + "_beehive", class_1761.field_7928);
            ((IBlockEntityType) class_2591.field_20431).vl_addBlocks(woodRegistry.beehive);
            return this;
        }

        public Builder sign() {
            class_2248 baseBlock = woodRegistry.mushroomLike ? class_2246.field_22105 : class_2246.field_10330;

            class_2960 signTexture = new class_2960(name.method_12836(), "wood_types/" + name.method_12832() + "/sign");
            woodRegistry.sign = registryHelper.blocks().registerBlockWithoutItem(name.method_12832() + "_sign", new ExpandedTerraformSignBlock(baseBlock, signTexture, FabricBlockSettings.copyOf(class_2246.field_10121)));
            woodRegistry.wallSign = registryHelper.blocks().registerBlockWithoutItem(name.method_12832() + "_wall_sign", new TerraformWallSignBlock(signTexture, FabricBlockSettings.copyOf(class_2246.field_10187)));
            woodRegistry.signItem = registryHelper.items().registerItem(name.method_12832() + "_sign", new class_1822(new class_1792.class_1793().method_7895(16).method_7892(class_1761.field_7928), woodRegistry.sign, woodRegistry.wallSign));
            ((IBlockEntityType) class_2591.field_11911).vl_addBlocks(woodRegistry.sign, woodRegistry.wallSign);
            return this;
        }

        public Builder boat() {
			woodRegistry.boatItem = TerraformBoatItemHelper.registerBoatItem(Utils.appendToPath(name, "_boat"), () -> woodRegistry.boatType, false);
            woodRegistry.chestBoatItem = TerraformBoatItemHelper.registerBoatItem(Utils.appendToPath(name, "_chest_boat"), () -> woodRegistry.boatType, true);
			woodRegistry.boatType = class_2378.method_10230(TerraformBoatTypeRegistry.INSTANCE, name, new TerraformBoatType.Builder().item(woodRegistry.boatItem).chestItem(woodRegistry.chestBoatItem).build());
			if (FabricLoader.getInstance().getEnvironmentType().equals(EnvType.CLIENT)) {
                TerraformBoatClientHelper.registerModelLayers(name);
            }
            return this;
        }

        public Builder leafCarpet() {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
            woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, name.method_12832() + leavesName, creativeModeTab);
            return this;
        }

        public Builder leafCarpet(String nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
            woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, nameIn + leavesName, creativeModeTab);
            return this;
        }

        public Builder leafCarpet(String... nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (String name : nameIn) {
                class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
                class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
                woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, name + leavesName, creativeModeTab);
                woodRegistry.availableLeafCarpets.add(name + leavesName);
            }
            return this;
        }

        public Builder coloredLeafCarpet() {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
            woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, name.method_12832() + leavesName, creativeModeTab);
            VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafCarpet, true));
            return this;
        }

        public Builder coloredLeafCarpet(int color) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
            woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, name.method_12832() + leavesName, creativeModeTab);
            VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafCarpet, true, color));
            return this;
        }

        public Builder coloredLeafCarpet(String nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
            woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, nameIn + leavesName, creativeModeTab);
            VampireLibClient.ColoredLeaves coloredLeaves = new VampireLibClient.ColoredLeaves(woodRegistry.leafCarpet, true);
            VampireLibClient.COLORED_LEAVES.add(coloredLeaves);
            return this;
        }

        public Builder coloredLeafCarpet(String... nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (String name : nameIn) {
                class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
                class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
                woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, name + leavesName, creativeModeTab);
                VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafCarpet, true));
                woodRegistry.availableLeafCarpets.add(name + leavesName);
            }
            return this;
        }

        public Builder coloredLeafCarpet(String nameIn, int color) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
            woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, nameIn + leavesName, creativeModeTab);
            VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafCarpet, true, color));
            return this;
        }

        public Builder coloredLeafCarpet(int color, String... nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (String name : nameIn) {
                class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
                class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
                woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, name + leavesName, creativeModeTab);
                VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafCarpet, true, color));
                woodRegistry.availableLeafCarpets.add(name + leavesName);
            }
            return this;
        }

        public Builder coloredLeafCarpet(ColoredBlock... coloredLeavesBlocks) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_carpet" : "_leaf_carpet";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (ColoredBlock coloredLeavesBlock : coloredLeavesBlocks) {
                class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
                class_2248 carpet = woodRegistry.mushroomLike ? new LeafCarpetBlock(properties) : new WaterloggedLeafCarpetBlock(properties);
                woodRegistry.leafCarpet = registryHelper.blocks().registerBlock(carpet, coloredLeavesBlock.name + leavesName, creativeModeTab);
                VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafCarpet, true,
                    coloredLeavesBlock.color));
                woodRegistry.availableLeafCarpets.add(coloredLeavesBlock.name + leavesName);
            }
            return this;
        }

        public Builder leafPile() {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
            woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, name.method_12832() + leavesName, creativeModeTab);
            return this;
        }

        public Builder leafPile(String nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
            woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, nameIn + leavesName, creativeModeTab);
            return this;
        }

        public Builder leafPile(String... nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (String name : nameIn) {
                class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
                class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
                woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, name + leavesName, creativeModeTab);
                woodRegistry.availableLeafPiles.add(name + leavesName);
            }
            return this;
        }

        public Builder coloredLeafPile() {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
            woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, name.method_12832() + leavesName, creativeModeTab);
            VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafPile, true));
            return this;
        }

        public Builder coloredLeafPile(int color) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
            woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, name.method_12832() + leavesName, creativeModeTab);
            VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafPile, true, color));
            return this;
        }

        public Builder coloredLeafPile(String nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
            woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, nameIn + leavesName, creativeModeTab);
            VampireLibClient.ColoredLeaves coloredLeaves = new VampireLibClient.ColoredLeaves(woodRegistry.leafPile, true);
            VampireLibClient.COLORED_LEAVES.add(coloredLeaves);
            return this;
        }

        public Builder coloredLeafPile(String... nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (String name : nameIn) {
                class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
                class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
                woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, name + leavesName, creativeModeTab);
                VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafPile, true));
                woodRegistry.availableLeafPiles.add(name + leavesName);
            }
            return this;
        }

        public Builder coloredLeafPile(String nameIn, int color) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
            class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
            woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, nameIn + leavesName, creativeModeTab);
            VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafPile, true, color));
            return this;
        }

        public Builder coloredLeafPile(int color, String... nameIn) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (String name : nameIn) {
                class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
                class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
                woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, name + leavesName, creativeModeTab);
                VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafPile, true, color));
                woodRegistry.availableLeafPiles.add(name + leavesName);
            }
            return this;
        }

        public Builder coloredLeafPile(ColoredBlock... coloredLeavesBlocks) {
            String leavesName = woodRegistry.mushroomLike ? "_wart_pile" : "_leaf_pile";
            class_2248 block = woodRegistry.mushroomLike ? class_2246.field_22115 : class_2246.field_28674;
            class_1761 creativeModeTab = woodRegistry.mushroomLike ? class_1761.field_7931 : class_1761.field_7928;
            for (ColoredBlock coloredLeavesBlock : coloredLeavesBlocks) {
                class_4970.class_2251 properties = class_4970.class_2251.method_9630(block);
                class_2248 carpet = woodRegistry.mushroomLike ? new LeafPileBlock(properties) : new WaterloggedLeafPileBlock(properties);
                woodRegistry.leafPile = registryHelper.blocks().registerBlock(carpet, coloredLeavesBlock.name + leavesName, creativeModeTab);
                VampireLibClient.COLORED_LEAVES.add(new VampireLibClient.ColoredLeaves(woodRegistry.leafPile, true,
                    coloredLeavesBlock.color));
                woodRegistry.availableLeafPiles.add(coloredLeavesBlock.name + leavesName);
            }
            return this;
        }

        public Builder nonFlammable() {
            woodRegistry.flammable = false;
            return this;
        }

        public Builder mushroomLike() {
            woodRegistry.mushroomLike = true;
            return this;
        }

        public Builder defaultLogsAndWoods() {
            return this.log().strippedLog().wood().strippedWood();
        }

        public Builder defaultBlocks() {
            return this.defaultLogsAndWoods().planks().leaves().leafCarpet().leafPile().sapling().pottedSapling();
        }

        public Builder defaultExtras() {
            return this.fence().fenceGate().stairs().slab().door().trapdoor().button()
                .pressurePlate(class_2440.class_2441.field_11361).sign().boat();
        }

        public Builder defaultBlocksColoredLeaves() {
            return this.defaultLogsAndWoods().planks().coloredLeaves().coloredLeafCarpet().coloredLeafPile().sapling().pottedSapling();
        }

        public Builder defaultBlocksColoredLeaves(int color) {
            return this.defaultLogsAndWoods().planks().coloredLeaves(color).coloredLeafCarpet(color).coloredLeafPile(color).sapling().pottedSapling();
        }

        public WoodRegistry build() {
            if (woodRegistry.leaves != null && !woodRegistry.mushroomLike)
                class_3962.field_17566.put(woodRegistry.leaves, 0.3F);
            if (woodRegistry.leafCarpet != null && !woodRegistry.mushroomLike)
                class_3962.field_17566.put(woodRegistry.leafCarpet, 0.3F);
            if (woodRegistry.leafPile != null && !woodRegistry.mushroomLike)
                class_3962.field_17566.put(woodRegistry.leafPile, 0.3F);
            if (woodRegistry.flammable) {
                // flammable blocks
                int baseBurnChance = 5;
                int largeBurnChance = baseBurnChance * 6;

                int baseSpreadChance = 20;
                int smallSpreadChance = baseSpreadChance / 4;
                int largeSpreadChance = baseSpreadChance * 3;

                FlammableBlockRegistry flammableBlockRegistry = FlammableBlockRegistry.getDefaultInstance();
                if (woodRegistry.planks != null && !preRegisteredPlanks)
                    flammableBlockRegistry.add(woodRegistry.planks, baseBurnChance, baseSpreadChance);
                if (woodRegistry.slab != null)
                    flammableBlockRegistry.add(woodRegistry.slab, baseBurnChance, baseSpreadChance);
                if (woodRegistry.fenceGate != null)
                    flammableBlockRegistry.add(woodRegistry.fenceGate, baseBurnChance, baseSpreadChance);
                if (woodRegistry.fence != null)
                    flammableBlockRegistry.add(woodRegistry.fence, baseBurnChance, baseSpreadChance);
                if (woodRegistry.stairs != null)
                    flammableBlockRegistry.add(woodRegistry.stairs, baseBurnChance, baseSpreadChance);
                if (woodRegistry.log != null)
                    flammableBlockRegistry.add(woodRegistry.log, baseBurnChance, smallSpreadChance);
                if (woodRegistry.strippedLog != null)
                    flammableBlockRegistry.add(woodRegistry.strippedLog, baseBurnChance, smallSpreadChance);
                if (woodRegistry.strippedWood != null)
                    flammableBlockRegistry.add(woodRegistry.strippedWood, baseBurnChance, smallSpreadChance);
                if (woodRegistry.wood != null)
                    flammableBlockRegistry.add(woodRegistry.wood, baseBurnChance, smallSpreadChance);
                if (woodRegistry.leaves != null)
                    flammableBlockRegistry.add(woodRegistry.leaves, largeBurnChance, largeSpreadChance);
                if (woodRegistry.leafCarpet != null)
                    flammableBlockRegistry.add(woodRegistry.leafCarpet, largeBurnChance, largeSpreadChance);
                if (woodRegistry.leafPile != null)
                    flammableBlockRegistry.add(woodRegistry.leafPile, largeBurnChance, largeSpreadChance);

                // fuel registering
                int fenceFuelTime = 300;

                FuelRegistry fuelRegistry = FuelRegistry.INSTANCE;
                if (woodRegistry.fence != null)
                    fuelRegistry.add(woodRegistry.fence, fenceFuelTime);
                if (woodRegistry.fenceGate != null)
                    fuelRegistry.add(woodRegistry.fenceGate, fenceFuelTime);
            }

            if (woodRegistry.log != null && woodRegistry.wood != null && woodRegistry.strippedLog != null && woodRegistry.strippedWood != null) {
                StrippableBlockRegistry.register(woodRegistry.log, woodRegistry.strippedLog);
                StrippableBlockRegistry.register(woodRegistry.wood, woodRegistry.strippedWood);
            }

            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                if (woodRegistry.leaves != null) {
                    BlockRenderLayerMapImpl.INSTANCE.putBlock(woodRegistry.leaves, class_1921.method_23579());
                }
                if (woodRegistry.leafCarpet != null) {
                    BlockRenderLayerMapImpl.INSTANCE.putBlock(woodRegistry.leafCarpet, class_1921.method_23579());
                }
                if (woodRegistry.leafPile != null) {
                    BlockRenderLayerMapImpl.INSTANCE.putBlock(woodRegistry.leafPile, class_1921.method_23579());
                }
                if (woodRegistry.sapling != null) {
                    BlockRenderLayerMapImpl.INSTANCE.putBlock(woodRegistry.sapling, class_1921.method_23579());
                }
                if (woodRegistry.door != null) {
                    BlockRenderLayerMapImpl.INSTANCE.putBlock(woodRegistry.door, class_1921.method_23579());
                }
                if (woodRegistry.trapdoor != null) {
                    BlockRenderLayerMapImpl.INSTANCE.putBlock(woodRegistry.trapdoor, class_1921.method_23579());
                }
            }

            return woodRegistry;
        }
    }

    public record ColoredBlock(String name, int color) {}

}