package net.devtech.arrp.json.iteminfo;

import com.google.gson.JsonObject;
import net.devtech.arrp.json.iteminfo.model.JItemModel;

/**
 * an item model info, static import this class
 */
public class JItemInfo implements Cloneable {
	private JItemModel model;
	private Boolean handAnimationOnSwap;

	// Default constructor
	public JItemInfo() {}

	public JItemInfo(JItemModel model) {
		this.model = model;
	}

	// Static factory method to start building
	public static JItemInfo item() {
		return new JItemInfo();
	}

	// Fluent methods for setting properties
	public JItemInfo model(JItemModel model) {
		this.model = model;
		return this;
	}

	public JItemInfo handAnimationOnSwap(boolean handAnimationOnSwap) {
		this.handAnimationOnSwap = handAnimationOnSwap;
		return this;
	}

	// Getter and Setter for 'model'
	public JItemModel getModel() {
		return model;
	}

	public boolean isHandAnimationOnSwap() {
		return handAnimationOnSwap;
	}

	// Implement toJson method
	public JsonObject toJson() {
		JsonObject json = new JsonObject();
		if (model != null) {
			json.add("model", model.toJson());
		}
		if (handAnimationOnSwap != null) {
			json.addProperty("handAnimationOnSwap", handAnimationOnSwap);
		}
		return json;
	}

	@Override
	public JItemInfo clone() {
		try {
			JItemInfo cloned = (JItemInfo) super.clone();
			cloned.model = model != null ? model.clone() : null;
			return cloned;
		} catch (CloneNotSupportedException e) {
			throw new InternalError(e);
		}
	}
}
