package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.devtech.arrp.json.iteminfo.tint.JTint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Abstract base class for different model types.
 */
public abstract class JItemModel implements Cloneable {
    protected String type;
    protected List<JTint> tints;
    protected JItemModel fallback;

    public JItemModel() {
    }

    protected JItemModel(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public JItemModel getFallback() {
        return fallback;
    }

    // Fluent method to set the fallback model
    public JItemModel fallback(JItemModel fallback) {
        this.fallback = fallback;
        return this;
    }

    // Static factory methods for different model types
    public static JModelBasic model(String model) {
        return new JModelBasic(model);
    }

    public static JModelRangeDispatch rangeDispatch() {
        return new JModelRangeDispatch();
    }

    public static JModelComposite composite() {
        return new JModelComposite();
    }

    public static JModelCondition condition() {
        return new JModelCondition();
    }

    public static JModelSelect select() {
        return new JModelSelect();
    }

    public static JModelEmpty empty() {
        return new JModelEmpty();
    }

    public List<JTint> getTints() {
        return tints;
    }

    public JItemModel tints(JTint... tints) {
        this.tints = Arrays.stream(tints).toList();
        return this;
    }

    public JItemModel tint(JTint tint) {
        if (tints == null) this.tints = new ArrayList<>();
        this.tints.add(tint);
        return this;
    }

	// Abstract method to convert to JSON
	public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", type);

        if (tints != null) {
            JsonArray tintsArray = new JsonArray();
            for (JTint tint : tints) {
                tintsArray.add(tint.toJson());
            }
            json.add("tints", tintsArray);
        }

        if (fallback != null) json.add("fallback", fallback.toJson());

		return null;
	}

	public abstract JItemModel clone();
}
