package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonObject;
import net.devtech.arrp.json.iteminfo.tint.JTint;

/**
 * Represents a basic model type "minecraft:model".
 */
public class JModelBasic extends JItemModel {
    private String model;

    public JModelBasic() {
        super("minecraft:model");
    }

    public JModelBasic(String model) {
        this();
        this.model = model;
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("model", this.model);
        return jsonObject;
    }

    public static JModelBasic of(String model) {
        return new JModelBasic(model);
    }

    // Getters and Setters
    public String getModel() {
        return model;
    }

    @Override
    public JModelBasic clone() {
        JModelBasic cloned = new JModelBasic(this.model);
        for (JTint tint : this.tints) {
            cloned.tint(tint.clone());
        }
        return cloned;
    }
}
