package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonObject;
import net.devtech.arrp.json.iteminfo.tint.JTint;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a composite model type "minecraft:composite".
 */
public class JModelComposite extends JItemModel {
    private List<JItemModel> models;

    public JModelComposite() {
        super("minecraft:composite");
        this.models = new ArrayList<>();
    }

    @Override
    public JsonObject toJson() {
        return null;
    }

    // Getters and Setters
    public List<JItemModel> getModels() {
        return models;
    }

    public JModelComposite models(List<JItemModel> models) {
        this.models = models;
        return this;
    }

    public JModelComposite model(JItemModel model) {
        this.models.add(model);
        return this;
    }

    @Override
    public JModelComposite clone() {
        JModelComposite cloned = new JModelComposite();
        for (JItemModel model : this.models) {
            cloned.model((model != null) ? model.clone() : null);
        }
        for (JTint tint : this.tints) {
            cloned.tint(tint.clone());
        }
        return cloned;
    }
}
