package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonObject;
import net.devtech.arrp.json.iteminfo.property.JProperty;
import net.devtech.arrp.json.iteminfo.tint.JTint;

/**
 * Represents a condition model type "minecraft:condition".
 */
public class JModelCondition extends JItemModel {
    private JProperty property;
    private JItemModel onTrue;
    private JItemModel onFalse;

    public JModelCondition() {
        super("minecraft:condition");
    }

    public JModelCondition property(JProperty property) {
        this.property = property;
        return this;
    }

    public JModelCondition onTrue(JItemModel onTrue) {
        this.onTrue = onTrue;
        return this;
    }

    public JModelCondition onFalse(JItemModel onFalse) {
        this.onFalse = onFalse;
        return this;
    }

    public JProperty getProperty() {
        return property;
    }

    public JItemModel getOnTrue() {
        return onTrue;
    }

    public JItemModel getOnFalse() {
        return onFalse;
    }

    // Implement toJson method
    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        // Inline the property serialization
        if (property != null) {
            JsonObject propertyJson = property.toJson();
            for (String key : propertyJson.keySet()) {
                json.add(key, propertyJson.get(key));
            }
        }

        if (onTrue != null) {
            json.add("on_true", onTrue.toJson());
        }
        if (onFalse != null) {
            json.add("on_false", onFalse.toJson());
        }
        return json;
    }

    @Override
    public JModelCondition clone() {
        JModelCondition cloned = new JModelCondition();
        cloned.property = this.property; // Assuming properties are immutable or shared
        cloned.onTrue = (this.onTrue != null) ? this.onTrue.clone() : null;
        cloned.onFalse = (this.onFalse != null) ? this.onFalse.clone() : null;
        for (JTint tint : this.tints) {
            cloned.tint(tint.clone());
        }
        return cloned;
    }
}
