package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.devtech.arrp.json.iteminfo.property.JProperty;
import net.devtech.arrp.json.iteminfo.tint.JTint;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a range dispatch model type "minecraft:range_dispatch".
 */
public class JModelRangeDispatch extends JItemModel {
    private JProperty property;
    private double scale = 1.0;
    private List<JRangeEntry> entries;

    public JModelRangeDispatch() {
        super("minecraft:range_dispatch");
        this.entries = new ArrayList<>();
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:range_dispatch");

        // Only add 'scale' if it's not 1.0
        if (this.scale != 1.0) {
            json.addProperty("scale", this.scale);
        }

        if (property != null) {
            JsonObject propertyJson = property.toJson();
            for (String key : propertyJson.keySet()) {
                json.add(key, propertyJson.get(key));
            }
        }

        // Add other properties here
        json.add("entries", serializeEntries());

        return json;
    }

    private JsonArray serializeEntries() {
        JsonArray entriesArray = new JsonArray();

        for (JRangeEntry entry : this.entries) {
            entriesArray.add(entry.toJson());
        }

        return entriesArray;
    }

    // Getters and Setters
    public JProperty getProperty() {
        return property;
    }

    public JModelRangeDispatch property(JProperty property) {
        this.property = property;
        return this;
    }

    public double getScale() {
        return scale;
    }

    public JModelRangeDispatch scale(double scale) {
        this.scale = scale;
        return this;
    }

    public List<JRangeEntry> getEntries() {
        return entries;
    }

    public JModelRangeDispatch entries(List<JRangeEntry> entries) {
        this.entries = entries;
        return this;
    }

    public JModelRangeDispatch entry(JRangeEntry entry) {
        this.entries.add(entry);
        return this;
    }

    @Override
    public JModelRangeDispatch clone() {
        JModelRangeDispatch cloned = new JModelRangeDispatch();
        cloned.property = this.property;
        cloned.scale = this.scale;
        cloned.fallback = (this.fallback != null) ? this.fallback.clone() : null;
        for (JRangeEntry entry : this.entries) {
            cloned.entry(entry.clone());
        }
        for (JTint tint : this.tints) {
            cloned.tint(tint.clone());
        }
        return cloned;
    }
}
