package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.devtech.arrp.json.iteminfo.property.JProperty;
import net.devtech.arrp.json.iteminfo.tint.JTint;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a select model type "minecraft:select".
 */
public class JModelSelect extends JItemModel {
    private JProperty property;
    private List<JSelectCase> cases;

    public JModelSelect() {
        super("minecraft:select");
        this.cases = new ArrayList<>();
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        if (json != null) {
            // Inline the property serialization
            if (property != null) {
                JsonObject propertyJson = property.toJson();
                for (String key : propertyJson.keySet()) {
                    json.add(key, propertyJson.get(key));
                }
            }

            if (!cases.isEmpty()) {
                JsonArray casesArray = new JsonArray();
                for (JSelectCase selectCase : cases) {
                    casesArray.add(selectCase.toJson());
                }
                json.add("cases", casesArray);
            }
        } else {
            json = new JsonObject();
            json.addProperty("type", this.getType());

            // Inline the property serialization
            if (property != null) {
                JsonObject propertyJson = property.toJson();
                for (String key : propertyJson.keySet()) {
                    json.add(key, propertyJson.get(key));
                }
            }

            if (!cases.isEmpty()) {
                JsonArray casesArray = new JsonArray();
                for (JSelectCase selectCase : cases) {
                    casesArray.add(selectCase.toJson());
                }
                json.add("cases", casesArray);
            }

            if (fallback != null) {
                json.add("fallback", fallback.toJson());
            }
        }

        return json;
    }

    // Getters and Setters
    public JProperty getProperty() {
        return property;
    }

    public JModelSelect property(JProperty property) {
        this.property = property;
        return this;
    }

    public List<JSelectCase> getCases() {
        return cases;
    }

    public JModelSelect cases(List<JSelectCase> cases) {
        this.cases = cases;
        return this;
    }

    public JModelSelect addCase(JSelectCase selectCase) {
        this.cases.add(selectCase);
        return this;
    }

    @Override
    public JModelSelect clone() {
        JModelSelect cloned = new JModelSelect();
        cloned.property = this.property; // Assuming properties are immutable or shared
        for (JSelectCase selectCase : this.cases) {
            cloned.addCase((selectCase != null) ? selectCase.clone() : null);
        }
        cloned.fallback = (this.fallback != null) ? this.fallback.clone() : null;
        for (JTint tint : this.tints) {
            cloned.tint(tint.clone());
        }
        return cloned;
    }
}
