package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a range dispatch model type.
 */
public class JRangeDispatch extends JItemModel {
    private List<JRangeEntry> entries;
    private double period;
    private String property;
    private double scale;

    public JRangeDispatch() {
        super("minecraft:range_dispatch");
        this.entries = new ArrayList<>();
    }

    @Override
    public JsonObject toJson() {
        return null;
    }

    // Getters and Setters
    public List<JRangeEntry> getEntries() {
        return entries;
    }

    public JRangeDispatch entries(List<JRangeEntry> entries) {
        this.entries = entries;
        return this;
    }

    public JRangeDispatch entry(JRangeEntry entry) {
        this.entries.add(entry);
        return this;
    }

    public double getPeriod() {
        return period;
    }

    public JRangeDispatch period(double period) {
        this.period = period;
        return this;
    }

    public String getProperty() {
        return property;
    }

    public JRangeDispatch property(String property) {
        this.property = property;
        return this;
    }

    public double getScale() {
        return scale;
    }

    public JRangeDispatch scale(double scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public JRangeDispatch clone() {
        JRangeDispatch cloned = new JRangeDispatch()
            .period(this.period)
            .property(this.property)
            .scale(this.scale);
        cloned.fallback(this.fallback != null ? this.fallback.clone() : null);
        for (JRangeEntry entry : this.entries) {
            cloned.entry(entry.clone());
        }
        return cloned;
    }
}
