package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonObject;

/**
 * Represents an entry in a range dispatch model.
 */
public class JRangeEntry implements Cloneable {
    private double threshold;
    private JItemModel model;

    public JRangeEntry() {}

    public JRangeEntry(double threshold, JItemModel model) {
        this.threshold = threshold;
        this.model = model;
    }

    public static JRangeEntry of(double threshold, JItemModel model) {
        return new JRangeEntry(threshold, model);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("threshold", threshold);
        json.add("model", model.toJson());
        return json;
    }

    // Getters and Setters
    public double getThreshold() {
        return threshold;
    }

    public JItemModel getModel() {
        return model;
    }

    @Override
    public JRangeEntry clone() {
        return new JRangeEntry(this.threshold, (this.model != null) ? this.model.clone() : null);
    }
}
