package net.devtech.arrp.json.iteminfo.model;

import com.google.gson.JsonObject;

/**
 * Represents a case in a select model.
 */
public class JSelectCase implements Cloneable {
    private Object when; // Can be a single value or a list of values
    private JItemModel model;

    public JSelectCase() {}

    public JSelectCase(Object when, JItemModel model) {
        this.when = when;
        this.model = model;
    }

    public static JSelectCase of(Object when, JItemModel model) {
        return new JSelectCase(when, model);
    }

    // Getters and Setters
    public Object getWhen() {
        return when;
    }

    public JItemModel getModel() {
        return model;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (when != null) {
			switch (when) {
				case String s -> json.addProperty("when", s);
				case Number i -> json.addProperty("when", i);
				case Boolean b -> json.addProperty("when", b);
				default -> throw new IllegalArgumentException("Unsupported type for 'when'");
			}
        }
        if (model != null) {
            json.add("model", model.toJson());
        }
        return json;
    }

    @Override
    public JSelectCase clone() {
        JSelectCase cloned = new JSelectCase();
        cloned.when = this.when;
        cloned.model = (this.model != null) ? this.model.clone() : null;
        return cloned;
    }
}
