package net.devtech.arrp.json.iteminfo.model.special;

/**
 * Represents the "minecraft:head" special model type.
 */
public class JModelHead extends JModelSpecial {
    private String kind;      // skeleton, wither_skeleton, player, etc.
    private float animation = 0.0f; // Default: 0.0

    public JModelHead() {
        super("minecraft:head");
    }

    // Getters and Setters
    public String getKind() {
        return kind;
    }

    public JModelHead kind(String kind) {
        this.kind = kind;
        return this;
    }

    public float getAnimation() {
        return animation;
    }

    public JModelHead animation(float animation) {
        this.animation = animation;
        return this;
    }

    @Override
    public JModelHead clone() {
        JModelHead cloned = new JModelHead();
        cloned.base(this.getBase());
        cloned.kind(this.kind);
        cloned.animation(this.animation);
        return cloned;
    }
}
