package net.devtech.arrp.json.iteminfo.model.special;

import com.google.gson.JsonObject;

/**
 * Represents the "minecraft:shield" special model type.
 */
public class JModelShield extends JModelSpecial {
    private String pattern;  // Pattern texture
    private String baseTexture; // Base texture

    protected JModelShield() {
        super("minecraft:shield");
    }

    // Fluent methods
    public JModelShield pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public JModelShield baseTexture(String baseTexture) {
        this.baseTexture = baseTexture;
        return this;
    }

    // Getters
    public String getPattern() {
        return pattern;
    }

    public String getBaseTexture() {
        return baseTexture;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getSpecialType());
        return json;
    }

    @Override
    public JModelShield clone() {
        JModelShield cloned = new JModelShield();
        cloned.base(this.getBase());
        cloned.model((this.getModel() != null) ? this.getModel().clone() : null);
        cloned.pattern = this.pattern;
        cloned.baseTexture = this.baseTexture;
        return cloned;
    }
}
