package net.devtech.arrp.json.iteminfo.model.special;

import com.google.gson.JsonObject;
import net.devtech.arrp.json.iteminfo.model.JItemModel;

/**
 * Abstract base class for special model types "minecraft:special".
 */
public class JModelSpecial extends JItemModel {
    private String base;  // Optional base model
    private JItemModel model; // Nested model
    private String specialType;

    public JModelSpecial() {
        super("minecraft:special");
    }

    protected JModelSpecial(String specialType) {
        super("minecraft:special");
        this.specialType = specialType;
    }

    public static JModelSpecial specialModel(String base, JItemModel special) {
        return new JModelSpecial().base(base).model(special);
    }

    public static JModelShield shield() {
        return new JModelShield();
    }

    public String getSpecialType() {
        return specialType;
    }

    public static JModelHead head() {
        return new JModelHead();
    }

    // Fluent methods
    public JModelSpecial base(String base) {
        this.base = base;
        return this;
    }

    public JModelSpecial model(JItemModel model) {
        this.model = model;
        return this;
    }

    // Getters
    public String getBase() {
        return base;
    }

    public JItemModel getModel() {
        return model;
    }

    // Implement toJson method
    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        if (base != null) {
            json.addProperty("base", base);
        }
        if (model != null) {
            json.add("model", model.toJson());
        }
        return json;
    }

    @Override
    public JModelSpecial clone() {
        JModelSpecial cloned = new JModelSpecial();
        cloned.base = this.base;
        cloned.model = (this.model != null) ? this.model.clone() : null;
        return cloned;
    }
}
