package net.devtech.arrp.json.iteminfo.property;

import com.google.gson.JsonObject;

/**
 * Abstract base class for properties.
 */
public abstract class JProperty {
    private final String type;

    protected JProperty(String type) {
        this.type = type;
    }

    // Getter
    public String getPropertyType() {
        return type;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("property", this.getPropertyType());
        return json;
    }
}
