package net.devtech.arrp.json.iteminfo.property;

/**
 * Represents the "minecraft:angle" numeric property.
 */
public class JPropertyAngle extends JProperty {
    private boolean wobble = true; // Default is true

    protected JPropertyAngle() {
        super("minecraft:angle");
    }

    // Static factory method
    public static JPropertyAngle angle() {
        return new JPropertyAngle();
    }

    // Fluent method
    public JPropertyAngle wobble(boolean wobble) {
        this.wobble = wobble;
        return this;
    }

    // Getter
    public boolean isWobble() {
        return wobble;
    }
}
