package net.devtech.arrp.json.iteminfo.property;

import java.util.HashMap;
import java.util.Map;

/**
 * Represents the "block_state" property.
 */
public class JPropertyBlockState extends JProperty {
    private final Map<String, String> properties = new HashMap<>();

    protected JPropertyBlockState() {
        super("minecraft:block_state");
    }

    // Static factory method
    public static JPropertyBlockState blockState() {
        return new JPropertyBlockState();
    }

    // Fluent method to add a block state property
    public JPropertyBlockState property(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    // Getter
    public Map<String, String> getProperties() {
        return properties;
    }
}
