package net.devtech.arrp.json.iteminfo.property;

import com.google.gson.JsonObject;

/**
 * Represents the "minecraft:compass" numeric property.
 */
public class JPropertyCompass extends JProperty {
    private String target; // Default value
    private boolean wobble;   // Default: true

    public JPropertyCompass() {
        super("minecraft:compass");
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("target", target);
        json.addProperty("wobble", wobble);
        return json;
    }

    // Getters and Setters
    public String getTarget() {
        return target;
    }

    /**
     * Sets the target for the compass.
     * Possible values: "spawn", "lodestone", "recovery", "none"
     */
    public JPropertyCompass target(String target) {
        this.target = target;
        return this;
    }

    public boolean isWobble() {
        return wobble;
    }

    public JPropertyCompass wobble(boolean wobble) {
        this.wobble = wobble;
        return this;
    }
}
