package net.devtech.arrp.json.iteminfo.property;

import com.google.gson.JsonObject;

/**
 * Represents the "minecraft:component" select property.
 */
public class JPropertyComponent extends JProperty {
    private String component;

    public JPropertyComponent() {
        super("minecraft:component");
    }

    /**
     * Creates a new JPropertyComponent for a specific component name.
     *
     * @param componentName The name of the component (e.g., "minecraft:item_name").
     */
    public static JPropertyComponent component(String componentName) {
        JPropertyComponent property = new JPropertyComponent();
        property.component = componentName;
        return property;
    }



    public String getComponent() {
        return component;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("component", component);
        return json;
    }
}
