package net.devtech.arrp.json.iteminfo.property;

import com.google.gson.JsonObject;

/**
 * Represents the "minecraft:has_component" boolean property.
 */
public class JPropertyHasComponent extends JProperty {
    private final String component;
    private boolean ignoreDefault = false; // Default: false

    public JPropertyHasComponent(String component) {
        super("minecraft:has_component");
        this.component = component;
    }

    public static JPropertyHasComponent of(String component) {
        return new JPropertyHasComponent(component);
    }

    // Getter and Setter
    public String getComponent() {
        return component;
    }

    public boolean isIgnoreDefault() {
        return ignoreDefault;
    }

    public JPropertyHasComponent ignoreDefault(boolean ignoreDefault) {
        this.ignoreDefault = ignoreDefault;
        return this;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("component", component);
        if (ignoreDefault) json.addProperty("ignore_default", ignoreDefault);
        return super.toJson();
    }
}
