package net.devtech.arrp.json.iteminfo.property;

/**
 * Represents the "minecraft:use_cycle" numeric property.
 */
public class JPropertyUseCycle extends JProperty {
    private float period = 1.0f; // Default period is 1.0

    protected JPropertyUseCycle() {
        super("minecraft:use_cycle");
    }

    // Static factory method
    public static JPropertyUseCycle useCycle() {
        return new JPropertyUseCycle();
    }

    // Fluent method
    /**
     * Sets the period for the use cycle.
     * 
     * @param period The period in ticks for the cycle.
     * @return The current instance for method chaining.
     */
    public JPropertyUseCycle period(float period) {
        this.period = period;
        return this;
    }

    // Getter
    public float getPeriod() {
        return period;
    }
}
