package net.devtech.arrp.json.iteminfo.property;

/**
 * Represents the "minecraft:use_duration" numeric property.
 */
public class JPropertyUseDuration extends JProperty {
    private boolean remaining = false; // Default is false

    protected JPropertyUseDuration() {
        super("minecraft:use_duration");
    }

    // Static factory method
    public static JPropertyUseDuration useDuration() {
        return new JPropertyUseDuration();
    }

    // Fluent method
    /**
     * Sets whether to use the remaining use duration.
     *
     * @param remaining True to use remaining use duration, false to use total use duration.
     * @return The current instance for method chaining.
     */
    public JPropertyUseDuration remaining(boolean remaining) {
        this.remaining = remaining;
        return this;
    }

    // Getter
    public boolean isRemaining() {
        return remaining;
    }
}
